/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository;

import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.repository.internal.ButtonRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ButtonRepository
extends ButtonRepositoryCustom,
JpaRepository<ButtonEntity, String>,
JpaSpecificationExecutor<ButtonEntity> {
    @Modifying
    @Query(value="insert into engine_button_competence_mapping(button_id,competence_id) values (:buttonId,:competenceId)", nativeQuery=true)
    public void bindCompetence(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Modifying
    @Query(value="delete from engine_button_competence_mapping where button_id = :buttonId and competence_id = :competenceId", nativeQuery=true)
    public void unbindCompetence(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Modifying
    @Query(value="delete from engine_button_competence_mapping where button_id = :buttonId", nativeQuery=true)
    public void unbindAllByButtonId(@Param(value="buttonId") String var1);

    @Modifying
    @Query(value="delete from engine_button_competence_mapping where competence_id = :competenceId", nativeQuery=true)
    public void unbindAllByCompetenceId(@Param(value="competenceId") String var1);

    @Query(value="select count(*) from engine_button_competence_mapping where button_id = :buttonId and competence_id = :competenceId", nativeQuery=true)
    public long countByCompetenceIdAndButtonId(@Param(value="buttonId") String var1, @Param(value="competenceId") String var2);

    @Query(value="select count(b.id) from ButtonEntity b where b.code = :code and b.id <> :id")
    public long countByCodeWithoutId(@Param(value="code") String var1, @Param(value="id") String var2);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.roleMappings rmp  left join fetch b.competences c ")
    public List<ButtonEntity> findAll();

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.roleMappings rmp  left join fetch b.competences c  where b.code = :code ")
    public ButtonEntity findByCode(@Param(value="code") String var1);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.roleMappings rmp  left join fetch b.competences c  where c.code = :competenceCode ")
    public List<ButtonEntity> findByCompetenceCode(@Param(value="competenceCode") String var1);

    @Query(value="select distinct b from ButtonEntity b  left join fetch b.roleMappings rmp  left join fetch b.competences c  where c.code in (:competenceCodes) ")
    public List<ButtonEntity> findByCompetenceCodes(@Param(value="competenceCodes") Set<String> var1);

    @Query(value="select c from ButtonEntity c where c.id in(:ids)")
    public List<ButtonEntity> findByIds(@Param(value="ids") List<String> var1);
}

