/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository;

import com.bizunited.nebula.competence.local.entity.CompetenceRoleMappingEntity;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CompetenceRoleMappingRepository
extends JpaRepository<CompetenceRoleMappingEntity, String>,
JpaSpecificationExecutor<CompetenceRoleMappingEntity> {
    @Modifying
    @Query(value="delete from engine_role_competence_mapping where role_code = :roleCode and competence_id = :competenceId and tenant_code = :tenantCode ", nativeQuery=true)
    public void unbindByRoleCodeAndCompetenceId(@Param(value="roleCode") String var1, @Param(value="tenantCode") String var2, @Param(value="competenceId") String var3);

    @Modifying
    @Query(value="delete from engine_role_competence_mapping where role_code = :roleCode and tenant_code = :tenantCode ", nativeQuery=true)
    public void unbindByRoleCode(@Param(value="roleCode") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="delete from engine_role_competence_mapping where competence_id = :competenceId and tenant_code = :tenantCode ", nativeQuery=true)
    public void unbindByCompetenceId(@Param(value="competenceId") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select r.* from engine_role_competence_mapping r left join engine_role er on r.role_code = er.role_code where r.competence_id = :competenceId and r.tenant_code = :tenantCode and er.tstatus ='1'", nativeQuery=true)
    public Set<CompetenceRoleMappingEntity> findByCompetenceIdAndTenantCode(@Param(value="competenceId") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select count(*) from engine_role_competence_mapping where role_code = :roleCode and competence_id = :competenceId and tenant_code = :tenantCode ", nativeQuery=true)
    public long countByRoleCodeAndCompetenceIdAndTenantCode(@Param(value="roleCode") String var1, @Param(value="competenceId") String var2, @Param(value="tenantCode") String var3);

    @Query(value="select m.competence_id from engine_role_competence_mapping m where m.role_code = :roleCode and m.tenant_code = :tenantCode ", nativeQuery=true)
    public List<String> findCompetenceIdsByRoleCode(@Param(value="roleCode") String var1, @Param(value="tenantCode") String var2);
}

