/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository.task;

import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.entity.ButtonRoleMappingEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ButtonEntityCacheQueryTask
implements Callable<Map<String, ButtonVo>> {
    private String tenantCode;
    private String appCode;
    private List<ButtonEntity> buttonEntities;
    @Autowired
    private Set<CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo>> competenceRegisters;
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonEntityCacheQueryTask.class);

    public ButtonEntityCacheQueryTask(String tenantCode, String appCode, List<ButtonEntity> buttonEntities) {
        this.tenantCode = tenantCode;
        this.appCode = appCode;
        this.buttonEntities = buttonEntities;
    }

    @Override
    @Transactional
    public Map<String, ButtonVo> call() throws Exception {
        try {
            SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo(this.tenantCode);
            TenantContextHolder.setTenantInfo((AbstractTenantInfo)simpleTenantInfo);
            Map<String, ButtonVo> map = this.doTask();
            return map;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            TenantContextHolder.clean();
        }
    }

    private Map<String, ButtonVo> doTask() throws RuntimeException {
        Validate.notBlank((CharSequence)this.tenantCode, (String)"\u9519\u8bef\u7684\u53c2\u6570\u8bbe\u5b9a\uff0c\u4e0d\u80fd\u542f\u52a8\u67e5\u8be2\u8fc7\u7a0b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.appCode, (String)"\u9519\u8bef\u7684\u53c2\u6570\u8bbe\u5b9a\uff0c\u4e0d\u80fd\u542f\u52a8\u67e5\u8be2\u8fc7\u7a0b", (Object[])new Object[0]);
        List<ButtonEntity> buttonEntities = this.buttonEntities;
        if (CollectionUtils.isEmpty(buttonEntities)) {
            return Maps.newHashMap();
        }
        List<ButtonVo> resultButtons = this.convertPracticalButtonVos(buttonEntities);
        Map<String, ButtonEntity> buttonEntitesMappingForCode = buttonEntities.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(ButtonEntity::getCode, item -> item));
        for (ButtonVo buttonVo : resultButtons) {
            if (Objects.isNull(buttonVo)) continue;
            ButtonEntity buttonEntity = buttonEntitesMappingForCode.get(buttonVo.getCode());
            Set<ButtonRoleMappingEntity> roleMappings = buttonEntity.getRoleMappings();
            if (!CollectionUtils.isEmpty(roleMappings)) {
                Set roleCodes = roleMappings.stream().map(item -> StringUtils.join((Object[])new String[]{item.getTenantCode(), "|", item.getRoleCode()})).distinct().collect(Collectors.toSet());
                buttonVo.setRoleCodes(roleCodes);
            }
            try {
                Set<CompetenceEntity> competenceEntities = buttonEntity.getCompetences();
                if (CollectionUtils.isEmpty(competenceEntities)) continue;
                Set competenceCodes = competenceEntities.stream().map(CompetenceEntity::getCode).collect(Collectors.toSet());
                buttonVo.setCompetenceCodes(competenceCodes);
            }
            catch (RuntimeException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return resultButtons.stream().filter(item -> Objects.nonNull(item) && StringUtils.isNotBlank((CharSequence)item.getCode())).collect(Collectors.toMap(ButtonVo::getCode, item -> item, (k1, k2) -> k1));
    }

    private List<ButtonVo> convertPracticalButtonVos(List<ButtonEntity> currentButtons) {
        Map<String, List<ButtonEntity>> buttonsGroupForType = currentButtons.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.groupingBy(ButtonEntity::getType));
        Map<String, ButtonEntity> buttonEntitesMappingForCode = currentButtons.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(ButtonEntity::getCode, item -> item));
        ArrayList buttonVos = Lists.newArrayList();
        for (Map.Entry<String, List<ButtonEntity>> buttonsGroupItems : buttonsGroupForType.entrySet()) {
            List<ButtonEntity> groupButtons = buttonsGroupItems.getValue();
            if (CollectionUtils.isEmpty(groupButtons)) continue;
            String type = buttonsGroupItems.getKey();
            CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.getCompetenceRegister(type);
            Set practicalButtonVos = matchedCompetenceRegister.onRequestButtonVos(groupButtons.stream().map(ButtonEntity::getCode).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)practicalButtonVos)) {
                for (ButtonVo buttonVo : practicalButtonVos) {
                    ButtonEntity buttonBaseEntity = buttonEntitesMappingForCode.get(buttonVo.getCode());
                    Validate.notNull((Object)((Object)buttonBaseEntity), (String)"\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u8fd4\u56de\u4e86\u9519\u8bef\u7684ButtonVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonVo.getCode()});
                    this.perfectInformation(buttonVo, buttonBaseEntity);
                    buttonVos.add(buttonVo);
                }
                continue;
            }
            for (ButtonEntity buttonBaseEntity : groupButtons) {
                ButtonVo buttonVo = null;
                try {
                    buttonVo = (ButtonVo)matchedCompetenceRegister.getButtonClass().newInstance();
                    this.perfectInformation(buttonVo, buttonBaseEntity);
                    buttonVos.add(buttonVo);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u6ca1\u6709\u8fd4\u56de\u6b63\u786e\u7684\u7684ButtonVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f\u65f6\uff0c\u8bd5\u56fe\u76f4\u63a5\u521d\u59cb\u5316\u5177\u4f53\u7684ButtonVo\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!");
                }
            }
        }
        Map<String, ButtonVo> buttonVosMappingForCode = buttonVos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(ButtonVo::getCode, item -> item, (k1, k2) -> k1));
        ArrayList sortedButtons = Lists.newArrayList();
        for (ButtonEntity currentButton : currentButtons) {
            sortedButtons.add(buttonVosMappingForCode.get(currentButton.getCode()));
        }
        return sortedButtons;
    }

    private void perfectInformation(ButtonVo buttonVo, ButtonEntity buttonBaseEntity) {
        buttonVo.setButtonDesc(buttonBaseEntity.getButtonDesc());
        buttonVo.setCreateTime(buttonBaseEntity.getCreateTime());
        buttonVo.setCreateAccount(buttonBaseEntity.getCreateAccount());
        buttonVo.setEffective(buttonBaseEntity.getEffective());
        buttonVo.setIcon(buttonBaseEntity.getIcon());
        buttonVo.setId(buttonBaseEntity.getId());
        buttonVo.setModifyAccount(buttonBaseEntity.getModifyAccount());
        buttonVo.setModifyTime(buttonBaseEntity.getModifyTime());
        buttonVo.setName(buttonBaseEntity.getName());
        buttonVo.setSystem(buttonBaseEntity.getSystem());
        buttonVo.setType(buttonBaseEntity.getType());
        buttonVo.setExtend1(buttonBaseEntity.getExtend1());
        buttonVo.setExtend2(buttonBaseEntity.getExtend2());
        buttonVo.setExtend3(buttonBaseEntity.getExtend3());
        buttonVo.setExtend4(buttonBaseEntity.getExtend4());
        buttonVo.setExtend5(buttonBaseEntity.getExtend5());
        buttonVo.setExtend6(buttonBaseEntity.getExtend6());
        buttonVo.setExtend7(buttonBaseEntity.getExtend7());
        buttonVo.setExtend8(buttonBaseEntity.getExtend8());
        buttonVo.setExtend9(buttonBaseEntity.getExtend9());
        buttonVo.setExtend10(buttonBaseEntity.getExtend10());
        buttonVo.setExtend11(buttonBaseEntity.getExtend11());
    }

    private CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> getCompetenceRegister(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.competenceRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = null;
        for (CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister : this.competenceRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)competenceRegister.getType())) continue;
            matchedCompetenceRegister = competenceRegister;
            break;
        }
        Validate.notNull(matchedCompetenceRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedCompetenceRegister;
    }
}

