/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository.task;

import com.bizunited.nebula.common.entity.UuidEntity;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceRoleMappingEntity;
import com.bizunited.nebula.competence.local.repository.CompetenceRepository;
import com.bizunited.nebula.competence.local.repository.CompetenceRoleMappingRepository;
import com.bizunited.nebula.competence.local.service.ButtonCacheService;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class CompetenceEntityCacheQueryTask
implements Callable<Map<String, CompetenceVo>> {
    private String tenantCode;
    private List<CompetenceEntity> sourceCompetences;
    @Autowired
    private ButtonCacheService buttonCacheService;
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private CompetenceRoleMappingRepository competenceRoleMappingRepository;
    @Autowired
    private Set<CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo>> competenceRegisters;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceEntityCacheQueryTask.class);

    public CompetenceEntityCacheQueryTask(List<CompetenceEntity> sourceCompetences, String tenantCode, String appCode) {
        this.sourceCompetences = sourceCompetences;
        this.tenantCode = tenantCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, CompetenceVo> call() throws Exception {
        ConcurrentMap competenceResultMapping = Maps.newConcurrentMap();
        SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo(this.tenantCode);
        TenantContextHolder.setTenantInfo((AbstractTenantInfo)simpleTenantInfo);
        try {
            ArrayList currentMenuEntitesCompetences = this.sourceCompetences.stream().filter(e -> e.getViewItem() == 1).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(currentMenuEntitesCompetences)) {
                currentMenuEntitesCompetences = Lists.newArrayList();
            } else {
                Validate.isTrue((boolean)currentMenuEntitesCompetences.stream().noneMatch(item -> StringUtils.isBlank((CharSequence)item.getCode())), (String)"\u53d1\u73b0\u9519\u8bef\u7684\u9876\u5c42\u83dc\u5355\u4fe1\u606f(\u6ca1\u6709\u552f\u4e00\u4e1a\u52a1\u7f16\u53f7)\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
            }
            List<CompetenceVo> currentMenuCompetences = this.convertPracticalCompetenceVos(currentMenuEntitesCompetences);
            Map<String, CompetenceVo> competenceVosMappingForCode = currentMenuCompetences.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(CompetenceVo::getCode, item -> item));
            for (CompetenceEntity currentCompetenceEntity : currentMenuEntitesCompetences) {
                if (currentCompetenceEntity.getParent() == null) continue;
                CompetenceVo currentCompetenceVo = competenceVosMappingForCode.get(currentCompetenceEntity.getCode());
                currentCompetenceVo.setParentCode(currentCompetenceEntity.getParent().getCode());
            }
            for (CompetenceVo menuCompetence : currentMenuCompetences) {
                LinkedList stackCodes = Lists.newLinkedList();
                stackCodes.push(menuCompetence.getCode());
                this.recursiveLoadCompetence(competenceResultMapping, menuCompetence, this.tenantCode, 1, stackCodes);
                stackCodes.pop();
                competenceResultMapping.put(menuCompetence.getCode(), menuCompetence);
            }
            List<CompetenceEntity> currentCompetenceEntitys = this.sourceCompetences.stream().filter(e -> e.getViewItem() == 0).collect(Collectors.toList());
            List<Object> menuCompetences = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(currentCompetenceEntitys)) {
                menuCompetences = this.convertPracticalCompetenceVos(currentCompetenceEntitys);
                for (CompetenceVo competenceVo : menuCompetences) {
                    if (competenceVo == null) {
                        Object[] ids = (String[])currentCompetenceEntitys.stream().map(UuidEntity::getId).toArray(String[]::new);
                        LOGGER.warn("\u5728\u4e00\u7ec4\u529f\u80fdid\u96c6\u5408\u4e2d'{}'\uff0c\u53d1\u73b0\u4e00\u4e2a\u672a\u6b63\u786e\u8f6c\u6362VO\u7684\u529f\u80fd\u4fe1\u606f\uff0c\u5f88\u53ef\u80fd\u662f\u5177\u4f53\u7684\u529f\u80fd/\u6309\u94ae\u5b9e\u73b0\u7c7b\u4e2d\uff0c\u529f\u80fd/\u6309\u94aeVO\u8f6c\u6362\u51fa\u73b0\u4e86\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object)StringUtils.join((Object[])ids, (String)","));
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)competenceVo.getCode())) {
                        LOGGER.warn("\u529f\u80fd\u57fa\u672c\u4fe1\u606fid\u4e3a\u2018{}\u2019\u7684\u529f\u80fd\uff0c\u6ca1\u6709\u53d1\u73b0\u4e1a\u52a1\u7f16\u53f7\uff0c\u5f88\u53ef\u80fd\u662f\u5177\u4f53\u7684\u529f\u80fd/\u6309\u94ae\u5b9e\u73b0\u7c7b\u4e2d\uff0c\u529f\u80fd/\u6309\u94aeVO\u8f6c\u6362\u51fa\u73b0\u4e86\u95ee\u9898", (Object)competenceVo.getId());
                        continue;
                    }
                    LinkedList stackCodes = Lists.newLinkedList();
                    stackCodes.push(competenceVo.getCode());
                    this.recursiveLoadCompetence(competenceResultMapping, competenceVo, this.tenantCode, 0, stackCodes);
                    stackCodes.pop();
                    competenceResultMapping.put(competenceVo.getCode(), competenceVo);
                }
            }
        }
        finally {
            TenantContextHolder.clean();
        }
        return competenceResultMapping;
    }

    private List<CompetenceVo> convertPracticalCompetenceVos(List<CompetenceEntity> currentMenuCompetences) {
        Map<String, List<CompetenceEntity>> competencesGroupForType = currentMenuCompetences.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.groupingBy(CompetenceEntity::getType));
        Map<String, CompetenceEntity> competenceEntitesMappingForCode = currentMenuCompetences.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(CompetenceEntity::getCode, item -> item));
        ArrayList menuCompetences = Lists.newArrayList();
        for (Map.Entry<String, List<CompetenceEntity>> menuCompetencesGroupItems : competencesGroupForType.entrySet()) {
            List<CompetenceEntity> groupMenuCompetences = menuCompetencesGroupItems.getValue();
            if (CollectionUtils.isEmpty(groupMenuCompetences)) continue;
            String type = menuCompetencesGroupItems.getKey();
            CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.getCompetenceRegister(type);
            Set practicalCompetenceVos = matchedCompetenceRegister.onRequestCompetenceVos(groupMenuCompetences.stream().map(CompetenceEntity::getCode).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)practicalCompetenceVos)) {
                for (CompetenceVo competenceVo : practicalCompetenceVos) {
                    CompetenceEntity competenceBaseEntity = competenceEntitesMappingForCode.get(competenceVo.getCode());
                    Validate.notNull((Object)((Object)competenceBaseEntity), (String)"\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u8fd4\u56de\u4e86\u9519\u8bef\u7684CompetenceVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceVo.getCode()});
                    this.perfectInformation(competenceVo, competenceBaseEntity);
                    menuCompetences.add(competenceVo);
                }
                continue;
            }
            for (CompetenceEntity competenceBaseEntity : groupMenuCompetences) {
                CompetenceVo competenceVo = null;
                try {
                    competenceVo = (CompetenceVo)matchedCompetenceRegister.getCompetenceClass().newInstance();
                    this.perfectInformation(competenceVo, competenceBaseEntity);
                    menuCompetences.add(competenceVo);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u6ca1\u6709\u8fd4\u56de\u6b63\u786e\u7684\u7684CompetenceVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f\u65f6\uff0c\u8bd5\u56fe\u76f4\u63a5\u521d\u59cb\u5316\u5177\u4f53\u7684CompetenceVo\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!");
                }
            }
        }
        Map<String, CompetenceVo> competenceVosMappingForCode = menuCompetences.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(CompetenceVo::getCode, item -> item));
        ArrayList sortedMenuCompetences = Lists.newArrayList();
        for (CompetenceEntity currentCompetence : currentMenuCompetences) {
            CompetenceVo currentCompetenceVo = competenceVosMappingForCode.get(currentCompetence.getCode());
            if (currentCompetenceVo != null) {
                sortedMenuCompetences.add(currentCompetenceVo);
                continue;
            }
            LOGGER.error("id\u4e3a{}\uff0ctype\u4e3a{}\u7684\u529f\u80fd\uff0c\u672a\u8fdb\u884c\u6b63\u786e\u8f6c\u6362,\u8bf7\u68c0\u67e5\u6570\u636e\u4fe1\u606f!!", (Object)currentCompetence.getId(), (Object)currentCompetence.getType());
        }
        return sortedMenuCompetences;
    }

    private void perfectInformation(CompetenceVo competenceVo, CompetenceEntity competenceBaseEntity) {
        competenceVo.setId(competenceBaseEntity.getId());
        competenceVo.setType(competenceBaseEntity.getType());
        competenceVo.setCode(competenceBaseEntity.getCode());
        competenceVo.setComment(competenceBaseEntity.getComment());
        competenceVo.setViewItem(competenceBaseEntity.getViewItem());
        competenceVo.setTstatus(competenceBaseEntity.getTstatus());
        competenceVo.setSortIndex(competenceBaseEntity.getSortIndex());
        competenceVo.setIcon(competenceBaseEntity.getIcon());
    }

    private void recursiveLoadCompetence(Map<String, CompetenceVo> competenceResultMapping, CompetenceVo competence, String tenantCode, Integer viewItem, LinkedList<String> stackCodes) {
        Set<CompetenceRoleMappingEntity> roleMappings;
        String competenceCode = competence.getCode();
        String competenceId = competence.getId();
        List<ButtonVo> buttonVos = this.buttonCacheService.findByCompetenceCode(competenceCode);
        if (!CollectionUtils.isEmpty(buttonVos)) {
            competence.setButtons(buttonVos);
        }
        if (!CollectionUtils.isEmpty(roleMappings = this.competenceRoleMappingRepository.findByCompetenceIdAndTenantCode(competenceId, tenantCode))) {
            Set roleCodes = roleMappings.stream().map(item -> StringUtils.join((Object[])new String[]{item.getTenantCode(), "|", item.getRoleCode()})).distinct().collect(Collectors.toSet());
            competence.setRoleCodes(roleCodes);
        }
        if (viewItem == 0) {
            return;
        }
        List<CompetenceEntity> children = this.competenceRepository.findByParentId(competenceId);
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        List<CompetenceVo> practicalChildren = this.convertPracticalCompetenceVos(children);
        for (CompetenceVo childCompetence : practicalChildren) {
            if (childCompetence.getViewItem() != 1 || stackCodes.contains(childCompetence.getCode())) continue;
            stackCodes.push(childCompetence.getCode());
            this.recursiveLoadCompetence(competenceResultMapping, childCompetence, tenantCode, viewItem, stackCodes);
            stackCodes.pop();
            competenceResultMapping.put(childCompetence.getCode(), childCompetence);
            childCompetence.setParentCode(competence.getCode());
        }
        competence.setChildren(practicalChildren);
    }

    private CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> getCompetenceRegister(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.competenceRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = null;
        for (CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister : this.competenceRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)competenceRegister.getType())) continue;
            matchedCompetenceRegister = competenceRegister;
            break;
        }
        Validate.notNull(matchedCompetenceRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedCompetenceRegister;
    }
}

