/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.entity.ButtonRoleMappingEntity;
import com.bizunited.nebula.competence.local.repository.ButtonRepository;
import com.bizunited.nebula.competence.local.repository.ButtonRoleMappingRepository;
import com.bizunited.nebula.competence.sdk.service.ButtonRoleMappingService;
import com.bizunited.nebula.rbac.sdk.service.RoleVoService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ButtonRoleMappingServiceImpl
implements ButtonRoleMappingService {
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private ButtonRoleMappingRepository buttonRoleMappingRepository;
    @Autowired
    private RoleVoService roleVoService;

    @Transactional
    public void bindRole(String roleCode, String tenantCode, String[] buttonCodes) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        RoleVo roleVo = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)roleVo, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        Validate.isTrue((buttonCodes != null && buttonCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6309\u94ae\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        Validate.notNull((Object)roleVo, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        for (String buttonCode : buttonCodes) {
            ButtonEntity opButton = this.buttonRepository.findByCode(buttonCode);
            Validate.notNull((Object)((Object)opButton), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonCode});
            long count = this.buttonRoleMappingRepository.countByRoleCodeAndButtonIdAndTenantCode(roleCode, opButton.getId(), tenantCode);
            if (count != 0L) continue;
            ButtonRoleMappingEntity newButtonRoleMapping = new ButtonRoleMappingEntity();
            newButtonRoleMapping.setButton(opButton);
            newButtonRoleMapping.setRoleCode(roleCode);
            newButtonRoleMapping.setTenantCode(tenantCode);
            this.buttonRoleMappingRepository.save((Object)newButtonRoleMapping);
        }
    }

    @Transactional
    public void unbindByRoleCode(String roleCode, String tenantCode) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        RoleVo roleVo = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)roleVo, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        this.buttonRoleMappingRepository.unbindByRoleCode(roleCode, tenantCode);
    }

    @Transactional
    public void unbindByRoleCodeAndButtonCodes(String roleCode, String tenantCode, String[] buttonCodes) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        RoleVo roleVo = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)roleVo, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        Validate.isTrue((buttonCodes != null && buttonCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6309\u94ae\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String buttonCode : buttonCodes) {
            ButtonEntity opButton = this.buttonRepository.findByCode(buttonCode);
            Validate.notNull((Object)((Object)opButton), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonCode});
            this.buttonRoleMappingRepository.unbindByRoleCodeAndButtonId(roleCode, tenantCode, opButton.getId());
        }
    }

    @Transactional
    public void rebindRole(String roleCode, String tenantCode, String[] buttonCodes) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        RoleVo roleVo = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)roleVo, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        this.buttonRoleMappingRepository.unbindByRoleCode(roleCode, tenantCode);
        if (buttonCodes != null) {
            for (String buttonCode : buttonCodes) {
                ButtonEntity opButton = this.buttonRepository.findByCode(buttonCode);
                Validate.notNull((Object)((Object)opButton), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonCode});
                ButtonRoleMappingEntity newButtonRoleMapping = new ButtonRoleMappingEntity();
                newButtonRoleMapping.setButton(opButton);
                newButtonRoleMapping.setRoleCode(roleCode);
                newButtonRoleMapping.setTenantCode(tenantCode);
                this.buttonRoleMappingRepository.save((Object)newButtonRoleMapping);
            }
        }
    }

    public void rebindRole(String[] roleCodes, String tenantCode, String buttonCode) {
        Validate.notBlank((CharSequence)buttonCode, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        ButtonEntity currentButton = this.buttonRepository.findByCode(buttonCode);
        Validate.notNull((Object)((Object)currentButton), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        this.buttonRoleMappingRepository.unbindByButtonId(currentButton.getId(), tenantCode);
        this.buttonRoleMappingRepository.flush();
        if (roleCodes == null || roleCodes.length == 0) {
            return;
        }
        for (String roleCode : roleCodes) {
            RoleVo currentRole = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
            Validate.notNull((Object)currentRole, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleCode});
            ButtonRoleMappingEntity newButtonRoleMapping = new ButtonRoleMappingEntity();
            newButtonRoleMapping.setButton(currentButton);
            newButtonRoleMapping.setRoleCode(roleCode);
            newButtonRoleMapping.setTenantCode(tenantCode);
            this.buttonRoleMappingRepository.save((Object)newButtonRoleMapping);
        }
    }

    public long countByRoleCodeAndTenantCode(String roleCode, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{roleCode, tenantCode})) {
            return 0L;
        }
        return this.buttonRoleMappingRepository.countByRoleCodeAndTenantCode(roleCode, tenantCode);
    }

    public long countByButtonCode(String buttonCode) {
        if (StringUtils.isBlank((CharSequence)buttonCode)) {
            return 0L;
        }
        ButtonEntity currentButton = this.buttonRepository.findByCode(buttonCode);
        if (currentButton == null) {
            return 0L;
        }
        return this.buttonRoleMappingRepository.countByButtonId(currentButton.getId());
    }

    public List<String> findButtonsIdsByRoleCode(String copyRoleCode, String tenantCode) {
        if (StringUtils.isBlank((CharSequence)copyRoleCode)) {
            return new ArrayList<String>(0);
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        return this.buttonRoleMappingRepository.findButtonsIdsByRoleCode(copyRoleCode, tenantCode);
    }
}

