/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.local.dto.CompetenceDto;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.repository.CompetenceRepository;
import com.bizunited.nebula.competence.local.repository.task.CompetenceEntityCacheQueryTask;
import com.bizunited.nebula.competence.local.service.ButtonCacheService;
import com.bizunited.nebula.competence.local.service.CompetenceCacheService;
import com.bizunited.nebula.competence.local.service.query.CompetenceQueryStrategy;
import com.bizunited.nebula.competence.local.service.query.QueryByResourcesAndMethodAndRoleCodes;
import com.bizunited.nebula.competence.local.service.query.QueryByViewItemAndRoleCodesAndCodeOrComment;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompetenceCacheServiceImpl
implements CompetenceCacheService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private Redisson redisson;
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private ButtonCacheService buttonCacheService;
    @Autowired
    @Qualifier(value="_competenceCacheQueryExecutor")
    private ThreadPoolExecutor competenceCacheQueryExecutor;
    private volatile Thread flashingThread = null;
    private AtomicReference<Thread> atomicReference = new AtomicReference<Object>(null);
    private static Integer MAX_STEPPING = 200;
    private static Integer MIN_STEPPING = 50;
    private static ReentrantReadWriteLock competenceloadLock = new ReentrantReadWriteLock();
    private static Map<String, Map<String, CompetenceVo>> competencesCacheMapping = Maps.newConcurrentMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceCacheServiceImpl.class);

    @Override
    public void notifyCacheRefresh(String appCode) {
        Validate.notBlank((CharSequence)appCode, (String)"\u8981\u6c42\u6e05\u7406\u529f\u80fd\u6811\u7f13\u5b58\u65f6\uff0c\u5fc5\u987b\u4f20\u5165appCode", (Object[])new Object[0]);
        LOGGER.info("\u529f\u80fd\uff1a\u5df2\u901a\u77e5\u8fdb\u884cappcode\u4e3a{}\u7684\u7f13\u5b58\u66f4\u65b0", (Object)appCode);
        this.buttonCacheService.notifyCacheClear(appCode);
        RTopic topic = this.redisson.getTopic("_ALL_COMPETENCE_NOTIFY");
        topic.publish((Object)appCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String appCode) {
        Validate.notBlank((CharSequence)appCode, (String)"\u8981\u6c42\u6e05\u7406\u529f\u80fd\u6811\u7f13\u5b58\u65f6\uff0c\u5fc5\u987b\u4f20\u5165appCode", (Object[])new Object[0]);
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        try {
            readLock.lock();
            LOGGER.info("\u529f\u80fd\uff1a\u6b63\u5728\u8fdb\u884cappcode\u4e3a{}\u7684\u7f13\u5b58\u6e05\u7406", (Object)appCode);
            Map<String, CompetenceVo> competencesCache = competencesCacheMapping.get(appCode);
            if (competencesCache != null) {
                competencesCache.clear();
            }
            this.findDetailsFromRepository();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Set<CompetenceVo> findByViewItemAndCurrentAccount(Boolean viewItem, Integer status, String codeOrComment) {
        String tenantCode = TenantUtils.getTenantCode();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return null;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Collection authorities = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)authorities)) {
            return null;
        }
        Set<String> roleCodes = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(roleCodes)) {
            return null;
        }
        return this.findByViewItemAndRoleCodesAndStatus(viewItem, tenantCode, roleCodes.toArray(new String[0]), status == null ? null : Integer.valueOf(status == 1 ? 1 : 0), codeOrComment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CompetenceVo> findByViewItemAndRoleCodesAndStatus(Boolean viewItem, String tenantCode, String[] roleCodes, Integer status, String codeOrComment) {
        String appCode = TenantUtils.getTenantCode();
        if (roleCodes == null || roleCodes.length == 0 || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, appCode})) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        boolean isAdmin = this.comfirmAdmin(roleCodes);
        QueryByViewItemAndRoleCodesAndCodeOrComment competenceQueryStrategy = (QueryByViewItemAndRoleCodesAndCodeOrComment)this.applicationContext.getBean(QueryByViewItemAndRoleCodesAndCodeOrComment.class, new Object[]{viewItem, isAdmin, tenantCode, roleCodes, status, codeOrComment, this.rbacCustomProperties.getIgnoreMethodCheckRoles()});
        LinkedHashSet results = Sets.newLinkedHashSet();
        try {
            readLock.lock();
            if (CollectionUtils.isEmpty(competencesCacheMapping.get(appCode))) {
                this.findDetailsFromRepository();
            }
            Collection<CompetenceVo> topCompetences = competencesCacheMapping.get(appCode).values();
            List sortedTopCompetences = topCompetences.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getParentCode())).sorted(Comparator.comparingInt(CompetenceVo::getSortIndex)).collect(Collectors.toList());
            LinkedList stack = Lists.newLinkedList();
            LinkedHashMap matchedCloneCompetenceMapping = Maps.newLinkedHashMap();
            for (CompetenceVo topCompetence : sortedTopCompetences) {
                this.recursiveQueryCompetenceForTree(competenceQueryStrategy, topCompetence, stack, matchedCloneCompetenceMapping);
            }
            if (!CollectionUtils.isEmpty((Map)matchedCloneCompetenceMapping)) {
                results.addAll(matchedCloneCompetenceMapping.values().stream().filter(item -> StringUtils.isBlank((CharSequence)item.getParentCode())).collect(Collectors.toList()));
            }
        }
        finally {
            readLock.unlock();
        }
        return results;
    }

    private void recursiveQueryCompetenceForTree(CompetenceQueryStrategy competenceQueryStrategy, CompetenceVo competence, LinkedList<MatchedCompetenceNode> stack, Map<String, CompetenceVo> matchedCloneCompetenceMapping) {
        List children;
        MatchedCompetenceNode matchedCompetenceNode = new MatchedCompetenceNode(competenceQueryStrategy.filterCompetence(competence), competence);
        stack.push(matchedCompetenceNode);
        List buttons = competence.getButtons();
        ArrayList copyButtons = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)buttons)) {
            for (ButtonVo buttonVo : buttons) {
                ButtonVo copyButton = competenceQueryStrategy.filterButton(buttonVo);
                if (copyButton == null) continue;
                copyButtons.add(copyButton);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(children = competence.getChildren()))) {
            for (CompetenceVo competenceVo : children) {
                this.recursiveQueryCompetenceForTree(competenceQueryStrategy, competenceVo, stack, matchedCloneCompetenceMapping);
            }
        } else {
            Integer begin = null;
            Integer end = null;
            String parentCompetenceCode = null;
            for (int index = 0; index < stack.size(); ++index) {
                MatchedCompetenceNode nodeItem = stack.get(index);
                CompetenceVo sourceCompetence = nodeItem.competence;
                String competenceCode = sourceCompetence.getCode();
                if (nodeItem.matched && begin == null && nodeItem.cloneCompetence == null && StringUtils.isBlank(parentCompetenceCode)) {
                    begin = index;
                }
                if (matchedCloneCompetenceMapping.get(competenceCode) != null && end == null && stack.get(index - 1).cloneCompetence == null) {
                    end = index - 1;
                }
                if (index == stack.size() - 1 && end == null && stack.get(index).cloneCompetence == null) {
                    end = index;
                }
                if (matchedCloneCompetenceMapping.get(competenceCode) == null || !StringUtils.isBlank(parentCompetenceCode)) continue;
                parentCompetenceCode = competenceCode;
            }
            if (end != null && begin != null) {
                MatchedCompetenceNode subTreeNode = this.buildSubtree(competenceQueryStrategy, end, begin, stack, matchedCloneCompetenceMapping);
                if (StringUtils.isNotBlank(parentCompetenceCode)) {
                    CompetenceVo parentCompetence = matchedCloneCompetenceMapping.get(parentCompetenceCode);
                    List currentChildren = parentCompetence.getChildren();
                    if (currentChildren == null) {
                        currentChildren = Lists.newArrayList();
                        parentCompetence.setChildren(currentChildren);
                    }
                    currentChildren.add(subTreeNode.cloneCompetence);
                    currentChildren.sort(new Comparator<CompetenceVo>(){

                        @Override
                        public int compare(CompetenceVo source, CompetenceVo target) {
                            int targetIndex;
                            int sourceIndex = source.getSortIndex() == null ? 0 : source.getSortIndex();
                            int n = targetIndex = target.getSortIndex() == null ? 0 : target.getSortIndex();
                            if (sourceIndex - targetIndex != 0) {
                                return sourceIndex - targetIndex;
                            }
                            return StringUtils.compare((String)source.getComment(), (String)target.getComment());
                        }
                    });
                }
            }
        }
        stack.pop();
    }

    private MatchedCompetenceNode buildSubtree(CompetenceQueryStrategy competenceQueryStrategy, int index, int mixNodeIndex, LinkedList<MatchedCompetenceNode> stack, Map<String, CompetenceVo> matchedCloneCompetenceMapping) {
        MatchedCompetenceNode currentNode = stack.get(index);
        if (currentNode.cloneCompetence == null) {
            currentNode.cloneCompetence = competenceQueryStrategy.clone(currentNode.competence);
        }
        matchedCloneCompetenceMapping.put(currentNode.cloneCompetence.getCode(), currentNode.cloneCompetence);
        if (index > mixNodeIndex) {
            List children = currentNode.cloneCompetence.getChildren();
            if (children == null) {
                children = Lists.newArrayList();
                currentNode.cloneCompetence.setChildren(children);
            }
            children.add(this.buildSubtree(competenceQueryStrategy, index - 1, mixNodeIndex, stack, matchedCloneCompetenceMapping).cloneCompetence);
            children.sort(new Comparator<CompetenceVo>(){

                @Override
                public int compare(CompetenceVo source, CompetenceVo target) {
                    int targetIndex;
                    int sourceIndex = source.getSortIndex() == null ? 0 : source.getSortIndex();
                    int n = targetIndex = target.getSortIndex() == null ? 0 : target.getSortIndex();
                    if (sourceIndex - targetIndex != 0) {
                        return sourceIndex - targetIndex;
                    }
                    return StringUtils.compare((String)source.getComment(), (String)target.getComment());
                }
            });
        }
        return currentNode;
    }

    private boolean comfirmAdmin(String[] roleCodes) {
        boolean isAdmin = false;
        if (roleCodes != null && roleCodes.length > 0) {
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.rbacCustomProperties.getIgnoreMethodCheckRoles()), (Set)Sets.newHashSet((Object[])roleCodes));
            isAdmin = !CollectionUtils.isEmpty((Collection)intersections);
        }
        return isAdmin;
    }

    private void findDetailsFromRepository() {
        String appCode = TenantUtils.getTenantCode();
        String tenantCode = TenantUtils.getTenantCode();
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        readLock.unlock();
        Thread currentThread = Thread.currentThread();
        boolean isFlashingThread = false;
        isFlashingThread = this.atomicReference.compareAndSet(null, currentThread);
        if (isFlashingThread) {
            this.flashingThread = currentThread;
        } else {
            Thread.yield();
        }
        if (!isFlashingThread) {
            while (this.flashingThread != null) {
                Thread.yield();
            }
            readLock.lock();
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = competenceloadLock.writeLock();
        try {
            int availableProcessors;
            writeLock.lock();
            LOGGER.info("\u529f\u80fd\uff1a\u6b63\u5728\u8fdb\u884cappcode\u4e3a{}\u7684\u7f13\u5b58\u52a0\u8f7d", (Object)appCode);
            ArrayList taskFutures = Lists.newArrayList();
            List<CompetenceEntity> roots = this.competenceRepository.findByViewItemAndNullParent(1);
            if (CollectionUtils.isEmpty(roots)) {
                competencesCacheMapping.put(appCode, Maps.newConcurrentMap());
                return;
            }
            for (CompetenceEntity root : roots) {
                CompetenceEntityCacheQueryTask menuTask = (CompetenceEntityCacheQueryTask)this.applicationContext.getBean(CompetenceEntityCacheQueryTask.class, new Object[]{Lists.newArrayList((Object[])new CompetenceEntity[]{root}), tenantCode, appCode});
                taskFutures.add(this.competenceCacheQueryExecutor.submit(menuTask));
            }
            int count = (int)this.competenceRepository.countByViewItem(0);
            int steppingCount = count / (availableProcessors = (availableProcessors = Runtime.getRuntime().availableProcessors()) <= 0 ? 1 : availableProcessors);
            steppingCount = steppingCount > MAX_STEPPING ? MAX_STEPPING : (steppingCount < MIN_STEPPING ? MIN_STEPPING : steppingCount);
            CompetenceDto competenceDto = new CompetenceDto();
            competenceDto.setTstatus(null);
            competenceDto.setViewItem(false);
            List<CompetenceEntity> pageCompetences = this.competenceRepository.findAllByConditions(competenceDto);
            int pageCount = count / steppingCount + 1;
            for (int index = 0; index < pageCount; ++index) {
                List<CompetenceEntity> subList = null;
                subList = index + 1 < pageCount ? pageCompetences.subList(steppingCount * index, steppingCount * (index + 1)) : pageCompetences.subList(steppingCount * index, pageCompetences.size());
                CompetenceEntityCacheQueryTask task = (CompetenceEntityCacheQueryTask)this.applicationContext.getBean(CompetenceEntityCacheQueryTask.class, new Object[]{subList, tenantCode, appCode});
                taskFutures.add(this.competenceCacheQueryExecutor.submit(task));
            }
            ConcurrentMap competenceCacheMappingItem = Maps.newConcurrentMap();
            for (Future future : taskFutures) {
                competenceCacheMappingItem.putAll((Map)future.get());
            }
            competencesCacheMapping.put(appCode, competenceCacheMappingItem);
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            if (competencesCacheMapping.get(appCode) != null) {
                competencesCacheMapping.get(appCode).clear();
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            this.atomicReference.compareAndSet(currentThread, null);
            this.flashingThread = null;
            writeLock.unlock();
            readLock.lock();
        }
    }

    @Override
    public Set<CompetenceVo> findByResource(String resource, Integer tstatus) {
        if (StringUtils.isBlank((CharSequence)resource)) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        String tenantCode = TenantUtils.getTenantCode();
        this.findByResources(new String[]{resource}, null, tstatus, tenantCode, null, null, results);
        return results;
    }

    @Override
    public CompetenceVo findCacheByCompetenceCode(String competenceCode) {
        if (StringUtils.isBlank((CharSequence)competenceCode)) {
            return null;
        }
        Set<CompetenceVo> competenceVoSet = this.findByViewItemAndRoleCodesAndStatus(true, TenantUtils.getTenantCode(), this.rbacCustomProperties.getIgnoreMethodCheckRoles(), 1, competenceCode);
        if (CollectionUtils.isEmpty(competenceVoSet)) {
            return null;
        }
        return this.getThisCompetenceVo(new ArrayList<CompetenceVo>(competenceVoSet), competenceCode, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findByResources(String[] resources, String method, Integer status, String tenantCode, String[] roleCodes, String type, Set<CompetenceVo> results) {
        String appCode = TenantUtils.getTenantCode();
        if (resources == null || resources.length == 0) {
            return;
        }
        boolean isAdmin = this.comfirmAdmin(roleCodes);
        CompetenceQueryStrategy competenceQueryStrategy = (CompetenceQueryStrategy)this.applicationContext.getBean(QueryByResourcesAndMethodAndRoleCodes.class, new Object[]{resources, false, method, status, tenantCode, roleCodes, type, isAdmin, this.rbacCustomProperties.getIgnoreMethodCheckRoles()});
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        try {
            readLock.lock();
            if (CollectionUtils.isEmpty(competencesCacheMapping.get(appCode))) {
                this.findDetailsFromRepository();
            }
            Collection<CompetenceVo> cachedCompetences = competencesCacheMapping.get(appCode).values();
            List sortedCachedCompetences = cachedCompetences.stream().sorted((source, target) -> source.getSortIndex() - target.getSortIndex()).collect(Collectors.toList());
            for (CompetenceVo cacheCompetence : sortedCachedCompetences) {
                this.recursiveQueryCompetenceForList(competenceQueryStrategy, cacheCompetence, results);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void recursiveQueryCompetenceForList(CompetenceQueryStrategy competenceQueryStrategy, CompetenceVo competence, Set<CompetenceVo> queryResult) {
        List children;
        CompetenceVo copyCompetence = null;
        if (competenceQueryStrategy.filterCompetence(competence)) {
            copyCompetence = competenceQueryStrategy.clone(competence);
        }
        if (copyCompetence != null) {
            Validate.isTrue((copyCompetence != competence ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u6811\u67e5\u8be2\u548c\u6784\u5efa\u65f6\uff0c\u5fc5\u987b\u4f7f\u7528\u4e2d\u62f7\u526f\u672c", (Object[])new Object[0]);
            queryResult.add(copyCompetence);
        }
        if (copyCompetence != null) {
            List buttons = competence.getButtons();
            ArrayList copyButtons = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)buttons)) {
                for (ButtonVo buttonVo : buttons) {
                    ButtonVo copyButton = competenceQueryStrategy.filterButton(buttonVo);
                    if (copyButton == null) continue;
                    copyButtons.add(copyButton);
                }
            }
            copyCompetence.setButtons((List)copyButtons);
        }
        if (!CollectionUtils.isEmpty((Collection)(children = competence.getChildren()))) {
            for (CompetenceVo child : children) {
                this.recursiveQueryCompetenceForList(competenceQueryStrategy, child, queryResult);
            }
        }
    }

    private CompetenceVo getThisCompetenceVo(List<CompetenceVo> competenceVos, String competenceCode, String comment) {
        if (CollectionUtils.isEmpty(competenceVos) || StringUtils.isBlank((CharSequence)competenceCode)) {
            return null;
        }
        for (CompetenceVo vo : competenceVos) {
            CompetenceVo child;
            String thisComment = StringUtils.stripToEmpty((String)vo.getComment());
            comment = StringUtils.stripToEmpty((String)comment);
            if (StringUtils.isNotEmpty((CharSequence)thisComment)) {
                if (StringUtils.isNotEmpty((CharSequence)comment)) {
                    comment = comment + "-";
                }
                comment = comment + thisComment;
            }
            vo.setParentCodeAllComment(comment);
            if (StringUtils.equals((CharSequence)competenceCode, (CharSequence)vo.getCode())) {
                return vo;
            }
            if (CollectionUtils.isEmpty((Collection)vo.getChildren()) || (child = this.getThisCompetenceVo(vo.getChildren(), competenceCode, comment)) == null) continue;
            return child;
        }
        return null;
    }

    private static class MatchedCompetenceNode {
        private boolean matched;
        private CompetenceVo competence;
        private CompetenceVo cloneCompetence;

        public MatchedCompetenceNode(boolean matched, CompetenceVo competence) {
            this.matched = matched;
            this.competence = competence;
        }
    }
}

