/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.local.service.CompetenceCacheService;
import com.bizunited.nebula.competence.sdk.service.CompetenceCacheVoService;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompetenceCacheVoServiceImpl
implements CompetenceCacheVoService {
    @Autowired(required=false)
    private CompetenceCacheService competenceCacheService;
    private static volatile Cache<String, CompetenceVo> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompetenceCacheVoServiceImpl() {
        if (cache != null) return;
        Class<CompetenceCacheVoServiceImpl> clazz = CompetenceCacheVoServiceImpl.class;
        synchronized (CompetenceCacheVoServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(30L, TimeUnit.MINUTES).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public CompetenceVo findCacheByCompetenceCode(String competenceCode) {
        if (StringUtils.isBlank((CharSequence)competenceCode)) {
            return null;
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), competenceCode});
        CompetenceVo graph = (CompetenceVo)cache.getIfPresent((Object)cacheKey);
        if (graph != null) {
            return graph;
        }
        graph = this.competenceCacheService.findCacheByCompetenceCode(competenceCode);
        if (null == graph) {
            return null;
        }
        graph.setId(competenceCode);
        graph.setCode(competenceCode);
        cache.put((Object)cacheKey, (Object)graph);
        return graph;
    }

    public Set<CompetenceVo> findByResource(String resource, Integer status) {
        return this.competenceCacheService.findByResource(resource, status);
    }
}

