/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.bizunited.nebula.common.enums.NormalStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.local.dto.CompetenceDto;
import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceRoleMappingEntity;
import com.bizunited.nebula.competence.local.repository.ButtonRepository;
import com.bizunited.nebula.competence.local.repository.CompetenceRepository;
import com.bizunited.nebula.competence.sdk.config.CompetenceCustomProperties;
import com.bizunited.nebula.competence.sdk.event.CompetenceEventListener;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.service.CompetenceRoleMappingService;
import com.bizunited.nebula.competence.sdk.service.CompetenceVoService;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompetenceVoServiceImpl
implements CompetenceVoService {
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private CompetenceRoleMappingService competenceRoleMappingService;
    @Autowired
    private Set<CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo>> competenceRegisters;
    @Autowired(required=false)
    @Lazy
    private List<CompetenceEventListener> competenceListeners;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CompetenceCustomProperties competenceCustomProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceVoServiceImpl.class);

    @Transactional
    public CompetenceVo create(JSONObject competenceJson) {
        Validate.notNull((Object)competenceJson, (String)"\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u529f\u80fd\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceVo currentCompetenceVo = this.convertCompetenceVo(competenceJson, "\u521b\u5efa\u65f6");
        this.createHandle(currentCompetenceVo);
        return currentCompetenceVo;
    }

    @Transactional
    public CompetenceVo create(CompetenceVo competence) {
        this.createHandle(competence);
        return competence;
    }

    private CompetenceVo createHandle(CompetenceVo competence) {
        String parentCode;
        Validate.notNull((Object)competence, (String)"\u5fc5\u987b\u4f20\u5165\u9700\u8981\u6dfb\u52a0\u7684\u529f\u80fd\u4fe1\u606f!!", (Object[])new Object[0]);
        Class<?> competenceClass = competence.getClass();
        boolean isAbs = Modifier.isAbstract(competenceClass.getModifiers());
        Validate.isTrue((!isAbs ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f\u4e0d\u80fd\u662f\u62bd\u8c61\u7684\uff0c\u5fc5\u987b\u6709\u67d0\u4e00\u4e2a\u5177\u4f53\u7684\u529f\u80fd\u5b9e\u73b0\u6a21\u5757\u6240\u652f\u6301!!", (Object[])new Object[0]);
        CompetenceEntity comp = (CompetenceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)competence, CompetenceEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        String account = this.findOpUser();
        comp.setTstatus(NormalStatusEnum.ENABLE.getStatus());
        comp.setCreateTime(new Date());
        comp.setModifyTime(new Date());
        comp.setCreateAccount(account);
        comp.setModifyAccount(account);
        String code = competence.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u6dfb\u52a0\u65f6\uff0c\u83dc\u5355/\u529f\u80fd\u7684\u4e1a\u52a1\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        CompetenceEntity existCompetence = this.competenceRepository.findByCode(code);
        Validate.isTrue((existCompetence == null ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u65f6\u53d1\u73b0\uff0c\u83dc\u5355/\u529f\u80fd\u7684\u4e1a\u52a1\u7f16\u53f7\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        comp.setIcon(competence.getIcon());
        Validate.notNull((Object)competence.getViewItem(), (String)"\u529f\u80fd\u9879\u662f\u5426\u663e\u793a\u5728\u83dc\u5355\u6811\u4e2d\u5fc5\u4f20", (Object[])new Object[0]);
        comp.setViewItem(competence.getViewItem());
        if (competence.getSortIndex() == null) {
            comp.setSortIndex(100);
        }
        if (StringUtils.isNotBlank((CharSequence)(parentCode = competence.getParentCode()))) {
            CompetenceEntity cParent = this.competenceRepository.findByCode(parentCode);
            Validate.notNull((Object)((Object)cParent), (String)"\u672a\u627e\u5230\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            Validate.isTrue((!StringUtils.equals((CharSequence)parentCode, (CharSequence)competence.getCode()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5c06\u81ea\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            CompetenceEntity parentEntity = new CompetenceEntity();
            parentEntity.setId(cParent.getId());
            comp.setParent(parentEntity);
        } else {
            comp.setParent(null);
        }
        this.competenceRepository.saveAndFlush((Object)comp);
        this.competenceRepository.flush();
        competence.setId(comp.getId());
        Set roleCodes = competence.getRoleCodes();
        if (!CollectionUtils.isEmpty((Collection)roleCodes)) {
            for (String roleCode : roleCodes) {
                this.competenceRoleMappingService.bindRole(roleCode, new String[]{comp.getId()});
            }
        }
        if (!CollectionUtils.isEmpty(this.competenceListeners)) {
            this.competenceListeners.forEach(item -> item.onCreated(competence));
        }
        return competence;
    }

    @Transactional
    public List<CompetenceVo> create(JSONArray comps) {
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)comps) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u591a\u6761\u529f\u80fd\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ArrayList competenceVos = Lists.newArrayList();
        for (int index = 0; index < comps.size(); ++index) {
            JSONObject comp = comps.getJSONObject(index);
            CompetenceVo currentCompetenceVo = this.convertCompetenceVo(comp, "\u521b\u5efa\u65f6");
            competenceVos.add(this.create(currentCompetenceVo));
        }
        return competenceVos;
    }

    @Transactional
    public List<CompetenceVo> create(List<CompetenceVo> comps) {
        Validate.isTrue((!CollectionUtils.isEmpty(comps) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u591a\u6761\u529f\u80fd\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (CompetenceVo competence : comps) {
            this.createHandle(competence);
        }
        return comps;
    }

    private String findOpUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String account = "admin";
        if (authentication != null) {
            account = authentication.getName();
        }
        return account;
    }

    private CompetenceVo convertCompetenceVo(JSONObject json, String onTime) {
        Validate.notNull((Object)json, (String)(onTime + "\uff0c\u9519\u8bef\u7684json\u683c\u5f0f\u4fe1\u606f"), (Object[])new Object[0]);
        String type = json.getString("type");
        Validate.notBlank((CharSequence)type, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u6309\u94ae/\u529f\u80fd\u7c7b\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.getCompetenceRegister(type);
        final Class currentButtonClass = matchedCompetenceRegister.getButtonClass();
        final Class currentCompetenceClass = matchedCompetenceRegister.getCompetenceClass();
        ParserConfig parserConfig = new ParserConfig(){

            public ObjectDeserializer getDeserializer(Type type) {
                if (type == ButtonVo.class) {
                    return super.getDeserializer((Type)currentButtonClass);
                }
                if (type == CompetenceVo.class) {
                    return super.getDeserializer((Type)currentCompetenceClass);
                }
                return super.getDeserializer(type);
            }
        };
        CompetenceVo currentCompetenceVo = (CompetenceVo)JSON.parseObject((String)json.toJSONString(), CompetenceVo.class, (ParserConfig)parserConfig, (Feature[])new Feature[0]);
        return currentCompetenceVo;
    }

    @Transactional
    public CompetenceVo update(JSONObject competenceJson) {
        Validate.notNull((Object)competenceJson, (String)"\u4fee\u6539\u529f\u80fd\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u529f\u80fd\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceVo currentCompetenceVo = this.convertCompetenceVo(competenceJson, "\u4fee\u6539\u65f6");
        this.updateHandle(currentCompetenceVo);
        return currentCompetenceVo;
    }

    @Transactional
    public CompetenceVo update(CompetenceVo competence) {
        this.updateHandle(competence);
        return competence;
    }

    private CompetenceVo updateHandle(CompetenceVo competence) {
        Validate.notNull((Object)competence, (String)"\u5fc5\u987b\u4f20\u5165\u9700\u8981\u4fee\u6539\u7684\u529f\u80fd\u4fe1\u606f!!", (Object[])new Object[0]);
        Class<?> competenceClass = competence.getClass();
        boolean isAbs = Modifier.isAbstract(competenceClass.getModifiers());
        Validate.isTrue((!isAbs ? 1 : 0) != 0, (String)"\u4fee\u6539\u529f\u80fd\u65f6\uff0c\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f\u4e0d\u80fd\u662f\u62bd\u8c61\u7684\uff0c\u5fc5\u987b\u6709\u67d0\u4e00\u4e2a\u5177\u4f53\u7684\u529f\u80fd\u5b9e\u73b0\u6a21\u5757\u6240\u652f\u6301!!", (Object[])new Object[0]);
        String compId = competence.getId();
        Validate.notBlank((CharSequence)compId, (String)"\u9519\u8bef\u7684\u529f\u80fd\u4fe1\u606f\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)competence.getViewItem(), (String)"\u529f\u80fd\u9879\u662f\u5426\u663e\u793a\u5728\u83dc\u5355\u6811\u4e2d\u5fc5\u4f20", (Object[])new Object[0]);
        Optional op = this.competenceRepository.findById(compId);
        Validate.isTrue((boolean)op.isPresent(), (String)"id\u4e3a%s\u7684\u529f\u80fd\u5bf9\u8c61\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{compId});
        CompetenceEntity currentComp = (CompetenceEntity)((Object)op.get());
        String account = this.findOpUser();
        currentComp.setModifyAccount(account);
        currentComp.setModifyTime(new Date());
        if (competence.getSortIndex() == null) {
            currentComp.setSortIndex(100);
        } else {
            currentComp.setSortIndex(competence.getSortIndex());
        }
        currentComp.setIcon(competence.getIcon());
        currentComp.setComment(competence.getComment());
        String parentCode = competence.getParentCode();
        CompetenceEntity oldParent = currentComp.getParent();
        if (StringUtils.isNotBlank((CharSequence)parentCode) && (oldParent == null || !oldParent.getCode().equals(parentCode))) {
            CompetenceEntity entity = this.competenceRepository.findByCode(parentCode);
            Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            Validate.isTrue((!parentCode.equals(currentComp.getCode()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5c06\u81ea\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            HashSet<String> compStack = new HashSet<String>();
            compStack.add(currentComp.getId());
            this.validCompetenceCircular(entity, compStack);
            currentComp.setParent(entity);
        } else if (StringUtils.isBlank((CharSequence)parentCode)) {
            currentComp.setParent(null);
        }
        this.competenceRepository.saveAndFlush((Object)currentComp);
        this.competenceRepository.flush();
        if (!CollectionUtils.isEmpty(this.competenceListeners)) {
            this.competenceListeners.forEach(item -> item.onUpdate(competence));
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set roleCodes = competence.getRoleCodes();
        if (CollectionUtils.isEmpty((Collection)roleCodes)) {
            roleCodes = Sets.newLinkedHashSet();
        }
        if (CollectionUtils.isEmpty((Collection)roleCodes) && !this.competenceCustomProperties.getReBindOnRoleUpdate().booleanValue()) {
            return competence;
        }
        this.competenceRoleMappingService.reBindRole(roleCodes.toArray(new String[0]), tenantCode, competence.getId());
        return competence;
    }

    private void validCompetenceCircular(CompetenceEntity competence, Set<String> compStack) {
        Validate.notNull((Object)((Object)competence), (String)"\u5fc5\u987b\u4f20\u5165\u83dc\u5355\u4fe1\u606f", (Object[])new Object[0]);
        CompetenceEntity parent = competence.getParent();
        if (parent == null) {
            return;
        }
        Validate.isTrue((!compStack.contains(parent.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        compStack.add(parent.getId());
        this.validCompetenceCircular(parent, compStack);
    }

    @Transactional
    public void updateStatus(String code, Boolean flag) {
        if (StringUtils.isEmpty((CharSequence)code) || flag == null) {
            throw new IllegalArgumentException("updateStatus\u64cd\u4f5c\u65f6\u53c2\u6570\u9519\u8bef\uff01");
        }
        this.recursiveUpdateStatus(code, flag);
    }

    private void recursiveUpdateStatus(String parentCompetenceCode, Boolean flag) {
        CompetenceEntity competenceEntity = this.competenceRepository.findByCode(parentCompetenceCode);
        if (Boolean.TRUE.equals(flag)) {
            competenceEntity.setTstatus(1);
        } else {
            competenceEntity.setTstatus(0);
        }
        competenceEntity.setModifyTime(new Date());
        this.competenceRepository.save((Object)competenceEntity);
        List<CompetenceEntity> childList = this.competenceRepository.findByParentId(competenceEntity.getId());
        for (int index = 0; childList != null && index < childList.size(); ++index) {
            this.recursiveUpdateStatus(childList.get(index).getCode(), flag);
        }
    }

    @Transactional
    public void deleteByCode(String competenceCode) {
        Validate.notBlank((CharSequence)competenceCode, (String)"\u5220\u9664\u529f\u80fd\u65f6\uff0c\u6307\u5b9a\u7684\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\u5fc5\u987b\u4f20\u9012!!", (Object[])new Object[0]);
        CompetenceEntity currentCompetence = this.competenceRepository.findByCode(competenceCode);
        Validate.notNull((Object)((Object)currentCompetence), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u529f\u80fd\u7f16\u53f7\u7684\u529f\u80fd\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570!!", (Object[])new Object[0]);
        ArrayList deleteList = Lists.newArrayList();
        HashSet deleteButtonList = Sets.newHashSet();
        this.getResultList(deleteList, deleteButtonList, currentCompetence);
        if (!CollectionUtils.isEmpty((Collection)deleteButtonList)) {
            this.buttonRepository.deleteAll(deleteButtonList);
        }
        this.competenceRepository.deleteAll(deleteList);
        if (!CollectionUtils.isEmpty(this.competenceListeners)) {
            List<CompetenceVo> competenceList = this.convertPracticalCompetenceVos(deleteList);
            this.competenceListeners.forEach(item -> item.onDeleted((CompetenceVo)competenceList.get(0)));
        }
    }

    private void getResultList(List<CompetenceEntity> deleteList, Set<ButtonEntity> deleteButtonList, CompetenceEntity currentCompetence) {
        Set<CompetenceRoleMappingEntity> roles = currentCompetence.getRoleMappings();
        Validate.isTrue((boolean)CollectionUtils.isEmpty(roles), (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5df2\u7ecf\u7ed1\u5b9a\u89d2\u8272\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.equals(currentCompetence.getTstatus(), 1), (String)"\u6307\u5b9a\u7684\u529f\u80fd\u4e0d\u662f\u7981\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        deleteList.add(currentCompetence);
        List<CompetenceEntity> childs = this.competenceRepository.findByParentId(currentCompetence.getId());
        Set<ButtonEntity> buttons = currentCompetence.getButtons();
        if (!CollectionUtils.isEmpty(buttons)) {
            deleteButtonList.addAll(buttons);
        }
        if (!CollectionUtils.isEmpty(childs)) {
            childs.forEach(item -> this.getResultList(deleteList, deleteButtonList, (CompetenceEntity)((Object)item)));
        }
    }

    public CompetenceVo findByCompetenceCode(String competenceCode) {
        if (StringUtils.isBlank((CharSequence)competenceCode)) {
            return null;
        }
        CompetenceEntity competenceEntity = this.competenceRepository.findByCode(competenceCode);
        if (competenceEntity == null) {
            return null;
        }
        List<CompetenceVo> results = this.convertPracticalCompetenceVos(Lists.newArrayList((Object[])new CompetenceEntity[]{competenceEntity}));
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        return results.get(0);
    }

    private CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> getCompetenceRegister(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.competenceRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = null;
        for (CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister : this.competenceRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)competenceRegister.getType())) continue;
            matchedCompetenceRegister = competenceRegister;
            break;
        }
        Validate.notNull(matchedCompetenceRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedCompetenceRegister;
    }

    public Set<CompetenceVo> findByViewItemAndCurrentAccount(Boolean viewItem, Integer status, String codeOrComment) {
        String tenantCode = TenantUtils.getTenantCode();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return null;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Collection authorities = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)authorities)) {
            return null;
        }
        Set<String> roleCodes = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(roleCodes)) {
            return null;
        }
        return this.findByViewItemAndRoleCodesAndStatus(viewItem, tenantCode, roleCodes.toArray(new String[0]), status, codeOrComment);
    }

    public Set<CompetenceVo> findByRoleCodes(String tenantCode, String[] roleCodes) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || roleCodes == null || roleCodes.length == 0) {
            return null;
        }
        return this.findByViewItemAndRoleCodesAndStatus(true, tenantCode, roleCodes, null, null);
    }

    public Set<CompetenceVo> findByViewItemAndRoleCodesAndStatus(Boolean viewItem, String tenantCode, String[] roleCodes, Integer status, String codeOrComment) {
        List<CompetenceEntity> competenceEntities;
        CompetenceDto competenceConditions = new CompetenceDto();
        competenceConditions.setCodeOrComment(codeOrComment);
        competenceConditions.setRoleCodes(roleCodes == null ? null : Sets.newHashSet((Object[])roleCodes));
        competenceConditions.setTenantCode(tenantCode);
        competenceConditions.setTstatus(status);
        competenceConditions.setViewItem(viewItem);
        if (roleCodes != null && this.comfirmAdmin(roleCodes)) {
            competenceConditions.setRoleCodes(null);
        }
        if (CollectionUtils.isEmpty(competenceEntities = this.competenceRepository.findAllByConditions(competenceConditions))) {
            return Sets.newHashSet();
        }
        List<CompetenceVo> queryResultCompetences = this.convertPracticalCompetenceVos(competenceEntities);
        Map<String, CompetenceVo> exsitQueryCompetenceMapping = queryResultCompetences.stream().collect(Collectors.toMap(CompetenceVo::getCode, item -> item));
        TreeSet<CompetenceVo> buildedCompetenceRoots = new TreeSet<CompetenceVo>(new Comparator<CompetenceVo>(){

            @Override
            public int compare(CompetenceVo source, CompetenceVo target) {
                int targetIndex;
                int sourceIndex = source.getSortIndex() == null ? 0 : source.getSortIndex();
                int n = targetIndex = target.getSortIndex() == null ? 0 : target.getSortIndex();
                if (sourceIndex - targetIndex != 0) {
                    return sourceIndex - targetIndex;
                }
                return StringUtils.compare((String)source.getComment(), (String)target.getComment());
            }
        });
        for (CompetenceVo queryResultCompetence : queryResultCompetences) {
            this.recursiveButildCompetenceForTree(queryResultCompetence, exsitQueryCompetenceMapping, buildedCompetenceRoots);
        }
        return buildedCompetenceRoots;
    }

    private boolean comfirmAdmin(String[] roleCodes) {
        boolean isAdmin = false;
        if (roleCodes != null && roleCodes.length > 0) {
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.rbacCustomProperties.getIgnoreMethodCheckRoles()), (Set)Sets.newHashSet((Object[])roleCodes));
            isAdmin = !CollectionUtils.isEmpty((Collection)intersections);
        }
        return isAdmin;
    }

    private void recursiveButildCompetenceForTree(CompetenceVo queryResultCompetence, Map<String, CompetenceVo> exsitQueryCompetenceMapping, Set<CompetenceVo> buildedCompetenceRoots) {
        String parentCode = queryResultCompetence.getParentCode();
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            buildedCompetenceRoots.add(queryResultCompetence);
            return;
        }
        CompetenceVo parantCompetence = exsitQueryCompetenceMapping.get(parentCode);
        if (parantCompetence == null && (parantCompetence = this.findByCompetenceCode(parentCode)) != null) {
            exsitQueryCompetenceMapping.put(parantCompetence.getCode(), parantCompetence);
        }
        if (parantCompetence == null) {
            return;
        }
        List children = parantCompetence.getChildren();
        if (children == null) {
            children = Lists.newArrayList();
            parantCompetence.setChildren(children);
        }
        if (children.stream().filter(item -> StringUtils.equals((CharSequence)item.getCode(), (CharSequence)queryResultCompetence.getCode())).count() == 0L) {
            children.add(queryResultCompetence);
        }
        children.sort(new Comparator<CompetenceVo>(){

            @Override
            public int compare(CompetenceVo source, CompetenceVo target) {
                int targetIndex;
                int sourceIndex = source.getSortIndex() == null ? 0 : source.getSortIndex();
                int n = targetIndex = target.getSortIndex() == null ? 0 : target.getSortIndex();
                if (sourceIndex - targetIndex != 0) {
                    return sourceIndex - targetIndex;
                }
                return StringUtils.compare((String)source.getComment(), (String)target.getComment());
            }
        });
        if (children.size() == 1) {
            this.recursiveButildCompetenceForTree(parantCompetence, exsitQueryCompetenceMapping, buildedCompetenceRoots);
        }
    }

    private List<CompetenceVo> convertPracticalCompetenceVos(List<CompetenceEntity> currentMenuCompetences) {
        Map<String, List<CompetenceEntity>> competencesGroupForType = currentMenuCompetences.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.groupingBy(CompetenceEntity::getType));
        Map<String, CompetenceEntity> competenceEntitesMappingForCode = currentMenuCompetences.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(CompetenceEntity::getCode, item -> item));
        ArrayList menuCompetences = Lists.newArrayList();
        for (Map.Entry<String, List<CompetenceEntity>> menuCompetencesGroupItems : competencesGroupForType.entrySet()) {
            List<CompetenceEntity> groupMenuCompetences = menuCompetencesGroupItems.getValue();
            if (CollectionUtils.isEmpty(groupMenuCompetences)) continue;
            String type = menuCompetencesGroupItems.getKey();
            CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.getCompetenceRegister(type);
            Set practicalCompetenceVos = matchedCompetenceRegister.onRequestCompetenceVos(groupMenuCompetences.stream().map(CompetenceEntity::getCode).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)practicalCompetenceVos)) {
                for (CompetenceVo competenceVo : practicalCompetenceVos) {
                    CompetenceEntity competenceBaseEntity = competenceEntitesMappingForCode.get(competenceVo.getCode());
                    Validate.notNull((Object)((Object)competenceBaseEntity), (String)"\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u8fd4\u56de\u4e86\u9519\u8bef\u7684CompetenceVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceVo.getCode()});
                    this.perfectInformation(competenceVo, competenceBaseEntity);
                    menuCompetences.add(competenceVo);
                }
                continue;
            }
            for (CompetenceEntity competenceBaseEntity : groupMenuCompetences) {
                CompetenceVo competenceVo = null;
                try {
                    competenceVo = (CompetenceVo)matchedCompetenceRegister.getCompetenceClass().newInstance();
                    this.perfectInformation(competenceVo, competenceBaseEntity);
                    menuCompetences.add(competenceVo);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u6ca1\u6709\u8fd4\u56de\u6b63\u786e\u7684\u7684CompetenceVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f\u65f6\uff0c\u8bd5\u56fe\u76f4\u63a5\u521d\u59cb\u5316\u5177\u4f53\u7684CompetenceVo\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!");
                }
            }
        }
        Map<String, CompetenceVo> competenceVosMappingForCode = menuCompetences.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(CompetenceVo::getCode, item -> item));
        ArrayList sortedMenuCompetences = Lists.newArrayList();
        for (CompetenceEntity currentCompetence : currentMenuCompetences) {
            CompetenceVo currentCompetenceVo = competenceVosMappingForCode.get(currentCompetence.getCode());
            if (currentCompetenceVo != null) {
                sortedMenuCompetences.add(currentCompetenceVo);
                continue;
            }
            LOGGER.error("id\u4e3a{}\uff0ctype\u4e3a{}\u7684\u529f\u80fd\uff0c\u672a\u8fdb\u884c\u6b63\u786e\u8f6c\u6362,\u8bf7\u68c0\u67e5\u6570\u636e\u4fe1\u606f!!", (Object)currentCompetence.getId(), (Object)currentCompetence.getType());
        }
        return sortedMenuCompetences;
    }

    private void perfectInformation(CompetenceVo competenceVo, CompetenceEntity competenceBaseEntity) {
        competenceVo.setId(competenceBaseEntity.getId());
        competenceVo.setType(competenceBaseEntity.getType());
        competenceVo.setCode(competenceBaseEntity.getCode());
        competenceVo.setComment(competenceBaseEntity.getComment());
        competenceVo.setViewItem(competenceBaseEntity.getViewItem());
        competenceVo.setTstatus(competenceBaseEntity.getTstatus());
        competenceVo.setSortIndex(competenceBaseEntity.getSortIndex());
        competenceVo.setIcon(competenceBaseEntity.getIcon());
        Set<CompetenceRoleMappingEntity> roleMappings = competenceBaseEntity.getRoleMappings();
        if (!CollectionUtils.isEmpty(roleMappings)) {
            Set roleCodes = roleMappings.stream().map(CompetenceRoleMappingEntity::getRoleCode).distinct().collect(Collectors.toSet());
            competenceVo.setRoleCodes(roleCodes);
        }
        try {
            if (competenceBaseEntity.getParent() != null) {
                competenceVo.setParentCode(competenceBaseEntity.getParent().getCode());
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn(e.getMessage());
        }
    }
}

