/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.config;

import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.notifier.AuthenticationCompetenceEventListenerImpl;
import com.bizunited.nebula.competence.local.repository.task.ButtonEntityCacheQueryTask;
import com.bizunited.nebula.competence.local.repository.task.CompetenceEntityCacheQueryTask;
import com.bizunited.nebula.competence.local.service.query.QueryByButtonCodeAndRoleCodes;
import com.bizunited.nebula.competence.local.service.query.QueryByCompetenceCode;
import com.bizunited.nebula.competence.local.service.query.QueryByCompetenceTypeAndStatus;
import com.bizunited.nebula.competence.local.service.query.QueryByParentNull;
import com.bizunited.nebula.competence.local.service.query.QueryByResourcesAndMethodAndRoleCodes;
import com.bizunited.nebula.competence.local.service.query.QueryByViewItemAndRoleCodesAndCodeOrComment;
import com.bizunited.nebula.security.sdk.event.AuthenticationCompetenceEventListener;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.stereotype.Component;

@Configuration
@EntityScan(basePackages={"com.bizunited.nebula.competence.local.entity"})
@EnableJpaRepositories(basePackages={"com.bizunited.nebula.competence.local.repository"})
@ComponentScan(basePackages={"com.bizunited.nebula.competence"})
@Component(value="competenceAutoConfiguration")
public class CompetenceAutoConfiguration {
    @Bean
    @Lazy
    @Scope(value="prototype")
    public ButtonEntityCacheQueryTask getButtonEntityCacheQueryTask(String tenantCode, String appCode, List<ButtonEntity> buttonEntities) {
        return new ButtonEntityCacheQueryTask(tenantCode, appCode, buttonEntities);
    }

    @Bean
    @Lazy
    @Scope(value="prototype")
    public CompetenceEntityCacheQueryTask getCompetenceEntityCacheQueryTask(List<CompetenceEntity> sourceCompetences, String tenantCode, String appCode) {
        return new CompetenceEntityCacheQueryTask(sourceCompetences, tenantCode, appCode);
    }

    @Bean(value={"_competenceCacheQueryExecutor"})
    public ThreadPoolExecutor getCompetenceCacheQueryExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(20, 30, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                currentThread.setName("c_query_executor-" + this.atomicInteger.getAndIncrement());
                return currentThread;
            }
        });
        return threadPoolExecutor;
    }

    @Bean(value={"_buttonCacheQueryExecutor"})
    public ThreadPoolExecutor getButtonCacheQueryExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(20, 30, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread currentThread = new Thread(r);
                currentThread.setName("b_query_executor-" + this.atomicInteger.getAndIncrement());
                return currentThread;
            }
        });
        return threadPoolExecutor;
    }

    @Bean
    @Primary
    public AuthenticationCompetenceEventListener getAuthenticationCompetenceEventListener() {
        return new AuthenticationCompetenceEventListenerImpl();
    }

    @Lazy
    @Bean
    @Scope(value="prototype")
    public QueryByViewItemAndRoleCodesAndCodeOrComment getQueryByViewItemAndRoleCodesAndCodeOrComment(Boolean viewItem, boolean isAdmin, String tenantCode, String[] roleCodes, Integer status, String codeOrComment, String[] ignoreMethodCheckRoles) {
        return new QueryByViewItemAndRoleCodesAndCodeOrComment(viewItem, isAdmin, tenantCode, roleCodes, status, codeOrComment, ignoreMethodCheckRoles);
    }

    @Lazy
    @Bean
    @Scope(value="prototype")
    public QueryByResourcesAndMethodAndRoleCodes getQueryByResourcesAndMethodAndRoleCodes(String[] resources, boolean like, String method, Integer status, String tenantCode, String[] roleCodes, String type, boolean isAdmin, String[] ignoreMethodCheckRoles) {
        return new QueryByResourcesAndMethodAndRoleCodes(resources, like, method, status, tenantCode, roleCodes, type, isAdmin, ignoreMethodCheckRoles);
    }

    @Lazy
    @Bean
    @Scope(value="prototype")
    public QueryByCompetenceTypeAndStatus getQueryByCompetenceTypeAndStatus(String type, Integer status, String tenantCode) {
        return new QueryByCompetenceTypeAndStatus(type, status, tenantCode);
    }

    @Lazy
    @Bean
    @Scope(value="prototype")
    public QueryByParentNull getQueryByParentNull(Boolean viewItem, String tenantCode, Integer status) {
        return new QueryByParentNull(viewItem, tenantCode, status);
    }

    @Lazy
    @Bean
    @Scope(value="prototype")
    public QueryByCompetenceCode getQueryByCompetenceCode(String competenceCode, String tenantCode) {
        return new QueryByCompetenceCode(competenceCode, tenantCode);
    }

    @Lazy
    @Bean
    @Scope(value="prototype")
    public QueryByButtonCodeAndRoleCodes getQueryByButtonCodeAndRoleCodes(String tenantCode, String[] roleCodes, Boolean viewItem, String buttonCode, boolean isAdmin, String[] ignoreMethodCheckRoles) {
        return new QueryByButtonCodeAndRoleCodes(tenantCode, roleCodes, viewItem, buttonCode, isAdmin, ignoreMethodCheckRoles);
    }
}

