/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.competence.sdk.service.ButtonVoService;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/competences/buttons"})
public class ButtonVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonVoController.class);
    @Autowired
    private ButtonVoService buttonVoService;

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u6309\u94ae", notes="\u521b\u5efa\u6309\u94ae\uff0c\u5fc5\u987b\u8981\u4f20\u9012\u83dc\u5355\u5bf9\u8c61\uff0c\u5e76\u4e14\u83dc\u5355\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a")
    public ResponseModel create(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody JSONObject button) {
        try {
            ButtonVo result = this.buttonVoService.create(button);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/batchCreate"})
    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u6309\u94ae", notes="\u521b\u5efa\u6309\u94ae\uff0c\u5fc5\u987b\u8981\u4f20\u9012\u83dc\u5355\u5bf9\u8c61\uff0c\u5e76\u4e14\u83dc\u5355\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a")
    public ResponseModel batchCreate(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody JSONArray buttons) {
        try {
            List results = this.buttonVoService.create(buttons);
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping
    @ApiOperation(value="\u4fee\u6539\u6309\u94ae", notes="\u4fee\u6539\u6309\u94ae")
    public ResponseModel update(@ApiParam(value="\u6309\u94ae\u5b9e\u4f53\u4fe1\u606f") @RequestBody JSONObject button) {
        try {
            ButtonVo result = this.buttonVoService.update(button);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"/deleteByCode"})
    @ApiOperation(value="\u6839\u636ecode\u5220\u9664\u6309\u94ae", notes="\u6839\u636ecode\u5220\u9664\u6309\u94ae")
    public ResponseModel deleteByCode(@ApiParam(name="code", value="\u6309\u94ae\u7f16\u7801", required=true) @RequestParam String code) {
        try {
            this.buttonVoService.deleteByCode(code);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6309\u94ae\u7684\u4e1a\u52a1\u7f16\u53f7\u8fdb\u884c\u67e5\u8be2")
    @GetMapping(value={"findByCode"})
    public ResponseModel findByCode(@RequestParam(name="code") @ApiParam(name="code", value="\u6307\u5b9a\u7684\u6309\u94ae\u7684\u4e1a\u52a1\u7f16\u53f7") String code) {
        try {
            ButtonVo buttonVo = this.buttonVoService.findByCode(code);
            return this.buildHttpResult(buttonVo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCompetenceCode"})
    @ApiOperation(value="\u6839\u636e\u529f\u80fd/\u83dc\u5355\u4e1a\u52a1\u7f16\u53f7\u67e5\u8be2\u6309\u94ae", notes="\u6839\u636e\u529f\u80fd/\u83dc\u5355\u4e1a\u52a1\u7f16\u53f7\u67e5\u8be2\u6309\u94ae")
    public ResponseModel findByCompetenceCode(@ApiParam(name="competenceCode", value="\u529f\u80fd/\u83dc\u5355\u4e1a\u52a1\u7f16\u53f7", required=true) @RequestParam(value="competenceCode") String competenceCode) {
        try {
            List result = this.buttonVoService.findByCompetenceCode(competenceCode);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findByRoleCodesAndCompetenceCodes"})
    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u89d2\u8272\u4e1a\u52a1\u7f16\u7801\u548c\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\uff0c\u67e5\u8be2\u5df2\u7ecf\u7ed1\u5b9a\u7684\u6309\u94ae\u4fe1\u606f\uff08\u5f53\u7136\u662f\u5f53\u524d\u7684\u4e8c\u7ea7\u79df\u6237\u4e0b\u7684\uff09")
    public ResponseModel findByRoleCodesAndCompetenceCodes(@ApiParam(name="roleCodes", value="\u6307\u5b9a\u7684\u89d2\u8272\u4e1a\u52a1\u7f16\u7801(\u53ef\u4ee5\u4e00\u4e2a\uff0c\u4e5f\u53ef\u4ee5\u591a\u4e2a)", required=true) @RequestParam(value="roleCodes") String[] roleCodes, @ApiParam(name="competenceCodes", value="\u6307\u5b9a\u7684\u529f\u80fd\u4e1a\u52a1\u7f16\u7801\uff08\u53ef\u4ee5\u4e00\u4e2a\u4e5f\u53ef\u4ee5\u591a\u4e2a\uff09", required=true) @RequestParam(value="competenceCodes") String[] competenceCodes) {
        try {
            List result = this.buttonVoService.findByRoleCodesAndCompetenceCodes(roleCodes, competenceCodes);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

