/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.service.CompetenceRoleMappingService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/competences/competenceRoleMapping"})
public class CompetenceRoleMappingController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceRoleMappingController.class);
    @Autowired
    private CompetenceRoleMappingService competenceRoleMappingService;

    @ApiOperation(value="\u5efa\u7acb\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/bindRole"})
    public ResponseModel bindRole(@RequestParam(name="roleCode") @ApiParam(name="roleCode", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleCode, @RequestParam(name="competenceCodes") @ApiParam(name="competenceCodes", value="\u6307\u5b9a\u7684\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceCodes) {
        try {
            this.competenceRoleMappingService.bindRole(roleCode, competenceCodes);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @PatchMapping(value={"/unbindByRoleCodeAndCompetenceCodes"})
    public ResponseModel unbindByRoleCodeAndCompetenceCodes(@RequestParam(name="roleCode") @ApiParam(name="roleCode", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleCode, @RequestParam(name="competenceCodes") @ApiParam(name="competenceCodes", value="\u6307\u5b9a\u7684\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceCodes) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            this.competenceRoleMappingService.unbindByRoleCodeAndCompetenceCodes(roleCode, tenantCode, competenceCodes);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\uff08\u591a\u4e2a\uff09\u8fdb\u884c\u91cd\u7ed1\u5b9a")
    @PatchMapping(value={"/reBindRole"})
    public ResponseModel reBindRole(@RequestParam(name="roleCode") @ApiParam(name="roleCode", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleCode, @RequestParam(name="competenceCodes") @ApiParam(name="competenceCodes", value="\u6307\u5b9a\u7684\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceCodes) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            this.competenceRoleMappingService.reBindRole(roleCode, tenantCode, competenceCodes);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

