/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.notifier;

import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.service.ButtonService;
import com.bizunited.nebula.competence.local.service.CompetenceService;
import com.bizunited.nebula.competence.sdk.service.ButtonRoleMappingService;
import com.bizunited.nebula.competence.sdk.service.CompetenceRoleMappingService;
import com.bizunited.nebula.rbac.sdk.event.RoleCopyEventListener;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CompetenceAndButtonForRoleCopyEventListener
implements RoleCopyEventListener {
    private static final Logger log = LoggerFactory.getLogger(CompetenceAndButtonForRoleCopyEventListener.class);
    @Autowired
    private CompetenceRoleMappingService competenceRoleMappingService;
    @Autowired
    private ButtonRoleMappingService buttonRoleMappingService;
    @Autowired
    private CompetenceService competenceService;
    @Autowired
    private ButtonService buttonService;

    @Transactional
    public void onCopied(RoleVo roleVo) {
        Validate.notNull((Object)roleVo, (String)"\u590d\u5236\u529f\u80fd\u6743\u9650\u65f6\uff0c\u89d2\u8272\u4fe1\u606f\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String roleCode = roleVo.getRoleCode();
        String copyRoleCode = roleVo.getCopyRoleCode();
        Validate.notBlank((CharSequence)roleCode, (String)"\u590d\u5236\u529f\u80fd\u6743\u9650\u65f6\uff0c\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)copyRoleCode, (String)"\u590d\u5236\u529f\u80fd\u6743\u9650\u65f6\uff0c\u88ab\u590d\u5236\u7684\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = roleVo.getTenantCode();
        List competenceIdsByRoleCode = this.competenceRoleMappingService.findCompetenceIdsByRoleCode(copyRoleCode, tenantCode);
        if (CollectionUtils.isEmpty((Collection)competenceIdsByRoleCode)) {
            return;
        }
        List<CompetenceEntity> competenceEntities = this.competenceService.findByIds(competenceIdsByRoleCode);
        if (CollectionUtils.isEmpty(competenceEntities)) {
            return;
        }
        String[] competenceCodes = (String[])competenceEntities.stream().map(CompetenceEntity::getCode).toArray(String[]::new);
        this.competenceRoleMappingService.bindRole(roleCode, competenceCodes);
        List buttonsIdsByRoleCode = this.buttonRoleMappingService.findButtonsIdsByRoleCode(copyRoleCode, tenantCode);
        if (CollectionUtils.isEmpty((Collection)buttonsIdsByRoleCode)) {
            return;
        }
        List<ButtonEntity> buttonEntities = this.buttonService.findByIds(buttonsIdsByRoleCode);
        if (CollectionUtils.isEmpty(buttonEntities)) {
            return;
        }
        String[] buttonCodes = (String[])buttonEntities.stream().map(ButtonEntity::getCode).toArray(String[]::new);
        this.buttonRoleMappingService.bindRole(roleCode, tenantCode, buttonCodes);
        log.debug("\u590d\u5236\u529f\u80fd\u6743\u9650\u5b8c\u6210.....");
    }
}

