/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.notifier;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.config.CompetenceCustomProperties;
import com.bizunited.nebula.competence.sdk.service.CompetenceRoleMappingService;
import com.bizunited.nebula.competence.sdk.service.CompetenceVoService;
import com.bizunited.nebula.rbac.sdk.event.RoleEventListener;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CompetenceForRoleEventListener
implements RoleEventListener {
    private static final String COMPETENCE_NAME = "competence";
    @Autowired
    private CompetenceRoleMappingService competenceRoleMappingService;
    @Autowired
    private CompetenceVoService competenceVoService;
    @Autowired
    private CompetenceCustomProperties competenceCustomProperties;

    public void onCreated(RoleVo role) {
        Map functionMaps = role.getFunctionMaps();
        if (CollectionUtils.isEmpty((Map)functionMaps)) {
            return;
        }
        Set competenceCodes = (Set)functionMaps.get(COMPETENCE_NAME);
        if (CollectionUtils.isEmpty((Collection)competenceCodes)) {
            return;
        }
        String roleCode = role.getRoleCode();
        this.competenceRoleMappingService.bindRole(roleCode, competenceCodes.toArray(new String[0]));
    }

    public void onUpdate(RoleVo role) {
        if (!this.competenceCustomProperties.getReBindOnRoleUpdate().booleanValue()) {
            return;
        }
        Map functionMaps = role.getFunctionMaps();
        Set competenceCodes = (Set)functionMaps.get(COMPETENCE_NAME);
        if (CollectionUtils.isEmpty((Collection)competenceCodes)) {
            competenceCodes = Sets.newHashSet();
        }
        String roleCode = role.getRoleCode();
        String tenantCode = TenantUtils.getTenantCode();
        this.competenceRoleMappingService.reBindRole(roleCode, tenantCode, competenceCodes.toArray(new String[0]));
    }

    public void onDeleted(RoleVo role) {
        String tenantCode = role.getTenantCode();
        Set competences = this.competenceVoService.findByRoleCodes(tenantCode, new String[]{role.getRoleCode()});
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)competences), (String)"\u8fdb\u884c\u89d2\u8272\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u5f53\u524d\u89d2\u8272\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u529f\u80fd\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
    }
}

