/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository;

import com.bizunited.nebula.competence.local.entity.ButtonRoleMappingEntity;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ButtonRoleMappingRepository
extends JpaRepository<ButtonRoleMappingEntity, String>,
JpaSpecificationExecutor<ButtonRoleMappingEntity> {
    @Modifying
    @Query(value="delete from engine_role_button_mapping where role_code = :roleCode and button_id = :buttonId and tenant_code = :tenantCode ", nativeQuery=true)
    public void unbindByRoleCodeAndButtonId(@Param(value="roleCode") String var1, @Param(value="tenantCode") String var2, @Param(value="buttonId") String var3);

    @Modifying
    @Query(value="delete from engine_role_button_mapping where role_code = :roleCode and tenant_code = :tenantCode ", nativeQuery=true)
    public void unbindByRoleCode(@Param(value="roleCode") String var1, @Param(value="tenantCode") String var2);

    @Modifying
    @Query(value="delete from engine_role_button_mapping where button_id = :buttonId ", nativeQuery=true)
    public void unbindByButtonId(@Param(value="buttonId") String var1);

    @Modifying
    @Query(value="delete from engine_role_button_mapping where button_id = :buttonId and tenant_code = :tenantCode ", nativeQuery=true)
    public void unbindByButtonId(@Param(value="buttonId") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select count(*) from engine_role_button_mapping where button_id = :buttonId ", nativeQuery=true)
    public long countByButtonId(@Param(value="buttonId") String var1);

    @Query(value="select count(*) from engine_role_button_mapping where role_code = :roleCode and button_id = :buttonId and tenant_code = :tenantCode ", nativeQuery=true)
    public long countByRoleCodeAndButtonIdAndTenantCode(@Param(value="roleCode") String var1, @Param(value="buttonId") String var2, @Param(value="tenantCode") String var3);

    @Query(value="select count(*) from engine_role_button_mapping where role_code = :roleCode and tenant_code = :tenantCode ", nativeQuery=true)
    public long countByRoleCodeAndTenantCode(@Param(value="roleCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select distinct r from ButtonRoleMappingEntity r  where r.roleCode in (:roleCodes) and r.tenantCode = :tenantCode ")
    public Set<ButtonRoleMappingEntity> findByRoleCodesAndTenantCode(@Param(value="roleCodes") List<String> var1, @Param(value="tenantCode") String var2);

    @Query(value="select distinct r from ButtonRoleMappingEntity r  where r.button.id in (:buttonIds) and r.tenantCode = :tenantCode ")
    public Set<ButtonRoleMappingEntity> findByButtonIdsAndTenantCode(@Param(value="buttonIds") List<String> var1, @Param(value="tenantCode") String var2);

    @Query(value="select m.button_id from engine_role_button_mapping m where m.role_code = :roleCode and m.tenant_code = :tenantCode ", nativeQuery=true)
    public List<String> findButtonsIdsByRoleCode(@Param(value="roleCode") String var1, @Param(value="tenantCode") String var2);
}

