/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.competence.local.dto.CompetenceDto;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.repository.internal.CompetenceRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CompetenceRepositoryImpl
implements CompetenceRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String COMMENT = "comment";
    private static final String TSTATUS = "tstatus";

    @Override
    public Page<CompetenceEntity> findByConditions(Pageable pageable, CompetenceDto competence) {
        StringBuilder hql = new StringBuilder("select distinct co from CompetenceEntity co left join fetch co.parent cop left join fetch co.roleMappings rmp where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(co) from CompetenceEntity co left join co.roleMappings rmp where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (competence != null) {
            if (StringUtils.isNotBlank((CharSequence)competence.getCodeOrComment())) {
                condition.append(" AND (co.comment like CONCAT('%', :codeOrComment,'%') or co.code like CONCAT('%', :codeOrComment,'%')) ");
                parameter.put(COMMENT, competence.getCodeOrComment());
            }
            if (competence.getTstatus() != null) {
                condition.append(" AND co.tstatus = :tstatus ");
                parameter.put(TSTATUS, competence.getTstatus());
            }
            if (competence.getViewItem() != null) {
                condition.append(" AND co.viewItem = :viewItem ");
                parameter.put("viewItem", competence.getViewItem() != false ? 1 : 0);
            }
            if (StringUtils.isNotBlank((CharSequence)competence.getTenantCode()) && !CollectionUtils.isEmpty(competence.getRoleCodes())) {
                condition.append(" AND rmp.roleCode in (:roleCodes) AND rmp.tenantCode = :tenantCode ");
                parameter.put("roleCodes", competence.getRoleCodes());
                parameter.put("tenantCode", competence.getTenantCode());
            }
        }
        hql.append((CharSequence)condition).append(" order by co.sortIndex , co.code ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }

    @Override
    public List<CompetenceEntity> findAllByConditions(CompetenceDto competence) {
        StringBuilder hql = new StringBuilder("select distinct co from CompetenceEntity co left join fetch co.parent cop left join fetch co.roleMappings rmp where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (competence != null) {
            if (StringUtils.isNotBlank((CharSequence)competence.getCodeOrComment())) {
                condition.append(" AND (co.comment like CONCAT('%', :codeOrComment,'%') or co.code like CONCAT('%', :codeOrComment,'%')) ");
                parameter.put("codeOrComment", competence.getCodeOrComment());
            }
            if (competence.getTstatus() != null) {
                condition.append(" AND co.tstatus = :tstatus ");
                parameter.put(TSTATUS, competence.getTstatus());
            }
            if (competence.getViewItem() != null) {
                condition.append(" AND co.viewItem = :viewItem ");
                parameter.put("viewItem", competence.getViewItem() != false ? 1 : 0);
            }
            if (StringUtils.isNotBlank((CharSequence)competence.getTenantCode()) && !CollectionUtils.isEmpty(competence.getRoleCodes())) {
                condition.append(" AND rmp.roleCode in (:roleCodes) AND rmp.tenantCode = :tenantCode ");
                parameter.put("roleCodes", competence.getRoleCodes());
                parameter.put("tenantCode", competence.getTenantCode());
            }
        }
        hql.append((CharSequence)condition).append(" order by co.sortIndex , co.code ");
        Query query = this.entityManager.createQuery(hql.toString());
        parameter.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return query.getResultList();
    }
}

