/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceRoleMappingEntity;
import com.bizunited.nebula.competence.local.repository.CompetenceRepository;
import com.bizunited.nebula.competence.local.repository.CompetenceRoleMappingRepository;
import com.bizunited.nebula.competence.sdk.service.CompetenceRoleMappingService;
import com.bizunited.nebula.rbac.sdk.service.RoleVoService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompetenceRoleMappingServiceImpl
implements CompetenceRoleMappingService {
    @Autowired
    private CompetenceRoleMappingRepository competenceRoleMappingRepository;
    @Autowired
    private RoleVoService roleVoService;
    @Autowired
    private CompetenceRepository competenceRepository;

    @Transactional
    public void bindRole(String roleCode, String[] competenceCodes) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        RoleVo role = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)role, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u672a\u5728\u5f53\u524d\u4e8c\u7ea7\u79df\u6237\u4e0b\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((competenceCodes != null && competenceCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceCode : competenceCodes) {
            CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
            Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
            long count = this.competenceRoleMappingRepository.countByRoleCodeAndCompetenceIdAndTenantCode(roleCode, opCompetence.getId(), tenantCode);
            if (count != 0L) continue;
            CompetenceRoleMappingEntity newCompetenceRoleMapping = new CompetenceRoleMappingEntity();
            newCompetenceRoleMapping.setCompetence(opCompetence);
            newCompetenceRoleMapping.setRoleCode(roleCode);
            newCompetenceRoleMapping.setTenantCode(tenantCode);
            this.competenceRoleMappingRepository.save((Object)newCompetenceRoleMapping);
        }
    }

    @Transactional
    public void unbindByRoleCodeAndCompetenceCodes(String roleCode, String tenantCode, String[] competenceCodes) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        RoleVo role = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)role, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u672a\u5728\u5f53\u524d\u4e8c\u7ea7\u79df\u6237\u4e0b\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((competenceCodes != null && competenceCodes.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceCode : competenceCodes) {
            CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
            Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
            this.competenceRoleMappingRepository.unbindByRoleCodeAndCompetenceId(roleCode, tenantCode, opCompetence.getId());
        }
    }

    @Transactional
    public void unbindByRoleCode(String roleCode, String tenantCode) {
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        RoleVo role = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)role, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u672a\u5728\u5f53\u524d\u4e8c\u7ea7\u79df\u6237\u4e0b\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.competenceRoleMappingRepository.unbindByRoleCode(roleCode, tenantCode);
    }

    @Transactional
    public void reBindRole(String roleCode, String tenantCode, String[] competenceCodes) {
        Validate.notBlank((CharSequence)roleCode, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u91cd\u65b0\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        RoleVo role = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        Validate.notNull((Object)role, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u91cd\u7ed1\u5b9a\u65f6\uff0c\u672a\u5728\u5f53\u524d\u4e8c\u7ea7\u79df\u6237\u4e0b\u627e\u5230\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.competenceRoleMappingRepository.unbindByRoleCode(roleCode, tenantCode);
        this.competenceRoleMappingRepository.flush();
        if (competenceCodes == null || competenceCodes.length == 0) {
            return;
        }
        for (String competenceCode : competenceCodes) {
            CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
            Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
            CompetenceRoleMappingEntity newCompetenceRoleMapping = new CompetenceRoleMappingEntity();
            newCompetenceRoleMapping.setCompetence(opCompetence);
            newCompetenceRoleMapping.setRoleCode(roleCode);
            newCompetenceRoleMapping.setTenantCode(tenantCode);
            this.competenceRoleMappingRepository.save((Object)newCompetenceRoleMapping);
        }
    }

    public void reBindRole(String[] roleCodes, String tenantCode, String competenceId) {
        Validate.notBlank((CharSequence)competenceId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u91cd\u65b0\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u529f\u80fd\u6280\u672f\u7f16\u53f7!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        CompetenceEntity opCompetence = this.competenceRepository.findById(competenceId).orElse(null);
        Validate.notNull((Object)((Object)opCompetence), (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u91cd\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u529f\u80fd/\u83dc\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.competenceRoleMappingRepository.unbindByCompetenceId(competenceId, tenantCode);
        this.competenceRoleMappingRepository.flush();
        if (roleCodes == null || roleCodes.length == 0) {
            return;
        }
        for (String roleCode : roleCodes) {
            RoleVo currentRole = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
            Validate.notNull((Object)currentRole, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{roleCode});
            CompetenceRoleMappingEntity newCompetenceRoleMapping = new CompetenceRoleMappingEntity();
            newCompetenceRoleMapping.setCompetence(opCompetence);
            newCompetenceRoleMapping.setRoleCode(roleCode);
            newCompetenceRoleMapping.setTenantCode(tenantCode);
            this.competenceRoleMappingRepository.save((Object)newCompetenceRoleMapping);
        }
    }

    public List<String> findCompetenceIdsByRoleCode(String copyRoleCode, String tenantCode) {
        if (StringUtils.isBlank((CharSequence)copyRoleCode)) {
            return new ArrayList<String>(0);
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        return this.competenceRoleMappingRepository.findCompetenceIdsByRoleCode(copyRoleCode, tenantCode);
    }
}

