/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.query;

import com.bizunited.nebula.competence.local.service.query.AbstractCompetenceQueryStrategy;
import com.bizunited.nebula.competence.local.service.query.CompetenceQueryStrategy;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class QueryByCompetenceCode
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private String competenceCode;
    private String tenantCode;

    public QueryByCompetenceCode(String competenceCode, String tenantCode) {
        this.competenceCode = competenceCode;
        Validate.notBlank((CharSequence)competenceCode, (String)"\u8fdb\u884c\u67e5\u8be2\u65f6\uff0c\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        this.tenantCode = tenantCode;
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u67e5\u8be2\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u7f16\u53f7\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
    }

    @Override
    public boolean filterCompetence(CompetenceVo competence) {
        String code = competence.getCode();
        return StringUtils.equals((CharSequence)code, (CharSequence)this.competenceCode);
    }

    @Override
    public CompetenceVo clone(CompetenceVo sourceCompetence) {
        return this.cloneCompetence(sourceCompetence, this.tenantCode, null, null);
    }

    @Override
    public ButtonVo filterButton(ButtonVo button) {
        Set targetRoleCodes = button.getRoleCodes();
        Set matchedRolesReuslts = targetRoleCodes.stream().filter(item -> StringUtils.equals((CharSequence)StringUtils.split((String)item, (String)"|")[0], (CharSequence)this.tenantCode)).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
        ButtonVo copyButton = this.cloneButton(button);
        copyButton.setRoleCodes(matchedRolesReuslts);
        return copyButton;
    }
}

