/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.query;

import com.bizunited.nebula.competence.local.service.query.AbstractCompetenceQueryStrategy;
import com.bizunited.nebula.competence.local.service.query.CompetenceQueryStrategy;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class QueryByParentNull
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private Boolean viewItem;
    private String tenantCode;
    private Integer status;

    public QueryByParentNull(Boolean viewItem, String tenantCode, Integer status) {
        this.viewItem = viewItem;
        this.tenantCode = tenantCode;
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u67e5\u8be2\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u7f16\u53f7\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        this.status = status;
    }

    @Override
    public boolean filterCompetence(CompetenceVo competence) {
        if (this.viewItem == null) {
            return false;
        }
        Integer targetViewItem = competence.getViewItem();
        if (this.viewItem != (targetViewItem == 1)) {
            return false;
        }
        return this.status == null || competence.getTstatus() != null && this.status.intValue() == competence.getTstatus().intValue();
    }

    @Override
    public CompetenceVo clone(CompetenceVo sourceCompetence) {
        return this.cloneCompetence(sourceCompetence, this.tenantCode, null, null);
    }

    @Override
    public ButtonVo filterButton(ButtonVo button) {
        if (this.viewItem == null || StringUtils.isBlank((CharSequence)this.tenantCode)) {
            return null;
        }
        Set targetRoleCodes = button.getRoleCodes();
        ButtonVo copyButton = this.cloneButton(button);
        Set<Object> matchedRolesReuslts = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)targetRoleCodes)) {
            matchedRolesReuslts = targetRoleCodes.stream().filter(item -> StringUtils.equals((CharSequence)StringUtils.split((String)item, (String)"|")[0], (CharSequence)this.tenantCode)).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
            copyButton.setRoleCodes((Set)matchedRolesReuslts);
        } else {
            copyButton.setRoleCodes(null);
        }
        return copyButton;
    }
}

