/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.query;

import com.bizunited.nebula.competence.local.service.query.AbstractCompetenceQueryStrategy;
import com.bizunited.nebula.competence.local.service.query.CompetenceQueryStrategy;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class QueryByViewItemAndRoleCodesAndCodeOrComment
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private Boolean viewItem;
    private boolean isAdmin;
    private String tenantCode;
    private String[] roleCodes;
    private Integer status;
    private String codeOrComment;
    private String[] ignoreMethodCheckRoles;

    public QueryByViewItemAndRoleCodesAndCodeOrComment(Boolean viewItem, boolean isAdmin, String tenantCode, String[] roleCodes, Integer status, String codeOrComment, String[] ignoreMethodCheckRoles) {
        this.viewItem = viewItem;
        this.isAdmin = isAdmin;
        this.tenantCode = tenantCode;
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u67e5\u8be2\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u7f16\u53f7\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        this.roleCodes = roleCodes;
        this.status = status;
        this.codeOrComment = codeOrComment;
        this.ignoreMethodCheckRoles = ignoreMethodCheckRoles;
    }

    @Override
    public boolean filterCompetence(CompetenceVo competence) {
        if (StringUtils.isNotBlank((CharSequence)this.codeOrComment)) {
            String code = competence.getCode();
            String comment = competence.getComment();
            if (StringUtils.indexOf((CharSequence)code, (CharSequence)this.codeOrComment) == -1 && StringUtils.indexOf((CharSequence)comment, (CharSequence)this.codeOrComment) == -1) {
                return false;
            }
        }
        Integer competenceStatus = competence.getTstatus();
        Integer competenceViewItem = competence.getViewItem();
        Set targetRoleCodes = competence.getRoleCodes();
        if (this.viewItem != null && this.viewItem.booleanValue() && competenceViewItem != 1) {
            return false;
        }
        if (this.status != null && (competenceStatus == null || this.status.intValue() != competenceStatus.intValue())) {
            return false;
        }
        if (this.isAdmin) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)targetRoleCodes)) {
            return false;
        }
        if (this.roleCodes != null && this.roleCodes.length > 0) {
            LinkedHashSet matchTargetRoles = Sets.newLinkedHashSet();
            for (String roleCode : this.roleCodes) {
                matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
            }
            Sets.SetView setView = Sets.intersection((Set)matchTargetRoles, (Set)Sets.newHashSet((Iterable)targetRoleCodes));
            if (CollectionUtils.isEmpty((Collection)setView)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public CompetenceVo clone(CompetenceVo sourceCompetence) {
        return this.cloneCompetence(sourceCompetence, this.tenantCode, this.isAdmin, this.ignoreMethodCheckRoles);
    }

    @Override
    public ButtonVo filterButton(ButtonVo button) {
        boolean effective = button.getEffective();
        Set targetRoleCodes = button.getRoleCodes();
        if (this.status != null && this.status == 1 && !effective) {
            return null;
        }
        if (this.isAdmin) {
            ButtonVo copyButton = this.cloneButton(button);
            copyButton.setRoleCodes((Set)Sets.newHashSet((Object[])this.ignoreMethodCheckRoles));
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)targetRoleCodes) || StringUtils.isBlank((CharSequence)this.tenantCode)) {
            return null;
        }
        Set<Object> matchedRolesReuslts = Sets.newLinkedHashSet();
        if (this.roleCodes != null && this.roleCodes.length > 0) {
            LinkedHashSet matchTargetRoles = Sets.newLinkedHashSet();
            for (String roleCode : this.roleCodes) {
                matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
            }
            Sets.SetView setView = Sets.intersection((Set)matchTargetRoles, (Set)Sets.newHashSet((Iterable)targetRoleCodes));
            if (CollectionUtils.isEmpty((Collection)setView)) {
                return null;
            }
            matchedRolesReuslts = setView.stream().map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
        } else {
            matchedRolesReuslts = targetRoleCodes.stream().filter(item -> StringUtils.equals((CharSequence)StringUtils.split((String)item, (String)"|")[0], (CharSequence)this.tenantCode)).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
        }
        ButtonVo copyButton = this.cloneButton(button);
        copyButton.setRoleCodes((Set)matchedRolesReuslts);
        return copyButton;
    }
}

