/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.notifier;

import com.bizunited.nebula.competence.local.service.CompetenceCacheService;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import com.bizunited.nebula.security.sdk.event.AuthenticationCompetenceEventListener;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class AuthenticationCompetenceEventListenerImpl
implements AuthenticationCompetenceEventListener {
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private CompetenceCacheService competenceCacheService;
    @Autowired
    private Set<CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo>> competenceRegisters;

    public Set<String> onRequestIgnoreMethodCheckRoles() {
        Object[] ignoreMethodCheckRoles = this.rbacCustomProperties.getIgnoreMethodCheckRoles();
        if (ignoreMethodCheckRoles == null || ignoreMethodCheckRoles.length == 0) {
            return null;
        }
        return Sets.newHashSet((Object[])ignoreMethodCheckRoles);
    }

    public Set<String> onRequestRoleCodes(List<RequestMappingInfo> matchedRequestMappings, String tenantCode, HttpServletRequest httpRequest) {
        HashSet resultRoleCodes = Sets.newHashSet();
        LinkedHashMap matchedItem = Maps.newLinkedHashMap();
        for (RequestMappingInfo requestMappingInfo : matchedRequestMappings) {
            Set resources = requestMappingInfo.getPatternsCondition().getPatterns();
            if (resources == null || resources.isEmpty()) continue;
            for (String resource : resources) {
                Set<CompetenceVo> cacheCompetences = this.competenceCacheService.findByResource(resource, 1);
                if (CollectionUtils.isEmpty(cacheCompetences)) continue;
                matchedItem.put(requestMappingInfo, cacheCompetences);
            }
        }
        if (matchedItem.isEmpty()) {
            return Sets.newHashSet();
        }
        LinkedHashSet currentCompetences = Sets.newLinkedHashSet();
        for (Map.Entry entryItem : matchedItem.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entryItem.getKey();
            Set competences = (Set)entryItem.getValue();
            for (CompetenceVo competenceVo : competences) {
                CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister;
                String type = competenceVo.getType();
                if (StringUtils.isBlank((CharSequence)type)) {
                    type = "default";
                }
                if (!(matchedCompetenceRegister = this.findCompetenceRegister(type)).matchedResources(competenceVo, requestMappingInfo, tenantCode, httpRequest)) continue;
                currentCompetences.add(competenceVo);
            }
        }
        if (currentCompetences.isEmpty()) {
            return Sets.newHashSet();
        }
        for (CompetenceVo competence : currentCompetences) {
            Set currentRoleCodes;
            Set tenantAndRoleCodes = competence.getRoleCodes();
            if (CollectionUtils.isEmpty((Collection)tenantAndRoleCodes) || CollectionUtils.isEmpty(currentRoleCodes = tenantAndRoleCodes.stream().filter(item -> StringUtils.equals((CharSequence)StringUtils.split((String)item, (String)"|")[0], (CharSequence)tenantCode)).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet()))) continue;
            resultRoleCodes.addAll(currentRoleCodes);
        }
        if (resultRoleCodes.isEmpty()) {
            return Sets.newHashSet();
        }
        return resultRoleCodes;
    }

    private CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> findCompetenceRegister(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.competenceRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = null;
        for (CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister : this.competenceRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)competenceRegister.getType())) continue;
            matchedCompetenceRegister = competenceRegister;
            break;
        }
        Validate.notNull(matchedCompetenceRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedCompetenceRegister;
    }
}

