/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository;

import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.repository.internal.CompetenceRepositoryCustom;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CompetenceRepository
extends CompetenceRepositoryCustom,
JpaRepository<CompetenceEntity, String>,
JpaSpecificationExecutor<CompetenceEntity> {
    @Query(value="select distinct c from CompetenceEntity c left join fetch c.buttons buttons where c.parent.id = :parentId order by c.sortIndex")
    public List<CompetenceEntity> findByParentId(@Param(value="parentId") String var1);

    @Query(value="select c from CompetenceEntity c inner join c.parent cp  where c.comment = :comment  and c.viewItem = :viewItem  and cp.id = :parentId")
    public CompetenceEntity findByCommentAndViewItemAndParent(@Param(value="comment") String var1, @Param(value="viewItem") int var2, @Param(value="parentId") String var3);

    @Query(value="select c from CompetenceEntity c where c.viewItem = :viewItem and c.parent.id is null order by c.sortIndex ")
    public List<CompetenceEntity> findByViewItemAndNullParent(@Param(value="viewItem") int var1);

    @Query(value="from CompetenceEntity c left join fetch c.parent p left join fetch c.roleMappings rmp where c.code = :code ")
    public CompetenceEntity findByCode(@Param(value="code") String var1);

    @Query(value="select count(c.id) from CompetenceEntity c where c.viewItem = :viewItem")
    public long countByViewItem(@Param(value="viewItem") int var1);

    @Query(value="select c from CompetenceEntity c where c.code in (:codes) ")
    public List<CompetenceEntity> findByCodes(@Param(value="codes") List<String> var1);

    @Query(value="select c from CompetenceEntity c where c.id in (:ids) ")
    public List<CompetenceEntity> findByIds(@Param(value="ids") List<String> var1);
}

