/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.competence.local.dto.ButtonDto;
import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.repository.internal.ButtonRepositoryCustom;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class ButtonRepositoryImpl
implements ButtonRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<ButtonEntity> findByConditions(Pageable pageable, ButtonDto button) {
        StringBuilder hql = new StringBuilder("from ButtonEntity co where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from ButtonEntity co where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (button != null) {
            if (StringUtils.isNotBlank((CharSequence)button.getName())) {
                condition.append(" AND co.name like CONCAT('%', :name,'%') ");
                parameter.put("name", button.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)button.getCode())) {
                condition.append(" AND co.code = :code ");
                parameter.put("code", button.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)button.getButtonDesc())) {
                condition.append(" AND co.buttonDesc like CONCAT('%', :buttonDesc,'%')  ");
                parameter.put("buttonDesc", button.getButtonDesc());
            }
            if (button.getEffective() != null) {
                condition.append(" AND co.effective = :effective ");
                parameter.put("effective", button.getEffective());
            }
        }
        countHql.append((CharSequence)condition);
        hql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

