/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.local.repository.ButtonRepository;
import com.bizunited.nebula.competence.local.repository.task.ButtonEntityCacheQueryTask;
import com.bizunited.nebula.competence.local.service.ButtonCacheService;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ButtonCacheServiceImpl
implements ButtonCacheService {
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private Set<CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo>> competenceRegisters;
    @Autowired
    private Redisson redisson;
    @Autowired
    @Qualifier(value="_buttonCacheQueryExecutor")
    private ThreadPoolExecutor buttonCacheQueryExecutor;
    @Autowired
    private ApplicationContext applicationContext;
    private static Map<String, Map<String, ButtonVo>> buttonsCacheMapping = Maps.newConcurrentMap();
    private static ReentrantReadWriteLock buttonloadLock = new ReentrantReadWriteLock();
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonCacheServiceImpl.class);
    private volatile Thread flashingThread = null;
    private AtomicReference<Thread> atomicReference = new AtomicReference<Object>(null);
    private static Integer MAX_STEPPING = 100;
    private static Integer MIN_STEPPING = 50;

    @Override
    public void notifyCacheClear(String appCode) {
        LOGGER.info("\u6309\u94ae\uff1a\u5df2\u901a\u77e5\u8fdb\u884cappcode\u4e3a{}\u7684\u7f13\u5b58\u66f4\u65b0", (Object)appCode);
        RTopic topic = this.redisson.getTopic("_ALL_BUTTON_NOTIFY");
        topic.publish((Object)appCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String appCode) {
        ReentrantReadWriteLock.WriteLock writeLock = buttonloadLock.writeLock();
        try {
            writeLock.lock();
            LOGGER.info("\u6309\u94ae\uff1a\u6b63\u5728\u8fdb\u884cappcode\u4e3a{}\u7684\u7f13\u5b58\u6e05\u7406", (Object)appCode);
            Map<String, ButtonVo> competencesCache = buttonsCacheMapping.get(appCode);
            if (competencesCache != null) {
                competencesCache.clear();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ButtonVo> findByCompetenceCode(String competenceCode) {
        if (StringUtils.isBlank((CharSequence)competenceCode)) {
            return null;
        }
        String appCode = TenantUtils.getTenantCode();
        ArrayList buttonVos = Lists.newArrayList();
        ReentrantReadWriteLock.ReadLock readLock = buttonloadLock.readLock();
        readLock.lock();
        try {
            if (CollectionUtils.isEmpty(buttonsCacheMapping.get(appCode))) {
                this.findDetailsFromRepository();
            }
            Collection<ButtonVo> buttons = buttonsCacheMapping.get(appCode).values();
            for (ButtonVo button : buttons) {
                Set competenceCodes = button.getCompetenceCodes();
                if (CollectionUtils.isEmpty((Collection)competenceCodes) || !competenceCodes.contains(competenceCode)) continue;
                buttonVos.add(this.copyButton(button));
            }
        }
        finally {
            readLock.unlock();
        }
        return buttonVos;
    }

    private void findDetailsFromRepository() {
        String appCode = TenantUtils.getTenantCode();
        String tenantCode = TenantUtils.getTenantCode();
        ReentrantReadWriteLock.ReadLock readLock = buttonloadLock.readLock();
        readLock.unlock();
        Thread currentThread = Thread.currentThread();
        boolean isFlashingThread = false;
        isFlashingThread = this.atomicReference.compareAndSet(null, currentThread);
        if (isFlashingThread) {
            this.flashingThread = currentThread;
        } else {
            Thread.yield();
        }
        if (!isFlashingThread) {
            while (this.flashingThread != null) {
                Thread.yield();
            }
            readLock.lock();
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = buttonloadLock.writeLock();
        writeLock.lock();
        try {
            int availableProcessors;
            LOGGER.info("\u6309\u94ae\uff1a\u6b63\u5728\u8fdb\u884cappcode\u4e3a{}\u7684\u7f13\u5b58\u52a0\u8f7d", (Object)appCode);
            Iterable allButtons = this.buttonRepository.findAll();
            if (CollectionUtils.isEmpty((Collection)allButtons)) {
                if (!CollectionUtils.isEmpty(buttonsCacheMapping.get(appCode))) {
                    buttonsCacheMapping.get(appCode).clear();
                }
                return;
            }
            int buttonCount = allButtons.size();
            int steppingCount = buttonCount / (availableProcessors = (availableProcessors = Runtime.getRuntime().availableProcessors()) <= 0 ? 1 : availableProcessors);
            steppingCount = steppingCount > MAX_STEPPING ? MAX_STEPPING : (steppingCount < MIN_STEPPING ? MIN_STEPPING : steppingCount);
            int pageCount = buttonCount / steppingCount + 1;
            ArrayList taskFutures = Lists.newArrayList();
            for (int index = 0; index < pageCount; ++index) {
                List subList = null;
                subList = index + 1 < pageCount ? allButtons.subList(steppingCount * index, steppingCount * (index + 1)) : allButtons.subList(steppingCount * index, allButtons.size());
                ButtonEntityCacheQueryTask task = (ButtonEntityCacheQueryTask)this.applicationContext.getBean(ButtonEntityCacheQueryTask.class, new Object[]{tenantCode, appCode, subList});
                Future<Map<String, ButtonVo>> future = this.buttonCacheQueryExecutor.submit(task);
                taskFutures.add(future);
            }
            ConcurrentMap buttonCacheMappingItem = Maps.newConcurrentMap();
            for (Future buttonEntityCacheQueryTask : taskFutures) {
                buttonCacheMappingItem.putAll((Map)buttonEntityCacheQueryTask.get());
            }
            buttonsCacheMapping.put(appCode, buttonCacheMappingItem);
        }
        catch (Exception e) {
            if (buttonsCacheMapping.get(appCode) != null) {
                buttonsCacheMapping.get(appCode).clear();
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            this.atomicReference.compareAndSet(currentThread, null);
            this.flashingThread = null;
            writeLock.unlock();
            readLock.lock();
        }
    }

    private ButtonVo copyButton(ButtonVo button) {
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister = this.getCompetenceRegister(button.getType());
        ButtonVo buttonVo = competenceRegister.cloneButton(button);
        return buttonVo;
    }

    private CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> getCompetenceRegister(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.competenceRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = null;
        for (CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister : this.competenceRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)competenceRegister.getType())) continue;
            matchedCompetenceRegister = competenceRegister;
            break;
        }
        Validate.notNull(matchedCompetenceRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedCompetenceRegister;
    }
}

