/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.entity.ButtonRoleMappingEntity;
import com.bizunited.nebula.competence.local.repository.ButtonRepository;
import com.bizunited.nebula.competence.sdk.config.CompetenceCustomProperties;
import com.bizunited.nebula.competence.sdk.event.ButtonEventListener;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.service.ButtonRoleMappingService;
import com.bizunited.nebula.competence.sdk.service.ButtonVoService;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ButtonVoServiceImpl
implements ButtonVoService {
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private ButtonRoleMappingService buttonRoleMappingService;
    @Autowired
    private CompetenceCustomProperties competenceCustomProperties;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired(required=false)
    @Lazy
    private List<ButtonEventListener> buttonEventListeners;
    @Autowired
    @Lazy
    private Set<CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo>> competenceRegisters;
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonVoServiceImpl.class);

    @Transactional
    public ButtonVo create(JSONObject buttonJson) {
        ButtonVo buttonVo = this.convertButtonVo(buttonJson, "\u521b\u5efa\u65f6");
        this.createHandle(buttonVo);
        return buttonVo;
    }

    @Transactional
    public ButtonVo create(ButtonVo buttonVo) {
        this.createHandle(buttonVo);
        return buttonVo;
    }

    @Transactional
    public List<ButtonVo> create(JSONArray buttons) {
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)buttons) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u591a\u6761\u6309\u94ae\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ArrayList buttonVos = Lists.newArrayList();
        for (int index = 0; index < buttons.size(); ++index) {
            JSONObject buttonJson = buttons.getJSONObject(index);
            ButtonVo buttonVo = this.convertButtonVo(buttonJson, "\u521b\u5efa\u65f6");
            buttonVos.add(this.createHandle(buttonVo));
        }
        return buttonVos;
    }

    @Transactional
    public List<ButtonVo> create(List<ButtonVo> buttons) {
        Validate.isTrue((!CollectionUtils.isEmpty(buttons) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u591a\u6309\u94ae\u80fd\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (ButtonVo button : buttons) {
            this.createHandle(button);
        }
        return buttons;
    }

    private ButtonVo createHandle(ButtonVo buttonVo) {
        Class<?> buttonVoClass = buttonVo.getClass();
        boolean isAbs = Modifier.isAbstract(buttonVoClass.getModifiers());
        Validate.isTrue((!isAbs ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f\u4e0d\u80fd\u662f\u62bd\u8c61\u7684\uff0c\u5fc5\u987b\u6709\u67d0\u4e00\u4e2a\u5177\u4f53\u7684\u6309\u94ae\u5b9e\u73b0\u6a21\u5757\u6240\u652f\u6301!!", (Object[])new Object[0]);
        Date nowDate = new Date();
        buttonVo.setCreateTime(nowDate);
        buttonVo.setCreateAccount(this.findCurrentAccount());
        buttonVo.setModifyTime(nowDate);
        buttonVo.setModifyAccount(this.findCurrentAccount());
        buttonVo.setEffective(Boolean.valueOf(true));
        buttonVo.setId(null);
        this.createValidation(buttonVo);
        ButtonEntity buttonEntity = (ButtonEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)buttonVo, ButtonEntity.class, LinkedHashSet.class, ArrayList.class, new String[]{"roleCodes"}));
        this.buttonRepository.save((Object)buttonEntity);
        this.buttonRepository.flush();
        buttonVo.setId(buttonEntity.getId());
        String tenantCode = TenantUtils.getTenantCode();
        Set roleCodes = buttonVo.getRoleCodes();
        if (!CollectionUtils.isEmpty((Collection)roleCodes)) {
            for (String roleCode : roleCodes) {
                this.buttonRoleMappingService.bindRole(roleCode, tenantCode, new String[]{buttonEntity.getId()});
            }
        }
        if (!CollectionUtils.isEmpty(this.buttonEventListeners)) {
            for (ButtonEventListener buttonEventListener : this.buttonEventListeners) {
                buttonEventListener.onCreated(buttonVo);
            }
        }
        return buttonVo;
    }

    private ButtonVo convertButtonVo(JSONObject json, String onTime) {
        Validate.notNull((Object)json, (String)(onTime + "\uff0c\u9519\u8bef\u7684json\u683c\u5f0f\u4fe1\u606f"), (Object[])new Object[0]);
        String type = json.getString("type");
        Validate.notBlank((CharSequence)type, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u6309\u94ae/\u529f\u80fd\u7c7b\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.getCompetenceRegister(type);
        Class currentButtonClass = matchedCompetenceRegister.getButtonClass();
        ButtonVo currentButtonVo = (ButtonVo)JSON.parseObject((String)json.toJSONString(), (Class)currentButtonClass);
        return currentButtonVo;
    }

    private CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> getCompetenceRegister(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.competenceRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = null;
        for (CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister : this.competenceRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)competenceRegister.getType())) continue;
            matchedCompetenceRegister = competenceRegister;
            break;
        }
        Validate.notNull(matchedCompetenceRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedCompetenceRegister;
    }

    private void createValidation(ButtonVo button) {
        Validate.notNull((Object)button, (String)"\u4fdd\u5b58\u7684\u6309\u94ae\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getName(), (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (button.getSystem() == null) {
            button.setSystem(Boolean.valueOf(false));
        }
        if (StringUtils.isBlank((CharSequence)button.getButtonDesc())) {
            button.setButtonDesc("");
        }
        Validate.isTrue((button.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6570\u636e\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        long countByCode = this.buttonRepository.countByCodeWithoutId(button.getCode(), button.getId());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u6309\u94ae\u7684\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Transactional
    public ButtonVo update(JSONObject buttonJson) {
        ButtonVo buttonVo = this.convertButtonVo(buttonJson, "\u4fee\u6539\u65f6");
        this.updateHandle(buttonVo);
        return buttonVo;
    }

    @Transactional
    public ButtonVo update(ButtonVo buttonVo) {
        this.updateHandle(buttonVo);
        return buttonVo;
    }

    private ButtonVo updateHandle(ButtonVo buttonVo) {
        Validate.notNull((Object)buttonVo, (String)"\u4fee\u6539\u65f6\uff0c\u5c06\u8981\u4fee\u6539\u7684\u6309\u94ae\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Date nowDate = new Date();
        buttonVo.setModifyTime(nowDate);
        buttonVo.setModifyAccount(this.findCurrentAccount());
        ButtonEntity updateButton = this.buttonRepository.findById(buttonVo.getId()).orElse(null);
        Validate.notNull((Object)((Object)updateButton), (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u6309\u94ae\u4fe1\u606f!!", (Object[])new Object[0]);
        this.updateValidation(buttonVo);
        updateButton.setName(buttonVo.getName());
        updateButton.setButtonDesc(buttonVo.getButtonDesc());
        updateButton.setIcon(buttonVo.getIcon());
        updateButton.setCode(buttonVo.getCode());
        updateButton.setModifyTime(buttonVo.getModifyTime());
        updateButton.setModifyAccount(buttonVo.getModifyAccount());
        updateButton.setButtonMethod(buttonVo.getButtonMethod());
        this.buttonRepository.save((Object)updateButton);
        this.buttonRepository.flush();
        if (!CollectionUtils.isEmpty(this.buttonEventListeners)) {
            for (ButtonEventListener buttonEventListener : this.buttonEventListeners) {
                buttonEventListener.onUpdate(buttonVo);
            }
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set roleCodes = buttonVo.getRoleCodes();
        if (CollectionUtils.isEmpty((Collection)roleCodes)) {
            roleCodes = Sets.newLinkedHashSet();
        }
        if (CollectionUtils.isEmpty((Collection)roleCodes) && !this.competenceCustomProperties.getReBindOnRoleUpdate().booleanValue()) {
            return buttonVo;
        }
        this.buttonRoleMappingService.rebindRole(roleCodes.toArray(new String[0]), tenantCode, updateButton.getId());
        return buttonVo;
    }

    private void updateValidation(ButtonVo button) {
        Validate.notBlank((CharSequence)button.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getName(), (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getId(), (String)"\u4fee\u6539\u6570\u636e\u5fc5\u987b\u8981\u6709ID", (Object[])new Object[0]);
        long countByCode = this.buttonRepository.countByCodeWithoutId(button.getCode(), button.getId());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u6309\u94ae\u7684\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Transactional
    public void deleteById(String id) {
        Validate.notNull((Object)id, (String)"\u5220\u9664\u5fc5\u987b\u8981\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!", (Object[])new Object[0]);
        ButtonEntity button = this.buttonRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)button), (String)"\u5220\u9664\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((button.getSystem() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u6309\u94ae\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        long count = this.buttonRoleMappingService.countByButtonCode(button.getCode());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5220\u9664\u6309\u94ae\u65f6\uff0c\u53d1\u73b0\u8be5\u6309\u94ae\u81f3\u5c11\u548c\u4e00\u4e2a\u89d2\u8272\u5df2\u7ecf\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ButtonVo currentButtonVo = this.findByCode(button.getCode());
        this.buttonRepository.unbindAllByButtonId(id);
        this.buttonRepository.flush();
        this.buttonRepository.delete((Object)button);
        if (currentButtonVo != null && !CollectionUtils.isEmpty(this.buttonEventListeners)) {
            for (ButtonEventListener buttonEventListener : this.buttonEventListeners) {
                buttonEventListener.onDeleted(currentButtonVo);
            }
        }
    }

    @Transactional
    public void deleteByCode(String code) {
        Validate.notNull((Object)code, (String)"\u5220\u9664\u5fc5\u987b\u8981\u7ed9\u5b9a\u6309\u94ae\u7f16\u7801\u4fe1\u606f!", (Object[])new Object[0]);
        ButtonEntity button = this.buttonRepository.findByCode(code);
        Validate.notNull((Object)((Object)button), (String)"\u5220\u9664\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((button.getSystem() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u6309\u94ae\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        this.deleteById(button.getId());
    }

    @Transactional
    public void batchDelete(String[] ids) {
        Validate.isTrue((ids != null && ids.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6309\u94ae\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u5220\u9664\u7684\u6309\u94ae\u6280\u672f\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String id : ids) {
            this.deleteById(id);
        }
    }

    private String findCurrentAccount() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String account = "admin";
        if (authentication != null) {
            account = authentication.getName();
        }
        return account;
    }

    public ButtonVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ButtonEntity buttonEntity = this.buttonRepository.findByCode(code);
        if (buttonEntity == null) {
            return null;
        }
        List<ButtonVo> buttonVos = this.convertPracticalButtonVos(Lists.newArrayList((Object[])new ButtonEntity[]{buttonEntity}));
        if (CollectionUtils.isEmpty(buttonVos)) {
            return null;
        }
        return buttonVos.get(0);
    }

    private List<ButtonVo> convertPracticalButtonVos(List<ButtonEntity> currentButtons) {
        Map<String, List<ButtonEntity>> buttonsGroupForType = currentButtons.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.groupingBy(ButtonEntity::getType));
        Map<String, ButtonEntity> buttonEntitesMappingForCode = currentButtons.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(ButtonEntity::getCode, item -> item));
        ArrayList buttonVos = Lists.newArrayList();
        for (Map.Entry<String, List<ButtonEntity>> buttonsGroupItems : buttonsGroupForType.entrySet()) {
            List<ButtonEntity> groupButtons = buttonsGroupItems.getValue();
            if (CollectionUtils.isEmpty(groupButtons)) continue;
            String type = buttonsGroupItems.getKey();
            CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.getCompetenceRegister(type);
            Set practicalButtonVos = matchedCompetenceRegister.onRequestButtonVos(groupButtons.stream().map(ButtonEntity::getCode).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty((Collection)practicalButtonVos)) {
                for (ButtonVo buttonVo : practicalButtonVos) {
                    ButtonEntity buttonBaseEntity = buttonEntitesMappingForCode.get(buttonVo.getCode());
                    Validate.notNull((Object)((Object)buttonBaseEntity), (String)"\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u8fd4\u56de\u4e86\u9519\u8bef\u7684ButtonVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonVo.getCode()});
                    this.perfectInformation(buttonVo, buttonBaseEntity);
                    buttonVos.add(buttonVo);
                }
                continue;
            }
            for (ButtonEntity buttonBaseEntity : groupButtons) {
                ButtonVo buttonVo = null;
                try {
                    buttonVo = (ButtonVo)matchedCompetenceRegister.getButtonClass().newInstance();
                    this.perfectInformation(buttonVo, buttonBaseEntity);
                    buttonVos.add(buttonVo);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u5728\u5177\u4f53\u7684competenceRegister\u4e2d\uff0c\u6ca1\u6709\u8fd4\u56de\u6b63\u786e\u7684\u7684ButtonVo\u5177\u4f53\u5b9e\u73b0\u4fe1\u606f\u65f6\uff0c\u8bd5\u56fe\u76f4\u63a5\u521d\u59cb\u5316\u5177\u4f53\u7684ButtonVo\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!");
                }
            }
        }
        Map<String, ButtonVo> buttonVosMappingForCode = buttonVos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getType())).collect(Collectors.toMap(ButtonVo::getCode, item -> item, (k1, k2) -> k1));
        ArrayList sortedButtons = Lists.newArrayList();
        for (ButtonEntity currentButton : currentButtons) {
            sortedButtons.add(buttonVosMappingForCode.get(currentButton.getCode()));
        }
        return sortedButtons;
    }

    private void perfectInformation(ButtonVo buttonVo, ButtonEntity buttonBaseEntity) {
        buttonVo.setButtonDesc(buttonBaseEntity.getButtonDesc());
        buttonVo.setCreateTime(buttonBaseEntity.getCreateTime());
        buttonVo.setCreateAccount(buttonBaseEntity.getCreateAccount());
        buttonVo.setEffective(buttonBaseEntity.getEffective());
        buttonVo.setIcon(buttonBaseEntity.getIcon());
        buttonVo.setId(buttonBaseEntity.getId());
        buttonVo.setModifyAccount(buttonBaseEntity.getModifyAccount());
        buttonVo.setModifyTime(buttonBaseEntity.getModifyTime());
        buttonVo.setName(buttonBaseEntity.getName());
        buttonVo.setSystem(buttonBaseEntity.getSystem());
        buttonVo.setType(buttonBaseEntity.getType());
        buttonVo.setExtend1(buttonBaseEntity.getExtend1());
        buttonVo.setExtend2(buttonBaseEntity.getExtend2());
        buttonVo.setExtend3(buttonBaseEntity.getExtend3());
        buttonVo.setExtend4(buttonBaseEntity.getExtend4());
        buttonVo.setExtend5(buttonBaseEntity.getExtend5());
        buttonVo.setExtend6(buttonBaseEntity.getExtend6());
        buttonVo.setExtend7(buttonBaseEntity.getExtend7());
        buttonVo.setExtend8(buttonBaseEntity.getExtend8());
        buttonVo.setExtend9(buttonBaseEntity.getExtend9());
        buttonVo.setExtend10(buttonBaseEntity.getExtend10());
        buttonVo.setExtend11(buttonBaseEntity.getExtend11());
        buttonVo.setButtonMethod(buttonBaseEntity.getButtonMethod());
    }

    public List<ButtonVo> findByCompetenceCode(String competenceCode) {
        if (StringUtils.isBlank((CharSequence)competenceCode)) {
            return null;
        }
        List<ButtonEntity> buttonEntities = this.buttonRepository.findByCompetenceCode(competenceCode);
        if (CollectionUtils.isEmpty(buttonEntities)) {
            return null;
        }
        return this.convertPracticalButtonVos(buttonEntities);
    }

    public List<ButtonVo> findByRoleCodesAndCompetenceCodes(String[] roleCodes, String[] competenceCodes) {
        if (roleCodes == null || roleCodes.length == 0 || competenceCodes == null || competenceCodes.length == 0) {
            return null;
        }
        HashSet roleCodsSets = Sets.newHashSet((Object[])roleCodes);
        boolean isAdmin = this.comfirmAdmin(roleCodes);
        ArrayList allButtonEntities = this.buttonRepository.findByCompetenceCodes(Sets.newHashSet((Object[])competenceCodes));
        ArrayList resultsButtonEntities = null;
        if (isAdmin) {
            resultsButtonEntities = allButtonEntities;
        } else {
            resultsButtonEntities = Lists.newArrayList();
            for (ButtonEntity buttonEntity : allButtonEntities) {
                Set buttonRoleCodes;
                Set<ButtonRoleMappingEntity> buttonRoleMappings = buttonEntity.getRoleMappings();
                if (CollectionUtils.isEmpty(buttonRoleMappings) || Sets.intersection(buttonRoleCodes = buttonRoleMappings.stream().map(ButtonRoleMappingEntity::getRoleCode).collect(Collectors.toSet()), (Set)roleCodsSets).isEmpty()) continue;
                resultsButtonEntities.add(buttonEntity);
            }
        }
        if (CollectionUtils.isEmpty((Collection)resultsButtonEntities)) {
            return null;
        }
        List<ButtonVo> buttonVos = this.convertPracticalButtonVos(resultsButtonEntities);
        return buttonVos;
    }

    private boolean comfirmAdmin(String[] roleCodes) {
        boolean isAdmin = false;
        if (roleCodes != null && roleCodes.length > 0) {
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.rbacCustomProperties.getIgnoreMethodCheckRoles()), (Set)Sets.newHashSet((Object[])roleCodes));
            isAdmin = !CollectionUtils.isEmpty((Collection)intersections);
        }
        return isAdmin;
    }
}

