/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.internal;

import com.bizunited.nebula.competence.local.entity.ButtonEntity;
import com.bizunited.nebula.competence.local.entity.CompetenceEntity;
import com.bizunited.nebula.competence.local.repository.ButtonRepository;
import com.bizunited.nebula.competence.local.repository.CompetenceRepository;
import com.bizunited.nebula.competence.sdk.service.CompetenceButtonMappingService;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompetenceButtonMappingServiceImpl
implements CompetenceButtonMappingService {
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private CompetenceRepository competenceRepository;

    @Transactional
    public void bindButton(String buttonCode, String[] competenceCodes) {
        Validate.notBlank((CharSequence)buttonCode, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        ButtonEntity op = this.buttonRepository.findByCode(buttonCode);
        Validate.notNull((Object)((Object)op), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])competenceCodes, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceCode : competenceCodes) {
            CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
            Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
            long count = this.buttonRepository.countByCompetenceIdAndButtonId(op.getId(), opCompetence.getId());
            if (count != 0L) continue;
            this.buttonRepository.bindCompetence(op.getId(), opCompetence.getId());
        }
    }

    @Transactional
    public void bindButton(String[] buttonCodes, String competenceCode) {
        CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
        Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
        Validate.notEmpty((Object[])buttonCodes, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94ae\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String buttonCode : buttonCodes) {
            ButtonEntity op = this.buttonRepository.findByCode(buttonCode);
            Validate.notNull((Object)((Object)op), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s] , \u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonCode});
            long count = this.buttonRepository.countByCompetenceIdAndButtonId(op.getId(), opCompetence.getId());
            if (count != 0L) continue;
            this.buttonRepository.bindCompetence(op.getId(), opCompetence.getId());
        }
    }

    @Transactional
    public void unbindButton(String buttonCode, String[] competenceCodes) {
        Validate.notBlank((CharSequence)buttonCode, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        ButtonEntity op = this.buttonRepository.findByCode(buttonCode);
        Validate.notNull((Object)((Object)op), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])competenceCodes, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceCode : competenceCodes) {
            CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
            Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
            this.buttonRepository.unbindCompetence(op.getId(), opCompetence.getId());
        }
    }

    @Transactional
    public void reBindButton(String buttonCode, String[] competenceCodes) {
        Validate.notBlank((CharSequence)buttonCode, (String)"\u6309\u94ae\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ButtonEntity button = this.buttonRepository.findByCode(buttonCode);
        Validate.notNull((Object)((Object)button), (String)"\u6309\u94ae\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        this.buttonRepository.unbindAllByButtonId(button.getId());
        if (competenceCodes != null && competenceCodes.length > 0) {
            for (String competenceCode : competenceCodes) {
                CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
                Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
                this.buttonRepository.bindCompetence(button.getId(), opCompetence.getId());
            }
        }
    }

    public void reBindButton(String[] buttonCodes, String competenceCode) {
        Validate.notBlank((CharSequence)competenceCode, (String)"\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CompetenceEntity opCompetence = this.competenceRepository.findByCode(competenceCode);
        Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceCode});
        this.buttonRepository.unbindAllByCompetenceId(opCompetence.getId());
        if (buttonCodes != null && buttonCodes.length > 0) {
            for (String buttonCode : buttonCodes) {
                ButtonEntity button = this.buttonRepository.findByCode(buttonCode);
                Validate.notNull((Object)((Object)button), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonCode});
                this.buttonRepository.bindCompetence(button.getId(), opCompetence.getId());
            }
        }
    }
}

