/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.query;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCompetenceQueryStrategy {
    protected NebulaToolkitService nebulaToolkitService = new NebulaToolkitService();
    @Autowired
    private Set<CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo>> competenceRegisters;

    private CompetenceVo cloneCompetence(CompetenceVo sourceCompetence) {
        String type = sourceCompetence.getType();
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.findCompetenceRegister(type);
        return matchedCompetenceRegister.cloneCompetence(sourceCompetence);
    }

    protected CompetenceVo cloneCompetence(CompetenceVo sourceCompetence, String tenantCode, Boolean isAdmin, String[] ignoreMethodCheckRoles) {
        Set targetRoleCodes = sourceCompetence.getRoleCodes();
        CompetenceVo copyCompetence = null;
        Set<Object> matchedRolesReuslts = Sets.newHashSet();
        copyCompetence = this.cloneCompetence(sourceCompetence);
        if (isAdmin != null && isAdmin.booleanValue()) {
            copyCompetence.setRoleCodes((Set)Sets.newHashSet((Object[])ignoreMethodCheckRoles));
        } else if (!CollectionUtils.isEmpty((Collection)targetRoleCodes)) {
            matchedRolesReuslts = targetRoleCodes.stream().filter(item -> StringUtils.equals((CharSequence)StringUtils.split((String)item, (String)"|")[0], (CharSequence)tenantCode)).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
            copyCompetence.setRoleCodes((Set)matchedRolesReuslts);
        }
        return copyCompetence;
    }

    protected ButtonVo cloneButton(ButtonVo sourceButton) {
        String type = sourceButton.getType();
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = this.findCompetenceRegister(type);
        return matchedCompetenceRegister.cloneButton(sourceButton);
    }

    protected CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> findCompetenceRegister(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        Validate.isTrue((!CollectionUtils.isEmpty(this.competenceRegisters) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> matchedCompetenceRegister = null;
        for (CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister : this.competenceRegisters) {
            if (!StringUtils.equals((CharSequence)type, (CharSequence)competenceRegister.getType())) continue;
            matchedCompetenceRegister = competenceRegister;
            break;
        }
        Validate.notNull(matchedCompetenceRegister, (String)"\u672a\u5339\u914d\u4efb\u4f55CompetenceRegister\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return matchedCompetenceRegister;
    }
}

