/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.competence.local.service.query;

import com.bizunited.nebula.competence.local.service.query.AbstractCompetenceQueryStrategy;
import com.bizunited.nebula.competence.local.service.query.CompetenceQueryStrategy;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class QueryByResourcesAndMethodAndRoleCodes
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private String[] resources;
    private boolean like;
    private String method;
    private Integer status;
    private String tenantCode;
    private String[] roleCodes;
    private String type;
    private boolean isAdmin;
    private String[] ignoreMethodCheckRoles;

    public QueryByResourcesAndMethodAndRoleCodes(String[] resources, boolean like, String method, Integer status, String tenantCode, String[] roleCodes, String type, boolean isAdmin, String[] ignoreMethodCheckRoles) {
        this.resources = resources;
        if (resources == null || resources.length == 0) {
            throw new IllegalArgumentException("\u8fdb\u884c\u83dc\u5355/\u529f\u80fd\u5339\u914d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u57fa\u4e8e\u6bd4\u8f83\u7684\u529f\u80fd\u4fe1\u606f");
        }
        this.like = like;
        this.method = method;
        this.status = status;
        this.tenantCode = tenantCode;
        Validate.notBlank((CharSequence)tenantCode, (String)"\u8fdb\u884c\u67e5\u8be2\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u7f16\u53f7\u5fc5\u987b\u6307\u5b9a", (Object[])new Object[0]);
        this.roleCodes = roleCodes;
        this.isAdmin = isAdmin;
        this.ignoreMethodCheckRoles = ignoreMethodCheckRoles;
        this.type = type;
    }

    @Override
    public boolean filterCompetence(CompetenceVo competence) {
        Integer targetStatus = competence.getTstatus();
        Set targetRoleCodes = competence.getRoleCodes();
        if (this.status != null && (targetStatus == null || this.status.intValue() != targetStatus.intValue())) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)this.type) && !StringUtils.equals((CharSequence)this.type, (CharSequence)competence.getType())) {
            return false;
        }
        boolean canContinue = false;
        CompetenceRegister<? extends CompetenceVo, ? extends ButtonVo> competenceRegister = this.findCompetenceRegister(competence.getType());
        for (String resource : this.resources) {
            if (!competenceRegister.matchedResources(competence, resource, this.method, this.like, this.tenantCode)) continue;
            canContinue = true;
            break;
        }
        if (!canContinue) {
            return false;
        }
        if (this.isAdmin) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)targetRoleCodes)) {
            return false;
        }
        if (this.roleCodes != null && this.roleCodes.length > 0) {
            LinkedHashSet matchTargetRoles = Sets.newLinkedHashSet();
            for (String roleCode : this.roleCodes) {
                matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
            }
            Sets.SetView setView = Sets.intersection((Set)matchTargetRoles, (Set)Sets.newHashSet((Iterable)targetRoleCodes));
            if (CollectionUtils.isEmpty((Collection)setView)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public CompetenceVo clone(CompetenceVo sourceCompetence) {
        return this.cloneCompetence(sourceCompetence, this.tenantCode, this.isAdmin, this.ignoreMethodCheckRoles);
    }

    @Override
    public ButtonVo filterButton(ButtonVo button) {
        boolean effective = button.getEffective();
        Set targetRoleCodes = button.getRoleCodes();
        if (this.status != null && this.status != (effective ? 1 : 0)) {
            return null;
        }
        if (this.isAdmin) {
            ButtonVo copyButton = this.cloneButton(button);
            copyButton.setRoleCodes((Set)Sets.newHashSet((Object[])this.ignoreMethodCheckRoles));
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)targetRoleCodes) || StringUtils.isBlank((CharSequence)this.tenantCode)) {
            return null;
        }
        Set<Object> matchedRolesReuslts = Sets.newLinkedHashSet();
        if (this.roleCodes != null && this.roleCodes.length > 0) {
            LinkedHashSet matchTargetRoles = Sets.newLinkedHashSet();
            for (String roleCode : this.roleCodes) {
                matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
            }
            Sets.SetView setView = Sets.intersection((Set)matchTargetRoles, (Set)Sets.newHashSet((Iterable)targetRoleCodes));
            if (CollectionUtils.isEmpty((Collection)setView)) {
                return null;
            }
            matchedRolesReuslts = setView.stream().map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
        } else {
            matchedRolesReuslts = targetRoleCodes.stream().filter(item -> StringUtils.equals((CharSequence)StringUtils.split((String)item, (String)"|")[0], (CharSequence)this.tenantCode)).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
        }
        ButtonVo copyButton = this.cloneButton(button);
        copyButton.setRoleCodes((Set)matchedRolesReuslts);
        return copyButton;
    }
}

