/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.enclosure.local.service;

import com.bizunited.nebula.europa.database.sdk.strategy.AbstractDatabaseExecutionStrategy;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.service.strategy.PreExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.AbstractView;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="DatabaseEnclosureExecutionStrategy")
public class DatabaseEnclosureExecutionStrategy
extends AbstractDatabaseExecutionStrategy
implements ExecutionStrategy {
    @Autowired
    @Qualifier(value="databasePreEnclosureExecutionStrategy")
    private PreExecutionStrategy databasePreExecutionStrategy;

    public boolean validate(EuropaInfoVo europaInfoVo) {
        AbstractView abstractView = europaInfoVo.getView();
        if (abstractView == null || !(abstractView instanceof DatabaseViewVo)) {
            return false;
        }
        DatabaseViewVo databaseViewVo = (DatabaseViewVo)abstractView;
        return StringUtils.equals((CharSequence)databaseViewVo.getSouceType(), (CharSequence)"enclosure_database");
    }

    public MetaData buildQueryMetaData(EuropaInfoVo europaInfoVo, RequestParameter requestParameter) {
        DatabaseViewVo databaseView = (DatabaseViewVo)europaInfoVo.getView();
        Validate.notNull((Object)databaseView, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u89c6\u56fe\u3010\u6570\u636e\u5e93\u6267\u884c\u3011\u6269\u5c55\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String sql = databaseView.getSourceSql();
        String dataSourceCode = databaseView.getDatasouceCode();
        if (StringUtils.isBlank((CharSequence)dataSourceCode)) {
            dataSourceCode = "default";
        }
        String contentJson = "{\"sql\":\"" + sql + "\" , \"dataSourceCode\":\"" + dataSourceCode + "\"}";
        MetaData queryMetaData = this.databasePreExecutionStrategy.preExecution("enclosure_database", contentJson);
        Validate.notNull((Object)queryMetaData, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u5143\u6570\u636e\u7ed3\u6784\u672a\u6784\u5efa\u6210\u529f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return queryMetaData;
    }

    public String sourceSql(EuropaInfoVo europaInfoVo) {
        DatabaseViewVo databaseView = (DatabaseViewVo)europaInfoVo.getView();
        return databaseView.getSourceSql();
    }
}

