/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.enclosure.local.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.europa.database.enclosure.local.model.EnclosurePreExecutionInfo;
import com.bizunited.nebula.europa.database.sdk.strategy.AbstractDatabasePreExecutionStrategy;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.service.strategy.PreExecutionStrategy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="databasePreEnclosureExecutionStrategy")
public class DatabasePreEnclosureExecutionStrategy
extends AbstractDatabasePreExecutionStrategy
implements PreExecutionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabasePreEnclosureExecutionStrategy.class);

    public boolean validate(String sourceType, String content) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)sourceType, (CharSequence[])new CharSequence[]{"enclosure_database"});
    }

    public MetaData preExecution(String sourceType, String content) {
        Validate.notBlank((CharSequence)content, (String)"\u9884\u6267\u884c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u9700\u8981\u89e3\u6790\u7684\u67e5\u8be2\u5185\u5bb9", (Object[])new Object[0]);
        EnclosurePreExecutionInfo preExecutionInfo = null;
        try {
            JSONObject jsonObject = JSON.parseObject((String)content);
            preExecutionInfo = (EnclosurePreExecutionInfo)JSONObject.toJavaObject((JSON)jsonObject, EnclosurePreExecutionInfo.class);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u9519\u8bef\u7684JSON\u7ed3\u6784\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u4fe1\u606f");
        }
        String dataSourceCode = preExecutionInfo.getDataSourceCode();
        String sql = preExecutionInfo.getSql();
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u9884\u6267\u884c\u65f6\uff0c\u9700\u8981\u4f20\u5165\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)sql, (String)"\u9884\u6267\u884c\u65f6\uff0c\u9700\u8981\u4f20\u5165\u5bf9\u5e94\u7684\u9884\u6267\u884cSQL\u8bed\u53e5\uff08\u8bf7\u6ce8\u610f\u8bed\u6cd5\uff09", (Object[])new Object[0]);
        return super.doPreExecution(dataSourceCode, sql);
    }
}

