/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.resolver;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaData;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaDataField;
import com.bizunited.nebula.europa.database.sdk.service.MetaDataResolver;
import com.bizunited.nebula.europa.database.sdk.utils.SQLAnalyzeUtils;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaDataField;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="PostgreSQLDruidResolver")
public class PostgreSQLDruidResolver
implements MetaDataResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLDruidResolver.class);
    private static final String[] DRIVER_CLASS_NAMES = new String[]{"org.postgresql.Driver"};
    private static final String REBUILD_FIELD_ALIS_SEPARATOR = "__s__";

    public boolean validate(DataSource dataSource) {
        if (!(dataSource instanceof DruidDataSource)) {
            return false;
        }
        String driverClassName = ((DruidDataSource)dataSource).getDriverClassName();
        return StringUtils.equalsAny((CharSequence)driverClassName, (CharSequence[])DRIVER_CLASS_NAMES);
    }

    public MetaData resolver(Connection currentConnection, String sql) throws SQLException {
        LOGGER.info("\u6267\u884cPSQL-------------");
        SqlFromTableInfo factFieldCollectTableInfo = this.buildFactFieldTableInfo(currentConnection, sql);
        String rebuildSql = this.rebuildSql(currentConnection, sql, factFieldCollectTableInfo);
        String callableSql = SQLAnalyzeUtils.convertToParameterSQL((String)rebuildSql);
        Map sqlParametersIndexMapping = SQLAnalyzeUtils.analyzeSQLParametersMapping((String)rebuildSql);
        PreparedStatement ps = currentConnection.prepareStatement(callableSql);
        this.bindDummyParams(ps, rebuildSql, factFieldCollectTableInfo);
        ResultSetMetaData resultSetMetaData = ps.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        DatabaseMetaData databaseMetaData = new DatabaseMetaData("database");
        Map<String, SqlFromTableFieldInfo> allFieldNameMap = factFieldCollectTableInfo.getAllFieldNameMap();
        for (int index = 1; index <= columnCount; ++index) {
            String fieldName;
            String alias;
            String fieldOriginalName;
            String fieldCnName;
            String columnLabel = resultSetMetaData.getColumnLabel(index);
            String[] fieldSplit = columnLabel.split(REBUILD_FIELD_ALIS_SEPARATOR);
            if (fieldSplit.length == 3) {
                fieldCnName = fieldSplit[2];
                fieldOriginalName = fieldSplit[1];
                alias = fieldSplit[0];
                fieldName = fieldCnName;
            } else {
                fieldCnName = columnLabel;
                fieldName = resultSetMetaData.getColumnName(index);
                Validate.notBlank((CharSequence)fieldName, (String)"\u672a\u83b7\u53d6\u5230\u5143\u6570\u636e\u5217\u4e2d\u7684\u5b57\u6bb5\u540d\u79f0\u4fe1\u606f", (Object[])new Object[0]);
                alias = resultSetMetaData.getTableName(index);
                if (StringUtils.isBlank((CharSequence)alias)) {
                    alias = "";
                }
                fieldOriginalName = fieldName;
            }
            String tableName = resultSetMetaData.getTableName(index);
            String className = resultSetMetaData.getColumnClassName(index);
            SqlFromTableFieldInfo tableFieldInfo = allFieldNameMap.get(String.format("%s_alis_%s", alias, fieldOriginalName));
            String fieldComment = Objects.nonNull(tableFieldInfo) ? tableFieldInfo.fieldComment : null;
            Validate.notBlank((CharSequence)className, (String)"\u672a\u83b7\u53d6\u5230\u5143\u6570\u636e\u5217\u4e2d\u7684\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f", (Object[])new Object[0]);
            try {
                Class<?> currentClass = Class.forName(className);
                Validate.isTrue((!currentClass.isArray() ? 1 : 0) != 0, (String)"\u5143\u6570\u636e\u4e2d\u7684\u5b57\u6bb5\u4e0d\u53ef\u80fd\u4e3a\u6570\u7ec4", (Object[])new Object[0]);
                Validate.isTrue((!Iterable.class.isAssignableFrom(currentClass) ? 1 : 0) != 0, (String)"\u5143\u6570\u636e\u4e2d\u7684\u5b57\u6bb5\u4e0d\u53ef\u80fd\u4e3a\u96c6\u5408", (Object[])new Object[0]);
                Validate.isTrue((!Map.class.isAssignableFrom(currentClass) ? 1 : 0) != 0, (String)"\u5143\u6570\u636e\u4e2d\u7684\u5b57\u6bb5\u4e0d\u53ef\u80fd\u4e3a\u6620\u5c04K-V\u7ed3\u6784", (Object[])new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            DatabaseMetaDataField databaseMetaDataField = new DatabaseMetaDataField();
            databaseMetaDataField.setAlias(alias);
            databaseMetaDataField.setTableName(tableName);
            databaseMetaDataField.setFieldName(fieldName);
            databaseMetaDataField.setFieldOriginalName(fieldOriginalName);
            databaseMetaDataField.setFieldCnName(fieldCnName);
            databaseMetaDataField.setJavaClassName(className);
            databaseMetaDataField.setFieldComment(fieldComment);
            databaseMetaData.addMetaDataField((MetaDataField)databaseMetaDataField);
        }
        ParameterMetaData parameterMetaData = ps.getParameterMetaData();
        int parameterCount = parameterMetaData.getParameterCount();
        HashMap<String, String> addedParameters = new HashMap<String, String>();
        for (int idx = 1; idx <= parameterCount; ++idx) {
            String parameterClassName = parameterMetaData.getParameterClassName(idx);
            String parameterName = (String)sqlParametersIndexMapping.get(idx);
            String addedClassName = (String)addedParameters.get(parameterName);
            if (addedClassName == null) {
                databaseMetaData.addParameter(idx, parameterName, parameterClassName);
            } else {
                Validate.isTrue((boolean)StringUtils.equals((CharSequence)addedClassName, (CharSequence)parameterClassName), (String)"\u53c2\u6570 %s \u91cd\u590d\u51fa\u73b0\u4e14\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{parameterName});
            }
            addedParameters.put(parameterName, parameterClassName);
        }
        List primaryKeyFields = factFieldCollectTableInfo.allFieldList.stream().collect(Collectors.toMap(fi -> String.format("%s-%s", ((SqlFromTableFieldInfo)fi).tableAlis, ((SqlFromTableFieldInfo)fi).fieldName), t -> t, (a, b) -> a)).values().stream().filter(fi -> Boolean.TRUE.equals(((SqlFromTableFieldInfo)fi).primaryKey)).map(fi -> {
            DatabaseMetaDataField f = new DatabaseMetaDataField();
            f.setAlias(((SqlFromTableFieldInfo)fi).tableAlis);
            f.setTableName(((SqlFromTableFieldInfo)fi).tableAlis);
            f.setFieldName(((SqlFromTableFieldInfo)fi).fieldName);
            f.setFieldOriginalName(((SqlFromTableFieldInfo)fi).fieldName);
            f.setFieldCnName(((SqlFromTableFieldInfo)fi).fieldName);
            return f;
        }).collect(Collectors.toList());
        databaseMetaData.setPrimaryKeyFields(primaryKeyFields);
        return databaseMetaData;
    }

    private String rebuildSql(Connection connection, String sql, SqlFromTableInfo factFieldCollectTableInfo) {
        String rebuildSql = sql;
        try {
            List list = SQLUtils.parseStatements((String)sql, (String)DatabaseType.POSTGRESQL.getDesc());
            if (list.size() != 1) {
                throw new SQLSyntaxErrorException("MultiQueries is not supported,use single query instead ");
            }
            SQLSelectStatement selectStmt = (SQLSelectStatement)list.get(0);
            SQLSelectQueryBlock qb = (SQLSelectQueryBlock)selectStmt.getSelect().getQuery();
            HashSet<SqlFromTableInfo> tableSet = new HashSet<SqlFromTableInfo>();
            this.analysisTable(qb.getFrom(), tableSet);
            Map<String, SqlFromTableInfo> alias2Info = tableSet.stream().collect(Collectors.toMap(t -> ((SqlFromTableInfo)t).tableAlis, t -> t));
            ArrayList<SQLSelectItem> newSelect = new ArrayList<SQLSelectItem>();
            for (SQLSelectItem item : qb.getSelectList()) {
                SQLPropertyExpr pe;
                List<String> fieldNames;
                SQLExpr expr = item.getExpr();
                if (expr instanceof SQLPropertyExpr) {
                    SQLPropertyExpr p = (SQLPropertyExpr)expr;
                    SqlFromTableInfo tinfo = alias2Info.get(p.getOwnernName());
                    Validate.notNull((Object)tinfo, (String)"\u8868\u522b\u540d%s\u5bf9\u5e94\u6570\u636e\u8868\u4e0d\u5b58\u5728", (Object[])new Object[]{p.getOwnernName()});
                    if ("*".equals(p.getName())) {
                        fieldNames = this.getFieldNames(connection, tinfo, factFieldCollectTableInfo);
                        for (String fn : fieldNames) {
                            pe = new SQLPropertyExpr(p.getOwnernName(), fn);
                            newSelect.add(new SQLSelectItem((SQLExpr)pe, String.join((CharSequence)REBUILD_FIELD_ALIS_SEPARATOR, pe.getOwnernName(), fn, fn)));
                        }
                        continue;
                    }
                    String alias = String.join((CharSequence)REBUILD_FIELD_ALIS_SEPARATOR, p.getOwnernName(), p.getName(), (CharSequence)ObjectUtils.defaultIfNull((Object)item.getAlias(), (Object)p.getName()));
                    newSelect.add(new SQLSelectItem(expr, alias));
                    continue;
                }
                if (expr instanceof SQLAllColumnExpr) {
                    for (Map.Entry<String, SqlFromTableInfo> e : alias2Info.entrySet()) {
                        fieldNames = this.getFieldNames(connection, e.getValue(), factFieldCollectTableInfo);
                        for (String fn : fieldNames) {
                            pe = new SQLPropertyExpr(e.getKey(), fn);
                            newSelect.add(new SQLSelectItem((SQLExpr)pe, String.join((CharSequence)REBUILD_FIELD_ALIS_SEPARATOR, pe.getOwnernName(), fn, fn)));
                        }
                    }
                    continue;
                }
                newSelect.add(item);
            }
            qb.getSelectList().clear();
            qb.getSelectList().addAll(newSelect);
            Map<String, String> tableName2Alias = tableSet.stream().collect(Collectors.toMap(t -> ((SqlFromTableInfo)t).tableName.toLowerCase(Locale.ROOT), t -> ((SqlFromTableInfo)t).tableAlis, (a, b) -> a));
            this.rewriteQueryOwnersToAlias(qb, tableName2Alias);
            rebuildSql = selectStmt.toString();
        }
        catch (Exception e) {
            LOGGER.error("\u91c7\u7528druid\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790\u91cd\u6784sql\u51fa\u9519,\u5c06\u91c7\u7528\u539f\u59cbsql\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790", (Throwable)e);
        }
        return rebuildSql;
    }

    private List<String> getFieldNames(Connection connection, SqlFromTableInfo tableInfo, SqlFromTableInfo factFieldCollectTableInfo) {
        List<String> fieldNames;
        if (Boolean.TRUE.equals(tableInfo.subQueryFlag)) {
            fieldNames = Collections.emptyList();
        } else {
            List tableFieldInfoList = factFieldCollectTableInfo.getTableFieldNameMap().get(tableInfo.tableAlis);
            tableFieldInfoList = (List)ObjectUtils.defaultIfNull(tableFieldInfoList, new ArrayList());
            fieldNames = tableFieldInfoList.stream().map(f -> ((SqlFromTableFieldInfo)f).fieldName).collect(Collectors.toList());
        }
        return fieldNames;
    }

    private List<SqlFromTableFieldInfo> findFieldByTableName(Connection connection, String tableName, String tableAlis) {
        ArrayList<SqlFromTableFieldInfo> fieldList = new ArrayList<SqlFromTableFieldInfo>();
        try {
            String columnSql = "SELECT column_name, data_type, udt_name, ordinal_position, col_description(format('%s.%s', table_schema, table_name)::regclass::oid, ordinal_position) AS comment FROM information_schema.columns WHERE table_name = ? AND table_schema = current_schema()";
            try (PreparedStatement ps = connection.prepareStatement(columnSql);){
                ps.setString(1, tableName);
                Set<String> primaryKeys = this.getPrimaryKeys(connection, tableName);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String fieldName = rs.getString("column_name");
                        String dataType = rs.getString("data_type");
                        String udtName = rs.getString("udt_name");
                        String comment = rs.getString("comment");
                        boolean isPrimary = primaryKeys.contains(fieldName);
                        Integer jdbcType = PostgreSQLDruidResolver.toJdbcType(dataType, udtName);
                        fieldList.add(new SqlFromTableFieldInfo(tableAlis, fieldName, comment, isPrimary, dataType, udtName, jdbcType));
                    }
                }
            }
        }
        catch (SQLException e) {
            LOGGER.warn("PostgreSQL: \u67e5\u8be2\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0c\u8868\uff1a{}", (Object)tableName, (Object)e);
        }
        return fieldList;
    }

    private Set<String> getPrimaryKeys(Connection connection, String tableName) throws SQLException {
        HashSet<String> primaryKeys = new HashSet<String>();
        String pkSql = "SELECT kcu.column_name FROM information_schema.table_constraints tc JOIN information_schema.key_column_usage kcu   ON tc.constraint_name = kcu.constraint_name AND tc.table_schema = kcu.table_schema WHERE tc.table_name = ? AND tc.table_schema = current_schema() AND tc.constraint_type = 'PRIMARY KEY'";
        try (PreparedStatement ps = connection.prepareStatement(pkSql);){
            ps.setString(1, tableName);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    primaryKeys.add(rs.getString("column_name"));
                }
            }
        }
        return primaryKeys;
    }

    private List<Field> findFieldBySql(Connection connection, String sql) {
        return Collections.emptyList();
    }

    public SqlFromTableInfo analysisFactFieldInfo(Connection connection, String sql, String alis) {
        List list = SQLUtils.parseStatements((String)sql, (String)DatabaseType.POSTGRESQL.getDesc());
        if (list.size() > 1) {
            throw new RuntimeException("MultiQueries is not supported,use single query instead");
        }
        SQLSelectStatement sqlStatement = (SQLSelectStatement)list.get(0);
        SQLSelect sqlSelect = sqlStatement.getSelect();
        SqlFromTableInfo resultTableInfo = new SqlFromTableInfo(alis, "selectCollect", Boolean.FALSE);
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        HashSet<SqlFromTableInfo> analysisTableSet = new HashSet<SqlFromTableInfo>();
        SQLTableSource sqlTableSource = sqlSelectQuery.getFrom();
        this.analysisTable(sqlTableSource, analysisTableSet);
        if (CollectionUtils.isEmpty(analysisTableSet)) {
            return resultTableInfo;
        }
        HashSet<SqlFromTableInfo> resultTableSet = new HashSet<SqlFromTableInfo>();
        for (SqlFromTableInfo info : analysisTableSet) {
            if (Boolean.FALSE.equals(info.subQueryFlag)) {
                info.allFieldList = this.findFieldByTableName(connection, info.tableName, info.tableAlis);
                resultTableSet.add(info);
                continue;
            }
            resultTableSet.add(this.analysisFactFieldInfo(connection, info.tableName, info.tableAlis));
        }
        Map<String, SqlFromTableInfo> tableInfoMap = resultTableSet.stream().collect(Collectors.toMap(o -> ((SqlFromTableInfo)o).tableAlis, t -> t));
        List selectList = sqlSelectQuery.getSelectList();
        for (SQLSelectItem item : selectList) {
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLPropertyExpr) {
                SQLPropertyExpr p = (SQLPropertyExpr)expr;
                SqlFromTableInfo tableInfo = tableInfoMap.get(p.getOwnernName());
                Validate.notNull((Object)tableInfo, (String)"\u8868\u522b\u540d%s\u5bf9\u5e94\u6570\u636e\u8868\u4e0d\u5b58\u5728", (Object[])new Object[]{item.getAlias()});
                if ("*".equals(p.getName())) {
                    resultTableInfo.allFieldList.addAll(tableInfo.allFieldList);
                    continue;
                }
                Map<String, SqlFromTableFieldInfo> map = tableInfo.getAllFieldNameMap();
                SqlFromTableFieldInfo fieldInfo = map.get(String.format("%s_alis_%s", p.getOwnernName(), p.getName()));
                if (!Objects.nonNull(fieldInfo)) continue;
                resultTableInfo.allFieldList.add(fieldInfo);
                continue;
            }
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr id = (SQLIdentifierExpr)expr;
                for (Map.Entry entry : tableInfoMap.entrySet()) {
                    Map<String, SqlFromTableFieldInfo> allFieldNameMap = ((SqlFromTableInfo)entry.getValue()).getAllFieldNameMap();
                    SqlFromTableFieldInfo fieldInfo = allFieldNameMap.get(String.format("%s_alis_%s", entry.getKey(), id.getName()));
                    if (!Objects.nonNull(fieldInfo)) continue;
                    resultTableInfo.allFieldList.add(fieldInfo);
                }
                continue;
            }
            if (!(expr instanceof SQLAllColumnExpr)) continue;
            for (SqlFromTableInfo v : tableInfoMap.values()) {
                resultTableInfo.allFieldList.addAll(v.allFieldList);
            }
        }
        return resultTableInfo;
    }

    private SqlFromTableInfo buildFactFieldTableInfo(Connection connection, String sql) {
        SqlFromTableInfo resultTableInfo;
        try {
            resultTableInfo = this.analysisFactFieldInfo(connection, sql, "selectCollect");
        }
        catch (Exception e) {
            LOGGER.error("\u91c7\u7528druid\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790\u91cd\u6784sql\u51fa\u9519,\u5c06\u91c7\u7528\u539f\u59cbsql\u8fdb\u884c\u5143\u6570\u636e\u89e3\u6790", (Throwable)e);
            resultTableInfo = new SqlFromTableInfo("selectCollect", "selectCollect", Boolean.FALSE);
        }
        return resultTableInfo;
    }

    public void analysisTable(SQLTableSource from, Set<SqlFromTableInfo> tableList) {
        if (from instanceof SQLExprTableSource) {
            SQLExprTableSource t = (SQLExprTableSource)from;
            SQLExpr e = t.getExpr();
            if (e instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr id = (SQLIdentifierExpr)e;
                String tableName = id.getName();
                String alias = t.getAlias();
                alias = StringUtils.isNotBlank((CharSequence)alias) ? alias : tableName;
                tableList.add(new SqlFromTableInfo(alias, tableName, Boolean.FALSE));
            }
        } else if (from instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource s = (SQLSubqueryTableSource)from;
            String alias = s.getAlias();
            tableList.add(new SqlFromTableInfo(alias, s.toString(), Boolean.TRUE));
        } else if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource j = (SQLJoinTableSource)from;
            this.analysisTable(j.getLeft(), tableList);
            this.analysisTable(j.getRight(), tableList);
        }
    }

    private void bindDummyParams(PreparedStatement ps, String sql, SqlFromTableInfo fact) throws SQLException {
        int i;
        ParameterMetaData pmd = ps.getParameterMetaData();
        int count = pmd.getParameterCount();
        if (count == 0) {
            return;
        }
        ArrayList<Integer> qPos = new ArrayList<Integer>();
        for (int i2 = 0; i2 < sql.length(); ++i2) {
            if (sql.charAt(i2) != '?') continue;
            qPos.add(i2);
        }
        HashMap<String, SqlFromTableFieldInfo> aliasColMap = new HashMap<String, SqlFromTableFieldInfo>();
        for (SqlFromTableFieldInfo fi : fact.allFieldList) {
            aliasColMap.put((fi.tableAlis + "." + fi.fieldName).toLowerCase(Locale.ROOT), fi);
        }
        int[] types = new int[count];
        Arrays.fill(types, 12);
        Pattern cmp = Pattern.compile("([a-zA-Z_][\\w\\.]*)\\s*(=|<>|!=|<|>|<=|>=|(?i:like)|(?i:ilike)|(?i:in))\\s*\\(?\\s*\\?");
        Matcher m = cmp.matcher(sql);
        while (m.find()) {
            String left = m.group(1);
            int qIndex = -1;
            for (i = 0; i < qPos.size(); ++i) {
                if ((Integer)qPos.get(i) < m.start() || (Integer)qPos.get(i) >= m.end()) continue;
                qIndex = i;
                break;
            }
            if (qIndex < 0 || qIndex >= count) continue;
            String alias = "";
            String col = left;
            int dot = left.lastIndexOf(46);
            if (dot > 0) {
                alias = left.substring(0, dot);
                col = left.substring(dot + 1);
            }
            SqlFromTableFieldInfo fi = null;
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                fi = (SqlFromTableFieldInfo)aliasColMap.get((alias + "." + col).toLowerCase(Locale.ROOT));
            } else {
                for (SqlFromTableFieldInfo x : fact.allFieldList) {
                    if (!x.fieldName.equalsIgnoreCase(col)) continue;
                    if (fi == null) {
                        fi = x;
                        continue;
                    }
                    fi = null;
                    break;
                }
            }
            if (fi != null && fi.jdbcType != null) {
                types[qIndex] = fi.jdbcType;
                continue;
            }
            String op = m.group(2).toLowerCase(Locale.ROOT);
            if (!"like".equals(op) && !"ilike".equals(op)) continue;
            types[qIndex] = 12;
        }
        Pattern inHead = Pattern.compile("([a-zA-Z_][\\w\\.]*)\\s*(?i:in)\\s*\\(");
        Matcher inM = inHead.matcher(sql);
        block7: while (inM.find()) {
            int openIdx = inM.end();
            int firstQ = -1;
            int close = sql.indexOf(41, openIdx);
            for (int i3 = 0; i3 < qPos.size(); ++i3) {
                if ((Integer)qPos.get(i3) < openIdx) continue;
                firstQ = i3;
                break;
            }
            if (firstQ < 0) continue;
            int inType = types[firstQ];
            for (int i4 = firstQ + 1; i4 < qPos.size(); ++i4) {
                int pos = (Integer)qPos.get(i4);
                if (close <= 0 || pos >= close) continue block7;
                types[i4] = inType;
            }
        }
        for (i = 0; i < count; ++i) {
            try {
                ps.setNull(i + 1, types[i]);
                continue;
            }
            catch (SQLException e) {
                ps.setNull(i + 1, 12);
            }
        }
    }

    private static Integer toJdbcType(String dataType, String udtName) {
        String t;
        String string = t = udtName != null && !udtName.isEmpty() ? udtName : dataType;
        if (t == null) {
            return 12;
        }
        switch (t = t.toLowerCase(Locale.ROOT)) {
            case "int2": 
            case "smallint": {
                return 5;
            }
            case "int4": 
            case "integer": {
                return 4;
            }
            case "int8": 
            case "bigint": {
                return -5;
            }
            case "numeric": 
            case "decimal": {
                return 2;
            }
            case "float4": 
            case "real": {
                return 7;
            }
            case "float8": 
            case "double": {
                return 8;
            }
            case "bool": 
            case "boolean": {
                return 16;
            }
            case "varchar": 
            case "bpchar": 
            case "text": 
            case "citext": {
                return 12;
            }
            case "timestamp": 
            case "timestamp without time zone": 
            case "timestamptz": {
                return 93;
            }
            case "date": {
                return 91;
            }
            case "time": 
            case "timetz": {
                return 92;
            }
            case "bytea": {
                return -2;
            }
            case "uuid": {
                return 1111;
            }
            case "json": 
            case "jsonb": {
                return 1111;
            }
        }
        return 1111;
    }

    private void rewriteQueryOwnersToAlias(SQLSelectQueryBlock qb, Map<String, String> tableName2Alias) {
        SQLOrderBy ob;
        this.rewriteOwnerToAlias(qb.getWhere(), tableName2Alias);
        SQLSelectGroupByClause gb = qb.getGroupBy();
        if (gb != null) {
            for (SQLExpr e : gb.getItems()) {
                this.rewriteOwnerToAlias(e, tableName2Alias);
            }
            this.rewriteOwnerToAlias(gb.getHaving(), tableName2Alias);
        }
        if ((ob = qb.getOrderBy()) != null && ob.getItems() != null) {
            ob.getItems().forEach(it -> this.rewriteOwnerToAlias(it.getExpr(), tableName2Alias));
        }
        this.rewriteJoinConditions(qb.getFrom(), tableName2Alias);
    }

    private void rewriteJoinConditions(SQLTableSource ts, Map<String, String> tableName2Alias) {
        SQLSubqueryTableSource s;
        if (ts == null) {
            return;
        }
        if (ts instanceof SQLJoinTableSource) {
            SQLJoinTableSource j = (SQLJoinTableSource)ts;
            this.rewriteOwnerToAlias(j.getCondition(), tableName2Alias);
            this.rewriteJoinConditions(j.getLeft(), tableName2Alias);
            this.rewriteJoinConditions(j.getRight(), tableName2Alias);
        } else if (ts instanceof SQLSubqueryTableSource && (s = (SQLSubqueryTableSource)ts).getSelect() != null && s.getSelect().getQuery() instanceof SQLSelectQueryBlock) {
            this.rewriteQueryOwnersToAlias((SQLSelectQueryBlock)s.getSelect().getQuery(), tableName2Alias);
        }
    }

    private void rewriteOwnerToAlias(SQLExpr expr, Map<String, String> tableName2Alias) {
        if (expr == null) {
            return;
        }
        if (expr instanceof SQLPropertyExpr) {
            String alias;
            SQLPropertyExpr p = (SQLPropertyExpr)expr;
            String owner = p.getOwnernName();
            if (owner != null && (alias = tableName2Alias.get(owner.toLowerCase(Locale.ROOT))) != null) {
                p.setOwner(alias);
            }
            return;
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr b = (SQLBinaryOpExpr)expr;
            this.rewriteOwnerToAlias(b.getLeft(), tableName2Alias);
            this.rewriteOwnerToAlias(b.getRight(), tableName2Alias);
            return;
        }
        if (expr instanceof SQLInListExpr) {
            SQLInListExpr in = (SQLInListExpr)expr;
            this.rewriteOwnerToAlias(in.getExpr(), tableName2Alias);
            for (SQLExpr e : in.getTargetList()) {
                this.rewriteOwnerToAlias(e, tableName2Alias);
            }
            return;
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr m = (SQLMethodInvokeExpr)expr;
            for (SQLExpr a : m.getArguments()) {
                this.rewriteOwnerToAlias(a, tableName2Alias);
            }
            return;
        }
        if (expr instanceof SQLAggregateExpr) {
            SQLAggregateExpr ag = (SQLAggregateExpr)expr;
            for (SQLExpr a : ag.getArguments()) {
                this.rewriteOwnerToAlias(a, tableName2Alias);
            }
            return;
        }
        if (expr instanceof SQLCaseExpr) {
            SQLCaseExpr c = (SQLCaseExpr)expr;
            this.rewriteOwnerToAlias(c.getValueExpr(), tableName2Alias);
            for (SQLCaseExpr.Item it : c.getItems()) {
                this.rewriteOwnerToAlias(it.getConditionExpr(), tableName2Alias);
                this.rewriteOwnerToAlias(it.getValueExpr(), tableName2Alias);
            }
            this.rewriteOwnerToAlias(c.getElseExpr(), tableName2Alias);
            return;
        }
        if (expr instanceof SQLBetweenExpr) {
            SQLBetweenExpr be = (SQLBetweenExpr)expr;
            this.rewriteOwnerToAlias(be.getTestExpr(), tableName2Alias);
            this.rewriteOwnerToAlias(be.getBeginExpr(), tableName2Alias);
            this.rewriteOwnerToAlias(be.getEndExpr(), tableName2Alias);
        }
    }

    private static class SqlFromTableFieldInfo {
        private String tableAlis;
        private String fieldName;
        private String fieldComment;
        private Boolean primaryKey;
        private String dataType;
        private String udtName;
        private Integer jdbcType;

        public SqlFromTableFieldInfo(String tableAlis, String fieldName, String fieldComment, Boolean primaryKey) {
            this.tableAlis = tableAlis;
            this.fieldName = fieldName;
            this.fieldComment = fieldComment;
            this.primaryKey = primaryKey;
        }

        public SqlFromTableFieldInfo(String tableAlis, String fieldName, String fieldComment, Boolean primaryKey, String dataType, String udtName, Integer jdbcType) {
            this.tableAlis = tableAlis;
            this.fieldName = fieldName;
            this.fieldComment = fieldComment;
            this.primaryKey = primaryKey;
            this.dataType = dataType;
            this.udtName = udtName;
            this.jdbcType = jdbcType;
        }
    }

    private static class SqlFromTableInfo {
        private String tableAlis;
        private String tableName;
        private Boolean subQueryFlag;
        private List<SqlFromTableFieldInfo> allFieldList;

        public SqlFromTableInfo(String tableAlis, String tableName, Boolean subQueryFlag) {
            this.tableAlis = tableAlis;
            this.tableName = tableName;
            this.subQueryFlag = subQueryFlag;
            this.allFieldList = new ArrayList<SqlFromTableFieldInfo>();
        }

        public Map<String, SqlFromTableFieldInfo> getAllFieldNameMap() {
            HashMap<String, SqlFromTableFieldInfo> fieldMap = new HashMap<String, SqlFromTableFieldInfo>();
            if (CollectionUtils.isEmpty(this.allFieldList)) {
                return fieldMap;
            }
            return this.allFieldList.stream().collect(Collectors.toMap(f -> String.format("%s_alis_%s", ((SqlFromTableFieldInfo)f).tableAlis, ((SqlFromTableFieldInfo)f).fieldName), t -> t, (a, b) -> a));
        }

        public Map<String, List<SqlFromTableFieldInfo>> getTableFieldNameMap() {
            HashMap<String, List<SqlFromTableFieldInfo>> fieldMap = new HashMap<String, List<SqlFromTableFieldInfo>>();
            if (CollectionUtils.isEmpty(this.allFieldList)) {
                return fieldMap;
            }
            return this.allFieldList.stream().collect(Collectors.groupingBy(o -> ((SqlFromTableFieldInfo)o).tableAlis));
        }
    }
}

