/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.datasource.service.internal.AppDataSourceCacheProvider;
import com.bizunited.nebula.europa.database.local.entity.DataSourceEntity;
import com.bizunited.nebula.europa.database.local.repository.DataSourceRepository;
import com.bizunited.nebula.europa.database.sdk.service.CacheEntityManangerService;
import com.bizunited.nebula.europa.database.sdk.service.DatabaseSourceService;
import com.bizunited.nebula.europa.database.sdk.strategy.EntityManagerBuildingStrategy;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheEntityManangerServiceImpl
implements CacheEntityManangerService {
    @Autowired
    private Set<EntityManagerBuildingStrategy> entityManangerBuildingStraties;
    @Autowired
    private DataSourceRepository dataSourceRepository;
    @Autowired
    private AppDataSourceCacheProvider appDataSourceCacheProvider;
    @Autowired
    private DatabaseSourceService databaseSourceService;
    private Map<String, EntityManagerFactory> cache = Maps.newConcurrentMap();
    @Autowired
    private Redisson redisson;

    public void notifyCacheRefresh(String tenantCode, String dataSourceCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, dataSourceCode})) {
            return;
        }
        RTopic topic = this.redisson.getTopic("_EUROPAINFO_ENTITY_MANAGER_NOTIFY");
        topic.publish((Object)StringUtils.join((Object[])new String[]{tenantCode, "|", dataSourceCode}));
    }

    public void clearCache(String tenantCode, String dataSourceCode) {
        Validate.notBlank((CharSequence)tenantCode, (String)"\u6e05\u7406\u6570\u636e\u89c6\u56fe\u4e2a\u6027\u6837\u5f0f\u7f13\u5b58\u65f6\uff0c\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u6e05\u7406\u6570\u636e\u89c6\u56fe\u4e2a\u6027\u6837\u5f0f\u7f13\u5b58\u65f6\uff0c\u6570\u636e\u6e90\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String key = StringUtils.join((Object[])new String[]{tenantCode, "_", dataSourceCode});
        this.cache.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager findByTenantCodeAndDataSourceCode(String tenantCode, String dataSourceCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, dataSourceCode})) {
            return null;
        }
        String key = StringUtils.join((Object[])new String[]{tenantCode, "_", dataSourceCode});
        EntityManagerFactory currentEntityManagerFactory = this.cache.get(key);
        if (currentEntityManagerFactory != null) {
            return currentEntityManagerFactory.createEntityManager();
        }
        Class<CacheEntityManangerService> clazz = CacheEntityManangerService.class;
        synchronized (CacheEntityManangerService.class) {
            while ((currentEntityManagerFactory = this.cache.get(key)) == null) {
                String dataSourceType = null;
                DataSource currentDataSource = null;
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)dataSourceCode, (CharSequence[])new CharSequence[]{"default"})) {
                    String appCode = TenantUtils.getTenantCode();
                    currentDataSource = this.appDataSourceCacheProvider.findDataSource(appCode);
                    dataSourceType = "MYSQL";
                } else {
                    currentDataSource = this.databaseSourceService.cacheByCodeAndTenantCode(dataSourceCode, tenantCode);
                    DataSourceEntity databaseSourceEntity = this.dataSourceRepository.findByCodeAndTenantCode(dataSourceCode, tenantCode);
                    Validate.notNull((Object)((Object)databaseSourceEntity), (String)"\u8fdb\u884c\u6570\u636e\u89c6\u56fe\u67e5\u8be2\u65f6\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e\u6e90\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                    dataSourceType = databaseSourceEntity.getType();
                }
                Validate.notNull((Object)currentDataSource, (String)"\u8fdb\u884c\u6570\u636e\u89c6\u56fe\u6267\u884c\u65f6\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e\u6e90\u8bbe\u5b9a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c6\u56fe\u7684\u6570\u636e\u5e93\u6e90\u8bbe\u5b9a!!", (Object[])new Object[0]);
                EntityManagerBuildingStrategy matchedEntityManangerBuildingStrategy = null;
                for (EntityManagerBuildingStrategy entityManangerBuildingStrategy : this.entityManangerBuildingStraties) {
                    if (!entityManangerBuildingStrategy.canBuild(currentDataSource, dataSourceType)) continue;
                    matchedEntityManangerBuildingStrategy = entityManangerBuildingStrategy;
                    break;
                }
                Validate.notNull(matchedEntityManangerBuildingStrategy, (String)"\u672a\u627e\u5230\u4efb\u4f55\u5339\u914d\u7684\u67e5\u8be2\u7ba1\u7406\u5668\uff08entityManagerFactory/queryManagerFactory\uff09", (Object[])new Object[0]);
                currentEntityManagerFactory = matchedEntityManangerBuildingStrategy.build(currentDataSource);
                this.cache.put(key, currentEntityManagerFactory);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            Validate.notNull((Object)currentEntityManagerFactory, (String)"\u672a\u6210\u529f\u521b\u5efa\u4efb\u4f55\u67e5\u8be2\u7ba1\u7406\u5668\uff08entityManagerFactory/queryManagerFactory\uff09", (Object[])new Object[0]);
            return currentEntityManagerFactory.createEntityManager();
        }
    }
}

