/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.service.internal;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.local.entity.DataSourceEntity;
import com.bizunited.nebula.europa.database.local.repository.DataSourceRepository;
import com.bizunited.nebula.europa.database.sdk.service.CacheEntityManangerService;
import com.bizunited.nebula.europa.database.sdk.service.DatabaseSourceService;
import com.bizunited.nebula.europa.database.sdk.strategy.DataSourceValidateAndBuildStrategy;
import com.bizunited.nebula.europa.database.sdk.vo.DataSourceVo;
import com.bizunited.nebula.security.sdk.password.Aes2PasswordEncoder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DatabaseSourceServiceImpl")
public class DatabaseSourceServiceImpl
implements DatabaseSourceService {
    @Autowired
    private Aes2PasswordEncoder passwordEncoder;
    @Autowired
    private CacheEntityManangerService cacheEntityManangerService;
    @Autowired
    private DataSourceRepository dataSourceRepository;
    @Autowired
    private Set<DataSourceValidateAndBuildStrategy> dataSourceValidateAndBuildStraties;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    private Map<String, DataSource> dataSourceCache = Maps.newConcurrentMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseSourceServiceImpl.class);

    @Transactional
    public DataSourceVo create(DataSourceVo dataSource) {
        String code;
        DataSourceEntity oldDataSource;
        Validate.notNull((Object)dataSource, (String)"\u8fdb\u884c\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u5bf9\u6570\u636e\u6e90\u8fdb\u884c\u63cf\u8ff0", (Object[])new Object[0]);
        String password = dataSource.getPassword();
        Validate.notBlank((CharSequence)password, (String)"\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u5bc6\u7801", (Object[])new Object[0]);
        dataSource.setPassword(this.passwordEncoder.encode((CharSequence)password));
        String tenantCode = dataSource.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            dataSource.setTenantCode(TenantUtils.getTenantCode());
        }
        Validate.isTrue(((oldDataSource = this.dataSourceRepository.findByCodeAndTenantCode(code = dataSource.getCode(), tenantCode)) == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6570\u636e\u6e90\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!!", (Object[])new Object[0]);
        this.validate(dataSource);
        DataSourceEntity databaseSourceEntity = (DataSourceEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dataSource, DataSourceEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.dataSourceRepository.save((Object)databaseSourceEntity);
        return dataSource;
    }

    @Transactional
    public DataSourceVo update(DataSourceVo dataSource) {
        Validate.notNull((Object)dataSource, (String)"\u4fee\u6539\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String id = dataSource.getId();
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u4fee\u6539\u65f6\uff0c\u6307\u5b9a\u6570\u636e\u6e90\u7684id\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        String code = dataSource.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u7f16\u7801\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String tenantCode = dataSource.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)"\u6570\u636e\u6e90\u7684\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        DataSourceEntity current = this.dataSourceRepository.findByCodeAndTenantCode(code, tenantCode);
        Validate.notNull((Object)((Object)current), (String)"\u6ca1\u6709\u67e5\u5230\u5f53\u524d\u7f16\u7801\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((current.getTstatus() == 0 ? 1 : 0) != 0, (String)"\u53ea\u6709\u6570\u636e\u6e90\u72b6\u6001\u7981\u7528\u7684\u60c5\u51b5\u4e0b\uff0c\u624d\u80fd\u8fdb\u884c\u4fee\u6539!!", (Object[])new Object[0]);
        current.setAddress(dataSource.getAddress());
        current.setDbName(dataSource.getDbName());
        current.setUserName(dataSource.getUserName());
        String password = dataSource.getPassword();
        Validate.notBlank((CharSequence)password, (String)"\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u5e93\u5bc6\u7801", (Object[])new Object[0]);
        if (!current.getPassword().equals(password)) {
            current.setPassword(this.passwordEncoder.encode((CharSequence)dataSource.getPassword()));
        }
        current.setPort(dataSource.getPort());
        current.setUrlParams(dataSource.getUrlParams());
        current.setTstatus(dataSource.getTstatus());
        DataSourceVo currentDatabaseSourceVo = (DataSourceVo)this.nebulaToolkitService.copyObjectByBlankList((Object)current, DataSourceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.validate(currentDatabaseSourceVo);
        this.dataSourceRepository.save((Object)current);
        this.cacheEntityManangerService.notifyCacheRefresh(tenantCode, code);
        return currentDatabaseSourceVo;
    }

    private void validate(DataSourceVo dataSource) {
        DataSourceValidateAndBuildStrategy matchedDataSourceValidateAndBuildStrategy = this.matchedDataSourceValidateAndBuildStrategy(dataSource);
        matchedDataSourceValidateAndBuildStrategy.validate(dataSource);
    }

    @Transactional
    public void disable(String dataSourceCode) {
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        DataSourceEntity currentDataSource = this.dataSourceRepository.findByCodeAndTenantCode(dataSourceCode, tenantCode);
        Validate.notNull((Object)((Object)currentDataSource), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u6e90\u540d\u79f0\u4fe1\u606f", (Object[])new Object[0]);
        currentDataSource.setTstatus(0);
        this.dataSourceRepository.save((Object)currentDataSource);
        this.cacheEntityManangerService.notifyCacheRefresh(tenantCode, dataSourceCode);
    }

    @Transactional
    public void enable(String dataSourceCode) {
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u6570\u636e\u6e90\u540d\u79f0\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        DataSourceEntity currentDataSource = this.dataSourceRepository.findByCodeAndTenantCode(dataSourceCode, tenantCode);
        Validate.notNull((Object)((Object)currentDataSource), (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6570\u636e\u6e90\u540d\u79f0\u4fe1\u606f", (Object[])new Object[0]);
        currentDataSource.setTstatus(1);
        this.dataSourceRepository.save((Object)currentDataSource);
        this.cacheEntityManangerService.notifyCacheRefresh(tenantCode, dataSourceCode);
    }

    public void checkConnection(String dataSourceCode) {
        String tenantCode = TenantUtils.getTenantCode();
        DataSourceEntity currentDatabaseSource = this.dataSourceRepository.findByCodeAndTenantCode(dataSourceCode, tenantCode);
        Validate.notNull((Object)((Object)currentDatabaseSource), (String)"\u672a\u627e\u5230\u5f53\u524d\u79df\u6237\u4e0b\u7684\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        DataSourceVo currentDatabaseSourceVo = (DataSourceVo)this.nebulaToolkitService.copyObjectByBlankList((Object)currentDatabaseSource, DataSourceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        DataSourceValidateAndBuildStrategy matchedDataSourceValidateAndBuildStrategy = this.matchedDataSourceValidateAndBuildStrategy(currentDatabaseSourceVo);
        matchedDataSourceValidateAndBuildStrategy.checkConnection(currentDatabaseSourceVo);
    }

    private DataSourceValidateAndBuildStrategy matchedDataSourceValidateAndBuildStrategy(DataSourceVo databaseSource) {
        DataSourceValidateAndBuildStrategy matchedDataSourceValidateAndBuildStrategy = null;
        for (DataSourceValidateAndBuildStrategy dataSourceValidateAndBuildStrategy : this.dataSourceValidateAndBuildStraties) {
            if (!dataSourceValidateAndBuildStrategy.matched(databaseSource)) continue;
            matchedDataSourceValidateAndBuildStrategy = dataSourceValidateAndBuildStrategy;
        }
        Validate.notNull(matchedDataSourceValidateAndBuildStrategy, (String)"\u76ee\u524d\u6570\u636e\u89c6\u56fe\u4e0d\u652f\u6301\u7279\u5b9a\u7684\u6570\u636e\u6e90\u7c7b\u578b!!", (Object[])new Object[0]);
        return matchedDataSourceValidateAndBuildStrategy;
    }

    public List<DataSourceVo> findByCurrentTenantCode() {
        String tenantCode = TenantUtils.getTenantCode();
        List<DataSourceEntity> dataSources = this.dataSourceRepository.findByTenantCode(tenantCode);
        if (CollectionUtils.isEmpty(dataSources)) {
            return null;
        }
        Collection dataSourceVos = this.nebulaToolkitService.copyCollectionByBlankList(dataSources, DataSourceEntity.class, DataSourceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)dataSourceVos);
    }

    public DataSourceVo findDetailsByCodeAndCurrentTenantCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        DataSourceEntity dataSource = this.dataSourceRepository.findByCodeAndTenantCode(code, tenantCode);
        if (dataSource == null) {
            return null;
        }
        return (DataSourceVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dataSource, DataSourceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<DataSourceVo> findByTstatusAndCurrentTenantCode(Integer status) {
        if (status == null) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List<DataSourceEntity> dataSources = this.dataSourceRepository.findByTstatusAndTenantCode(status, tenantCode);
        if (CollectionUtils.isEmpty(dataSources)) {
            return null;
        }
        Collection dataSourceVos = this.nebulaToolkitService.copyCollectionByBlankList(dataSources, DataSourceEntity.class, DataSourceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)dataSourceVos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource cacheByCodeAndTenantCode(String code, String tenantCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, tenantCode})) {
            return null;
        }
        String key = StringUtils.join((Object[])new String[]{tenantCode, "_", code});
        DataSource dataSource = this.dataSourceCache.get(key);
        if (dataSource != null) {
            return dataSource;
        }
        DataSourceEntity dataSourceEntity = this.dataSourceRepository.findByCodeAndTenantCode(code, tenantCode);
        if (dataSourceEntity == null) {
            return null;
        }
        DataSourceVo dataSourceVo = (DataSourceVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dataSourceEntity, DataSourceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        DataSourceValidateAndBuildStrategy matchedDataSourceValidateAndBuildStrategy = this.matchedDataSourceValidateAndBuildStrategy(dataSourceVo);
        DruidDataSource druidDataSource = null;
        Class<DatabaseSourceService> clazz = DatabaseSourceService.class;
        synchronized (DatabaseSourceService.class) {
            druidDataSource = matchedDataSourceValidateAndBuildStrategy.buildDataSource(dataSourceVo);
            try (DruidPooledConnection druidPooledConnection = druidDataSource.tryGetConnection();){
                LOGGER.info("==== \u6570\u636e\u6e90\u8bbe\u5b9a\u6210\u529f ");
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage());
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return druidDataSource;
        }
    }
}

