/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.local.service.querymanager;

import com.bizunited.nebula.europa.database.sdk.strategy.EntityManagerBuildingStrategy;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.ValidationMode;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.ReflectiveLoadTimeWeaver;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.stereotype.Component;

@Component(value="mySQLForEntityManangerBuildingStrategy")
public class MySQLForEntityManangerBuildingStrategy
implements EntityManagerBuildingStrategy {
    private static final String DATABASE_TYPE = "MYSQL";
    @Autowired
    private EntityManagerFactoryBuilder builder;

    public boolean canBuild(DataSource dataSource, String databaseType) {
        return StringUtils.equals((CharSequence)databaseType, (CharSequence)DATABASE_TYPE);
    }

    public EntityManagerFactory build(DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = this.builder.dataSource(dataSource).packages(new String[]{"com.bizunited.nebula.europa.database.local.entity"}).build();
        Properties jpaProperties = new Properties();
        jpaProperties.put("hibernate.dialect", "org.hibernate.dialect.MySQL8Dialect");
        jpaProperties.put("hibernate.physical_naming_strategy", "org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy");
        jpaProperties.put("hibernate.connection.charSet", "utf-8");
        jpaProperties.put("hibernate.show_sql", "true");
        jpaProperties.put("hibernate.generate-ddl", "false");
        jpaProperties.put("hibernate.format_sql", "false");
        entityManagerFactoryBean.setValidationMode(ValidationMode.AUTO);
        entityManagerFactoryBean.setJpaProperties(jpaProperties);
        entityManagerFactoryBean.setLoadTimeWeaver((LoadTimeWeaver)new ReflectiveLoadTimeWeaver());
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        entityManagerFactoryBean.afterPropertiesSet();
        EntityManagerFactory entityManagerFactory = entityManagerFactoryBean.getObject();
        return entityManagerFactory;
    }
}

