/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.register.local.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.europa.database.register.local.model.RegisterPreExecutionInfo;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.sdk.strategy.AbstractDatabasePreExecutionStrategy;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.service.strategy.PreExecutionStrategy;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="databasePreRegisterExecutionStrategy")
public class DatabasePreRegisterExecutionStrategy
extends AbstractDatabasePreExecutionStrategy
implements PreExecutionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabasePreRegisterExecutionStrategy.class);
    @Autowired(required=false)
    private Set<DataviewRegister> dataviewRegisters;

    public boolean validate(String sourceType, String content) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)sourceType, (CharSequence[])new CharSequence[]{"register_database"});
    }

    public MetaData preExecution(String sourceType, String content) {
        Validate.notBlank((CharSequence)content, (String)"\u9884\u6267\u884c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u9700\u8981\u89e3\u6790\u7684\u67e5\u8be2\u5185\u5bb9", (Object[])new Object[0]);
        RegisterPreExecutionInfo preExecutionInfo = null;
        try {
            JSONObject jsonObject = JSON.parseObject((String)content);
            preExecutionInfo = (RegisterPreExecutionInfo)JSONObject.toJavaObject((JSON)jsonObject, RegisterPreExecutionInfo.class);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u9519\u8bef\u7684JSON\u7ed3\u6784\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u4fe1\u606f");
        }
        String dataSourceCode = preExecutionInfo.getDataSourceCode();
        String dataviewCode = preExecutionInfo.getDataviewCode();
        Validate.notBlank((CharSequence)dataSourceCode, (String)"\u9884\u6267\u884c\u65f6\uff0c\u9700\u8981\u4f20\u5165\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4e1a\u52a1\u7f16\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataviewCode, (String)"\u9884\u6267\u884c\u65f6\uff0c\u9700\u8981\u4f20\u5165\u5bf9\u5e94\u7684\u9884\u6267\u884c\u6570\u636e\u89c6\u56fe\u6ce8\u518c\u5668\u7684code", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.dataviewRegisters) ? 1 : 0) != 0, (String)"\u9884\u6267\u884c\u65f6\uff0c\u81f3\u5c11\u7cfb\u7edf\u4e2d\u5df2\u6ce8\u518c\u4e86\u4e00\u4e2a\u6570\u636e\u89c6\u56fe\u6ce8\u518c\u5668", (Object[])new Object[0]);
        DataviewRegister matchedDataviewRegister = null;
        for (DataviewRegister dataviewRegister : this.dataviewRegisters) {
            String currentDataviewCode = dataviewRegister.code();
            if (!StringUtils.equals((CharSequence)currentDataviewCode, (CharSequence)dataviewCode)) continue;
            matchedDataviewRegister = dataviewRegister;
            break;
        }
        Validate.notNull(matchedDataviewRegister, (String)"\u4e0e\u6267\u884c\u65f6\uff0c\u6ca1\u6709\u53d1\u73b0dataviewCode[%s]\u5339\u914d\u7684\u6570\u636e\u89c6\u56fe\u6ce8\u518c\u5668", (Object[])new Object[]{dataviewCode});
        String sql = matchedDataviewRegister.buildSql();
        return super.doPreExecution(dataSourceCode, sql);
    }
}

