/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.register.local.service;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.strategy.ViewInfoValidateStrategy;
import com.bizunited.nebula.europa.sdk.vo.AbstractView;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DatabaseRegisterViewInfoValidateStrategy
implements ViewInfoValidateStrategy {
    @Autowired(required=false)
    private List<DataviewRegister> dataviewRegisters;

    public boolean support(boolean isCreate, AbstractView dataView) {
        if (!(dataView instanceof DatabaseViewVo)) {
            return false;
        }
        DatabaseViewVo databaseViewVo = (DatabaseViewVo)dataView;
        String souceType = databaseViewVo.getSouceType();
        return StringUtils.equals((CharSequence)souceType, (CharSequence)"register_database");
    }

    public void validate(boolean isCreate, AbstractView dataView) {
        String onTime;
        DatabaseViewVo databaseView = (DatabaseViewVo)dataView;
        String string = onTime = isCreate ? "\u521b\u5efa\u65f6" : "\u4fee\u6539\u65f6";
        if (!isCreate) {
            String id = databaseView.getId();
            Validate.notBlank((CharSequence)id, (String)(onTime + "\uff0c\u53d1\u73b0\u6570\u636e\u89c6\u56fe\u7684\u6280\u672f\u7f16\u53f7\uff08id\uff09\u672a\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        }
        Validate.notNull((Object)databaseView, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u6570\u636e\u5e93\u67e5\u8be2\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String tenantCode = databaseView.getTenantCode();
        Validate.notBlank((CharSequence)tenantCode, (String)(onTime + "\uff0c\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String europaCode = databaseView.getEuropaCode();
        Validate.notBlank((CharSequence)europaCode, (String)(onTime + "\uff0c\u5173\u8054\u7684\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606fcode\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String name = databaseView.getName();
        Validate.notBlank((CharSequence)name, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u540d\u79f0\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String registerCode = databaseView.getRegisterCode();
        Validate.notBlank((CharSequence)registerCode, (String)(onTime + "\uff0c\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u6ce8\u518ccode\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.dataviewRegisters) ? 1 : 0) != 0, (String)(onTime + "\uff0c\u53d1\u73b0\u672c\u7cfb\u7edf\u672a\u6ce8\u518c\u4efb\u4f55\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff08DataviewRegister\uff09"), (Object[])new Object[0]);
        boolean matched = false;
        for (DataviewRegister dataviewRegister : this.dataviewRegisters) {
            if (!StringUtils.equals((CharSequence)dataviewRegister.code(), (CharSequence)registerCode)) continue;
            matched = true;
            databaseView.setName(dataviewRegister.desc());
            break;
        }
        Validate.isTrue((boolean)matched, (String)(onTime + "\uff0c\u53d1\u73b0\u5f53\u524d\u6570\u636e\u89c6\u56fe\u7684\u6ce8\u518c\u7f16\u53f7\uff08code\uff09\u6ca1\u6709\u4efb\u4f55\u5339\u914d\u7684\u6ce8\u518c\u4fe1\u606f!!"), (Object[])new Object[0]);
        databaseView.setSourceSql("");
    }
}

