package com.bizunited.nebula.europa.database.register.local.controller;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.register.sdk.vo.DataviewRegisterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@Api(value = "DataviewRegisterController", tags = "europa——基于数据库的，模板注册形式的HTTP层接口")
@RestController
@RequestMapping("/v1/europa/dataviewRegisters")
public class DataviewRegisterController extends BaseController {
  @Autowired(required = false)
  private List<DataviewRegister> dataviewRegisters;
  
  @ApiOperation(value = "查询目前系统中已注册的所有数据视图（模板）信息")
  @RequestMapping(value = "/findAllByPage", method = RequestMethod.GET)
  public ResponseModel findAll(Pageable pageable, @RequestParam(name = "code" , required = false) String code , @RequestParam(name = "desc" , required = false) String desc) {
    try {
      if(CollectionUtils.isEmpty(dataviewRegisters)) {
        return this.buildHttpResult();
      }
      //分页
      pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
      int pageSize = pageable.getPageSize();
      int pageNumber = pageable.getPageNumber();
      List<DataviewRegisterVo> res =new ArrayList<>();
      for (DataviewRegister dataviewRegister : dataviewRegisters) {
        String codeItem = dataviewRegister.code();
        String descItem = dataviewRegister.desc();
        // 如果存在查询条件，则需要满足查询条件
        if(StringUtils.isNotBlank(code) && StringUtils.indexOfIgnoreCase(codeItem, code) == -1) {
          continue;
        }
        if(StringUtils.isNotBlank(desc) && StringUtils.indexOfIgnoreCase(descItem, desc) == -1) {
          continue;
        }
        DataviewRegisterVo vo =new DataviewRegisterVo();
        vo.setCode(codeItem);
        vo.setDesc(descItem);
        res.add(vo);
      }
      //注意:
      //baseController的page方法不适用，baseController的page来自springData包，目前发现只能用于Sql分页，
      //并且无法初始化也无法set值，故使用mybatisPlus下的插件分页包。
      Page<DataviewRegisterVo> pages =new Page<>();
      List page = this.page(res, pageNumber, pageSize);
      pages.setRecords(page);
      //可能会存在查询条件
      pages.setTotal(res.size());
      pages.setCurrent(pageNumber+1);
      pages.setSize(pageSize);
      pages.setPages((res.size() + pageSize - 1) / pageSize);
      ResponseModel responseModel = new ResponseModel((new Date()).getTime(), (Object)null, ResponseCode.E0, (Throwable)null);
      responseModel.setData(pages);
      return responseModel;
    } catch (RuntimeException e) {
      return this.buildHttpResultForException(e);
    }
  }



  @ApiOperation(value = "查询目前系统中已注册的所有数据视图（模板）信息")
  @RequestMapping(value = "/findAll", method = RequestMethod.GET)
  public ResponseModel findAll(@RequestParam(name = "code" , required = false) String code , @RequestParam(name = "desc" , required = false) String desc) {
    try {
      if(CollectionUtils.isEmpty(dataviewRegisters)) {
        return this.buildHttpResult();
      }

      JSONArray resutls = new JSONArray();
      for (DataviewRegister dataviewRegister : dataviewRegisters) {
        String codeItem = dataviewRegister.code();
        String descItem = dataviewRegister.desc();
        // 如果存在查询条件，则需要满足查询条件
        if(StringUtils.isNotBlank(code) && StringUtils.indexOfIgnoreCase(codeItem, code) == -1) {
          continue;
        }
        if(StringUtils.isNotBlank(desc) && StringUtils.indexOfIgnoreCase(descItem, desc) == -1) {
          continue;
        }
        JSONObject item = new JSONObject();
        item.put("code", codeItem);
        item.put("desc", descItem);
        resutls.add(item);
      }
      return this.buildHttpResultW(resutls);
    } catch (RuntimeException e) {
      return this.buildHttpResultForException(e);
    }
  }
  /**
   *
   * @param list  要分页的集合
   * @param pageNo    第几页
   * @param pageSize  每页条数
   * @return      分页集合对象
   */
  private  List page(List list, int pageNo, int pageSize){
    List result = new ArrayList();
    if (list != null && list.size() > 0) {
      int allCount = list.size();
      //前端起始当前页为0
      int start = (pageNo) * pageSize;
      if (start<0){
        return new ArrayList();
      }
      int end = (pageNo+1) * pageSize;
      if (end >= allCount) {
        end = allCount;
      }
      for (int i = start; i < end; i++) {
        result.add(list.get(i));
      }
    }
    return (result.size() > 0) ? result : new ArrayList();
  }
}
