package com.bizunited.nebula.europa.database.register.local.service;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.bizunited.nebula.europa.database.register.sdk.constant.Constant;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.strategy.ViewInfoValidateStrategy;
import com.bizunited.nebula.europa.sdk.vo.AbstractView;

/**
 * 以数据源SQL设置方式形成数据视图的场景下，当数据视图被创建或者被修改时，该验证逻辑起作用
 * @author yinwenjie
 */
@Component
public class DatabaseRegisterViewInfoValidateStrategy implements ViewInfoValidateStrategy {

  @Autowired(required = false)
  private List<DataviewRegister> dataviewRegisters;
  
  @Override
  public boolean support(boolean isCreate, AbstractView dataView) {
    if(!(dataView instanceof DatabaseViewVo)) {
      return false;
    }
    DatabaseViewVo databaseViewVo = (DatabaseViewVo)dataView;
    String souceType = databaseViewVo.getSouceType();
    return StringUtils.equals(souceType, Constant.DATA_SOURCE_TYPE);
  }

  @Override
  public void validate(boolean isCreate, AbstractView dataView) {
    DatabaseViewVo databaseView = (DatabaseViewVo)dataView;
    String onTime = isCreate?"创建时":"修改时";
    if(!isCreate) {
      String id = databaseView.getId();
      Validate.notBlank(id , onTime + "，发现数据视图的技术编号（id）未传入，请检查!!");
    }
    Validate.notNull(databaseView , onTime + "，错误的数据库查询信息，请检查!!");
    // 边界校验
    String tenantCode = databaseView.getTenantCode();
    Validate.notBlank(tenantCode , onTime + "，二级租户信息必须传入，请检查!!");
    String europaCode = databaseView.getEuropaCode();
    Validate.notBlank(europaCode , onTime + "，关联的数据视图基本信息code必须传入，请检查!!");
    String name = databaseView.getName();
    Validate.notBlank(name , onTime + "，错误的数据视图名称信息，请检查!!");
    String registerCode = databaseView.getRegisterCode();
    Validate.notBlank(registerCode , onTime + "，错误的数据视图注册code，请检查!!");
    // 验证registerCode的存在性
    Validate.isTrue(!CollectionUtils.isEmpty(dataviewRegisters) , onTime + "，发现本系统未注册任何数据视图信息（DataviewRegister）");
    boolean matched = false;
    for (DataviewRegister dataviewRegister : dataviewRegisters) {
      if(StringUtils.equals(dataviewRegister.code(), registerCode)) {
        matched = true;
        databaseView.setName(dataviewRegister.desc());
        break;
      }
    }
    Validate.isTrue(matched , onTime + "，发现当前数据视图的注册编号（code）没有任何匹配的注册信息!!");
    databaseView.setSourceSql("");
  }
}
