package com.bizunited.nebula.europa.database.register.local.service;

import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.bizunited.nebula.europa.database.register.local.model.RegisterPreExecutionInfo;
import com.bizunited.nebula.europa.database.register.sdk.constant.Constant;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.sdk.strategy.AbstractDatabasePreExecutionStrategy;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.service.strategy.PreExecutionStrategy;

/**
 * 针对指定的数据源和SQL，进行执行结果的预览。</br>
 * 注意：这里存储的是从支持数据库查询出来的最原始的元数据信息，并没有经过任何过滤器处理</p>
 * @author yinwenjie
 */
@Component("databasePreRegisterExecutionStrategy")
public class DatabasePreRegisterExecutionStrategy extends AbstractDatabasePreExecutionStrategy implements PreExecutionStrategy {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DatabasePreRegisterExecutionStrategy.class);
  /**
   * 已注册的数据视图信息
   */
  @Autowired(required = false)
  private Set<DataviewRegister> dataviewRegisters;
  
  @Override
  public boolean validate(String sourceType, String content) {
    return StringUtils.equalsAnyIgnoreCase(sourceType, Constant.DATA_SOURCE_TYPE);
  }
  
  @Override
  public MetaData preExecution(String sourceType, String content) {
    // 转换为RegisterPreExecutionInfo对象
    Validate.notBlank(content , "预执行时，必须传入需要解析的查询内容");
    RegisterPreExecutionInfo preExecutionInfo = null;
    try {
      JSONObject jsonObject = JSON.parseObject(content);
      preExecutionInfo = JSONObject.toJavaObject(jsonObject, RegisterPreExecutionInfo.class);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      throw new IllegalArgumentException("错误的JSON结构信息，请检查传入信息");
    }
    String dataSourceCode = preExecutionInfo.getDataSourceCode();
    String dataviewCode = preExecutionInfo.getDataviewCode();
    Validate.notBlank(dataSourceCode , "预执行时，需要传入对应的数据源业务编号");
    Validate.notBlank(dataviewCode , "预执行时，需要传入对应的预执行数据视图注册器的code");
    Validate.isTrue(!CollectionUtils.isEmpty(dataviewRegisters) , "预执行时，至少系统中已注册了一个数据视图注册器");
    DataviewRegister matchedDataviewRegister = null;
    for (DataviewRegister dataviewRegister : dataviewRegisters) {
      String currentDataviewCode = dataviewRegister.code();
      if(StringUtils.equals(currentDataviewCode, dataviewCode)) {
        matchedDataviewRegister = dataviewRegister;
        break;
      }
    }
    Validate.notNull(matchedDataviewRegister , "与执行时，没有发现dataviewCode[%s]匹配的数据视图注册器" , dataviewCode);
    String sql = matchedDataviewRegister.buildSql();
    // 正式进行预执行的元数据解析
    return super.doPreExecution(dataSourceCode, sql);
  }
}
