package com.bizunited.nebula.europa.database.register.local.init;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.init.service.InitProcessEnvironmentService;

/**
 * 当应用程序启动时，该初始化动作用于确定系统中没有code相同的，实现了DataviewRegister注册器的对象
 * @author yinwenjie
 *
 */
@Component
public class DatabaseViewRegisterEuropaInit implements InitProcessEnvironmentService {

  @Autowired(required = false)
  private List<DataviewRegister> dataviewRegisters;
  
  @Override
  public void initForAppCode(String appCode) {
    if(CollectionUtils.isEmpty(dataviewRegisters)) {
      return;
    }
    
    long count = this.dataviewRegisters.stream().map(DataviewRegister::code).filter(code -> StringUtils.isNotBlank(code)).distinct().count();
    Validate.isTrue(count == dataviewRegisters.size() , "已注册形式设定的数据视图中，发现至少一个数据视图注册信息（DataviewRegister）存在重复的code或者code没有设定");
  }

  @Override
  public boolean doInitForAppCode(String appCode) {
    // 只有default顶级租户需要执行一次检查
    return StringUtils.equals(appCode, "default");
  }
}
