/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.register.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.register.sdk.vo.DataviewRegisterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="DataviewRegisterController", tags={"europa\u2014\u2014\u57fa\u4e8e\u6570\u636e\u5e93\u7684\uff0c\u6a21\u677f\u6ce8\u518c\u5f62\u5f0f\u7684HTTP\u5c42\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/europa/dataviewRegisters"})
public class DataviewRegisterController
extends BaseController {
    @Autowired(required=false)
    private List<DataviewRegister> dataviewRegisters;

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\u5df2\u6ce8\u518c\u7684\u6240\u6709\u6570\u636e\u89c6\u56fe\uff08\u6a21\u677f\uff09\u4fe1\u606f")
    @RequestMapping(value={"/findAllByPage"}, method={RequestMethod.GET})
    public ResponseModel findAll(Pageable pageable, @RequestParam(name="code", required=false) String code, @RequestParam(name="desc", required=false) String desc) {
        try {
            if (CollectionUtils.isEmpty(this.dataviewRegisters)) {
                return this.buildHttpResult();
            }
            pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
            int pageSize = pageable.getPageSize();
            int pageNumber = pageable.getPageNumber();
            ArrayList<DataviewRegisterVo> res = new ArrayList<DataviewRegisterVo>();
            for (DataviewRegister dataviewRegister : this.dataviewRegisters) {
                String codeItem = dataviewRegister.code();
                String descItem = dataviewRegister.desc();
                if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.indexOfIgnoreCase((CharSequence)codeItem, (CharSequence)code) == -1 || StringUtils.isNotBlank((CharSequence)desc) && StringUtils.indexOfIgnoreCase((CharSequence)descItem, (CharSequence)desc) == -1) continue;
                DataviewRegisterVo vo = new DataviewRegisterVo();
                vo.setCode(codeItem);
                vo.setDesc(descItem);
                res.add(vo);
            }
            Page pages = new Page();
            List page = this.page(res, pageNumber, pageSize);
            pages.setRecords(page);
            pages.setTotal((long)res.size());
            pages.setCurrent((long)(pageNumber + 1));
            pages.setSize((long)pageSize);
            pages.setPages((long)((res.size() + pageSize - 1) / pageSize));
            ResponseModel responseModel = new ResponseModel(Long.valueOf(new Date().getTime()), null, ResponseCode.E0, (Throwable)null);
            responseModel.setData((Object)pages);
            return responseModel;
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\u5df2\u6ce8\u518c\u7684\u6240\u6709\u6570\u636e\u89c6\u56fe\uff08\u6a21\u677f\uff09\u4fe1\u606f")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll(@RequestParam(name="code", required=false) String code, @RequestParam(name="desc", required=false) String desc) {
        try {
            if (CollectionUtils.isEmpty(this.dataviewRegisters)) {
                return this.buildHttpResult();
            }
            JSONArray resutls = new JSONArray();
            for (DataviewRegister dataviewRegister : this.dataviewRegisters) {
                String codeItem = dataviewRegister.code();
                String descItem = dataviewRegister.desc();
                if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.indexOfIgnoreCase((CharSequence)codeItem, (CharSequence)code) == -1 || StringUtils.isNotBlank((CharSequence)desc) && StringUtils.indexOfIgnoreCase((CharSequence)descItem, (CharSequence)desc) == -1) continue;
                JSONObject item = new JSONObject();
                item.put("code", (Object)codeItem);
                item.put("desc", (Object)descItem);
                resutls.add((Object)item);
            }
            return this.buildHttpResultW((Iterable)resutls, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    private List page(List list, int pageNo, int pageSize) {
        ArrayList result = new ArrayList();
        if (list != null && list.size() > 0) {
            int allCount = list.size();
            int start = pageNo * pageSize;
            if (start < 0) {
                return new ArrayList();
            }
            int end = (pageNo + 1) * pageSize;
            if (end >= allCount) {
                end = allCount;
            }
            for (int i = start; i < end; ++i) {
                result.add(list.get(i));
            }
        }
        return result.size() > 0 ? result : new ArrayList();
    }
}

