package com.bizunited.nebula.europa.database.register.sdk.service;

/**
 * 基于注册方式的数据视图创建方式（这是一种推荐使用的基于数据库实现的数据视图方式）
 * @author yinwenjie
 *
 */
public interface DataviewRegister {
  /**
   * 全系统唯一的数据视图业务编号（例如orderList）</br>
   * 如果不唯一，系统将会报错
   */
  public String code();
  /**
   * 注册的数据视图描述信息（例如：订单业务主列表视图）
   */
  public String desc();
  /**
   * 这个数据视图所使用的SQL语句，注意这个SQL语句不需要包括任何分页查询的关键字、不需要包括和数据权限有关的任何查询条件，
   * 也不要包括和任何特定数据库有关的关键字。</p>
   * 但是可以加入和必传参数有关的参数绑定位置，例如：</p>
   * <code>
   * select * from user where user.name = :name
   * </code>
   * 
   * 这样的话，数据视图的正式执行就必须传入参数名为name的参数信息</p>
   */
  public String buildSql();
}

