/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.sdk.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.dto.FieldStatisticBaseDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteContent;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseOrderParameter;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaData;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaDataField;
import com.bizunited.nebula.europa.database.sdk.service.CacheEntityManangerService;
import com.bizunited.nebula.europa.database.sdk.service.ExecuteParameterBuildInterceptor;
import com.bizunited.nebula.europa.database.sdk.strategy.ExecuteContentInterceptor;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.database.sdk.strategy.FieldConvertFuncStrategy;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategyAdapter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.database.sdk.utils.SQLAnalyzeUtils;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewExternalFieldVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewMateDataConditionVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewOrderVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewParameterConditionVo;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.europa.sdk.context.execute.OrderParameter;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaDataField;
import com.bizunited.nebula.europa.sdk.enums.ExecuteContentSqlTypeEnum;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public abstract class AbstractDatabaseExecutionStrategy {
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private Set<ParameterValueBindingStrategy> parameterValueBindingStrategies;
    @Autowired(required=false)
    private Set<FieldConvertFuncStrategy> fieldConvertFuncStrategies;
    @Autowired
    private CacheEntityManangerService cacheEntityManangerService;
    @Autowired(required=false)
    private Set<ExecuteParameterBuildInterceptor> executeParameterBuildInterceptors;
    @Autowired(required=false)
    private List<ExternalQueryInterceptor> externalQueryInterceptors;
    @Autowired
    private Set<ParameterOperatorBindingStrategy> parameterOperatorBindingStrategies;
    @Autowired(required=false)
    private List<ExecuteContentInterceptor> executeContentInterceptors;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDatabaseExecutionStrategy.class);

    protected abstract String sourceSql(EuropaInfoVo var1);

    public RequestParameter buildRequestParameter(EuropaInfoVo europaInfoVo, HttpServletRequest request, Pageable pageable) {
        DatabaseExecuteExternalRequest invokeParamContent = new DatabaseExecuteExternalRequest();
        Map parameterMap = request.getParameterMap();
        if (!CollectionUtils.isEmpty((Map)parameterMap)) {
            for (Map.Entry entryItem : parameterMap.entrySet()) {
                String parameterName = (String)entryItem.getKey();
                Object[] parameterValues = (String[])entryItem.getValue();
                if (parameterValues == null || parameterValues.length == 0) continue;
                if (parameterValues.length == 1) {
                    invokeParamContent.setAttribute(parameterName, parameterValues[0]);
                    continue;
                }
                invokeParamContent.setAttribute(parameterName, Lists.newArrayList((Object[])parameterValues));
            }
        }
        JSONObject bodyJson = null;
        if (StringUtils.indexOf((CharSequence)request.getContentType(), (CharSequence)"application/json") != -1) {
            try {
                ServletInputStream input = request.getInputStream();
                Iterator iterator = null;
                try {
                    int realLen;
                    int maxLen = 4096;
                    byte[] contentBytes = new byte[maxLen];
                    StringBuilder contentBuilder = new StringBuilder();
                    while ((realLen = input.read(contentBytes, 0, maxLen)) != -1) {
                        contentBuilder.append(new String(contentBytes, 0, realLen));
                    }
                    bodyJson = JSONObject.parseObject((String)contentBuilder.toString());
                }
                catch (Throwable maxLen) {
                    iterator = maxLen;
                    throw maxLen;
                }
                finally {
                    if (input != null) {
                        if (iterator != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable maxLen) {
                                ((Throwable)((Object)iterator)).addSuppressed(maxLen);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            Set jsonItems = bodyJson.entrySet();
            for (Map.Entry jsonItem : jsonItems) {
                String key = (String)jsonItem.getKey();
                Object value = jsonItem.getValue();
                if (value instanceof JSON) continue;
                invokeParamContent.setAttribute(key, value);
            }
        }
        if (pageable != null) {
            invokeParamContent.setPageable(pageable);
            Sort sort = pageable.getSort();
            if (sort != null && !sort.isEmpty()) {
                for (Sort.Order orderItem : sort) {
                    invokeParamContent.setAttribute(StringUtils.join((Object[])new String[]{"sort.", orderItem.getProperty()}), orderItem.getDirection() == Sort.Direction.ASC ? "asc" : "desc");
                }
            }
        } else {
            invokeParamContent.setPageable((Pageable)PageRequest.of((int)0, (int)50));
        }
        return invokeParamContent;
    }

    public Set<ExecuteParameter> buildExecuteParameters(MetaData metaData, EuropaInfoVo europaInfoVo, RequestParameter requestParameter) {
        DatabaseExecuteParameter databaseExecuteParameter;
        DatabaseExecuteExternalRequest databaseExecuteExternalRequest = (DatabaseExecuteExternalRequest)requestParameter;
        DatabaseViewVo databaseView = (DatabaseViewVo)europaInfoVo.getView();
        Set<DatabaseViewMateDataConditionVo> databaseViewMateDataConditions = databaseView.getDatabaseViewMateDataConditions();
        Set<DatabaseViewParameterConditionVo> databaseViewParameterConditions = databaseView.getDatabaseViewParameterConditions();
        LinkedHashSet allExecuteParameters = Sets.newLinkedHashSet();
        if (CollectionUtils.isEmpty(databaseViewMateDataConditions) && CollectionUtils.isEmpty(databaseViewParameterConditions)) {
            return allExecuteParameters;
        }
        LinkedHashSet matedataExecuteParameters = Sets.newLinkedHashSet();
        if (!CollectionUtils.isEmpty(databaseViewMateDataConditions)) {
            for (DatabaseViewMateDataConditionVo databaseViewMateDataConditionVo : databaseViewMateDataConditions) {
                String paramName = databaseViewMateDataConditionVo.getParamName();
                DatabaseExecuteParameter databaseExecuteParameter2 = (DatabaseExecuteParameter)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseViewMateDataConditionVo, DatabaseExecuteParameter.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                databaseExecuteParameter2.setParamName(paramName);
                databaseExecuteParameter2.setResource("matedata");
                matedataExecuteParameters.add(databaseExecuteParameter2);
            }
        }
        LinkedHashSet dynamicExecuteParameters = Sets.newLinkedHashSet();
        if (!CollectionUtils.isEmpty(databaseViewParameterConditions)) {
            for (DatabaseViewParameterConditionVo databaseViewParameterCondition : databaseViewParameterConditions) {
                String paramName = databaseViewParameterCondition.getParamName();
                Object externalRequestValue = databaseExecuteExternalRequest.getAttribute(paramName);
                if (externalRequestValue == null) continue;
                databaseExecuteParameter = (DatabaseExecuteParameter)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseViewParameterCondition, DatabaseExecuteParameter.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                databaseExecuteParameter.setResource("dynamic");
                dynamicExecuteParameters.add(databaseExecuteParameter);
            }
        }
        if (!CollectionUtils.isEmpty(this.executeParameterBuildInterceptors)) {
            for (ExecuteParameterBuildInterceptor executeParameterBuildInterceptor : this.executeParameterBuildInterceptors) {
                executeParameterBuildInterceptor.onBuildExecuteParameters(metaData, europaInfoVo, dynamicExecuteParameters);
            }
        }
        for (ExecuteParameter executeParameter : dynamicExecuteParameters) {
            DatabaseExecuteParameter databaseDynamicExecuteParameter = (DatabaseExecuteParameter)executeParameter;
            this.validateDynamicExecuteParameters((DatabaseMetaData)metaData, databaseDynamicExecuteParameter);
        }
        HashMap hashMap = CollectionUtils.isEmpty(this.fieldConvertFuncStrategies) ? Maps.newHashMap() : this.fieldConvertFuncStrategies.stream().collect(Collectors.toMap(f -> StringUtils.join((Object[])new String[]{f.getDataType(), f.getFuncType()}), t -> t, (a, b) -> a));
        Map<String, ParameterValueBindingStrategy> parameterValueBindingMap = this.parameterValueBindingStrategies.stream().collect(Collectors.toMap(f -> StringUtils.join((Object[])new String[]{f.getBindType()}), t -> t, (a, b) -> a));
        if (!CollectionUtils.isEmpty((Collection)dynamicExecuteParameters)) {
            block4: for (ExecuteParameter dynamicExecuteParameter : dynamicExecuteParameters) {
                DatabaseExecuteParameter databaseDynamicExecuteParameter = (DatabaseExecuteParameter)dynamicExecuteParameter;
                String targetOpType = databaseDynamicExecuteParameter.getTargetOpType();
                String targetAlias = databaseDynamicExecuteParameter.getTargetAlias();
                String targetTableName = databaseDynamicExecuteParameter.getTargetTableName();
                String targetFieldName = databaseDynamicExecuteParameter.getTargetFieldName();
                String parameterName = databaseDynamicExecuteParameter.getParamName();
                String valueBindType = databaseDynamicExecuteParameter.getValueBindType();
                for (ParameterOperatorBindingStrategy parameterOperatorBindingStrategy : this.parameterOperatorBindingStrategies) {
                    String bindType = parameterOperatorBindingStrategy.getBindType();
                    if (!StringUtils.equals((CharSequence)bindType, (CharSequence)targetOpType)) continue;
                    ParameterValueBindingStrategy valueBindingStrategy = parameterValueBindingMap.get(valueBindType);
                    if (Objects.nonNull(valueBindingStrategy)) {
                        FieldConvertFuncStrategy fieldConvertFuncStrategy = (FieldConvertFuncStrategy)hashMap.get(StringUtils.join((Object[])new String[]{"mysql", valueBindingStrategy.getFieldFuncType()}));
                        databaseDynamicExecuteParameter.setFieldFunc(Objects.nonNull(fieldConvertFuncStrategy) ? fieldConvertFuncStrategy.getFunction() : null);
                    }
                    String fieldFunc = databaseDynamicExecuteParameter.getFieldFunc();
                    String opExpression = parameterOperatorBindingStrategy.expressionWithFieldFunc(targetAlias, targetTableName, targetFieldName, parameterName, fieldFunc);
                    Validate.notBlank((CharSequence)opExpression, (String)"\u672a\u6210\u529f\u6784\u5efa\u6761\u4ef6\u8868\u8fbe\u5f0f[%s]", (Object[])new Object[]{targetFieldName});
                    databaseDynamicExecuteParameter.setTargetOpExpression(opExpression);
                    continue block4;
                }
            }
        }
        allExecuteParameters.addAll(matedataExecuteParameters);
        allExecuteParameters.addAll(dynamicExecuteParameters);
        for (ExecuteParameter executeParameter : allExecuteParameters) {
            databaseExecuteParameter = (DatabaseExecuteParameter)executeParameter;
            if (databaseExecuteParameter.getValue() != null) continue;
            String parameterName = databaseExecuteParameter.getParamName();
            Object bindedValue = null;
            ParameterValueBindingStrategy paramFieldBindingStrategy = parameterValueBindingMap.get(databaseExecuteParameter.getValueBindType());
            if (Objects.nonNull(paramFieldBindingStrategy)) {
                bindedValue = paramFieldBindingStrategy.bindingFieldValue(databaseExecuteParameter, databaseExecuteExternalRequest);
                databaseExecuteParameter.setValue(bindedValue);
            }
            if (databaseExecuteParameter.getNullable().booleanValue()) continue;
            Validate.notNull((Object)bindedValue, (String)"\u8fdb\u884c\u6570\u636e\u89c6\u56fe\u6267\u884c\u65f6[%s]\u53c2\u6570\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u8f6c\u6362\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5ParameterValueBindingStrategy\u7684\u5404\u79cd\u5177\u4f53\u5b9e\u73b0!!", (Object[])new Object[]{parameterName});
        }
        return allExecuteParameters;
    }

    private void validateDynamicExecuteParameters(DatabaseMetaData databaseMetaData, DatabaseExecuteParameter databaseDynamicExecuteParameter) {
        String bindType;
        String resource = databaseDynamicExecuteParameter.getResource();
        String paramName = databaseDynamicExecuteParameter.getParamName();
        String targetAlias = databaseDynamicExecuteParameter.getTargetAlias();
        String targetTableName = databaseDynamicExecuteParameter.getTargetTableName();
        String targetFieldName = databaseDynamicExecuteParameter.getTargetFieldName();
        String targetOpType = databaseDynamicExecuteParameter.getTargetOpType();
        String valueBindType = databaseDynamicExecuteParameter.getValueBindType();
        Object value = databaseDynamicExecuteParameter.getValue();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)resource, (CharSequence)"dynamic"), (String)"\u5728\u6267\u884c\u65f6\uff0c\u53d1\u73b0resource\u4e0d\u4e3a\u201cdynamic\u201d\u7684\u52a8\u6001\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u62e6\u622a\u5668!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)paramName, (String)"\u5728\u6267\u884c\u662f\uff0c\u53d1\u73b0\u52a8\u6001\u67e5\u8be2\u6761\u4ef6\u7684\u8bbe\u5b9a\u4e2d\u7f3a\u5c11\u53c2\u6570\u540d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u62e6\u622a\u5668!", (Object[])new Object[0]);
        int fieldCount = databaseMetaData.getFieldCount();
        List fields = databaseMetaData.getMetaDataFields();
        boolean matched = false;
        for (int i = 0; i < fieldCount; ++i) {
            DatabaseMetaDataField metaDataField = (DatabaseMetaDataField)((Object)fields.get(i));
            String fieldName = metaDataField.getFieldOriginalName();
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                fieldName = metaDataField.getFieldName();
            }
            if (!StringUtils.equals((CharSequence)targetFieldName, (CharSequence)fieldName)) continue;
            matched = true;
            break;
        }
        Validate.isTrue((boolean)matched, (String)"\u5728\u6267\u884c\u65f6\uff0c\u672a\u5728\u5143\u6570\u636e\u7ed3\u6784\u4e2d\u53d1\u73b0\u522b\u540d\u4e3a\u3010%s\u3011\uff0c\u6570\u636e\u8868\u4e3a\u3010%s\u3011\u7684\u5b57\u6bb5\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{targetAlias, targetTableName, targetFieldName});
        matched = false;
        for (ParameterOperatorBindingStrategy parameterOperatorBindingStrategy : this.parameterOperatorBindingStrategies) {
            bindType = parameterOperatorBindingStrategy.getBindType();
            if (!StringUtils.equals((CharSequence)targetOpType, (CharSequence)bindType)) continue;
            matched = true;
            break;
        }
        Validate.isTrue((boolean)matched, (String)"\u5728\u6267\u884c\u65f6\uff0c\u672a\u627e\u5230\u652f\u6301\u7684\u64cd\u4f5c\u7b26[%s]\u8f6c\u6362\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{targetOpType});
        if (value != null) {
            return;
        }
        for (ParameterValueBindingStrategy paramFieldBindingStrategy : this.parameterValueBindingStrategies) {
            bindType = paramFieldBindingStrategy.getBindType();
            if (!StringUtils.equals((CharSequence)valueBindType, (CharSequence)bindType)) continue;
            matched = true;
            break;
        }
        Validate.isTrue((boolean)matched, (String)"\u5728\u6267\u884c\u65f6\uff0c\u672a\u627e\u5230\u652f\u6301\u7684\u503c[%s]\u8f6c\u6362\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{valueBindType});
    }

    private String buildContentSql(String sql, MetaData metaData, List<DatabaseExecuteParameter> executeParameters, List<DatabaseOrderParameter> orderParameters) {
        String targetSql = sql;
        if (!CollectionUtils.isEmpty(executeParameters)) {
            for (DatabaseExecuteParameter executeParameter : executeParameters) {
                if (!executeParameter.getNullable().booleanValue() || executeParameter.getValue() != null) continue;
                targetSql = SQLAnalyzeUtils.analysisAndReplaceVar(targetSql, executeParameter.getParamName());
            }
        }
        if (!CollectionUtils.isEmpty(executeParameters)) {
            List<DatabaseExecuteParameter> dynamicExecuteParameters = executeParameters.stream().filter(item -> StringUtils.equals((CharSequence)item.getResource(), (CharSequence)"dynamic")).collect(Collectors.toList());
            targetSql = SQLAnalyzeUtils.analysisAndCreateWhere(targetSql, dynamicExecuteParameters);
        }
        if (!CollectionUtils.isEmpty(orderParameters)) {
            targetSql = SQLAnalyzeUtils.analysisAndCreateOrder(targetSql, orderParameters);
            targetSql = SQLAnalyzeUtils.enhanceSqlOrder(targetSql, (DatabaseMetaData)metaData);
        }
        return targetSql;
    }

    private String buildCountSql(String sql, MetaData metaData, List<DatabaseExecuteParameter> executeParameters) {
        String targetCountSql = sql;
        if (!CollectionUtils.isEmpty(executeParameters)) {
            for (DatabaseExecuteParameter executeParameter : executeParameters) {
                if (!executeParameter.getNullable().booleanValue() || executeParameter.getValue() != null) continue;
                targetCountSql = SQLAnalyzeUtils.analysisAndReplaceVar(targetCountSql, executeParameter.getParamName());
            }
        }
        if (!CollectionUtils.isEmpty(executeParameters)) {
            List<DatabaseExecuteParameter> dynamicExecuteParameters = executeParameters.stream().filter(item -> StringUtils.equals((CharSequence)item.getResource(), (CharSequence)"dynamic")).collect(Collectors.toList());
            targetCountSql = SQLAnalyzeUtils.analysisAndCreateWhere(targetCountSql, dynamicExecuteParameters);
        }
        targetCountSql = SQLAnalyzeUtils.convertToCountSQL(targetCountSql);
        return targetCountSql;
    }

    private String buildStatisticSql(String sql, MetaData metaData, List<DatabaseExecuteParameter> executeParameters, List<String> statisticFieldNames, DatabaseExecuteExternalRequest invokeParamContent) {
        Object fieldObject;
        String targetStatisticSql = sql;
        if (!CollectionUtils.isEmpty(executeParameters)) {
            for (DatabaseExecuteParameter executeParameter : executeParameters) {
                if (!executeParameter.getNullable().booleanValue() || executeParameter.getValue() != null) continue;
                targetStatisticSql = SQLAnalyzeUtils.analysisAndReplaceVar(targetStatisticSql, executeParameter.getParamName());
            }
        }
        if (!CollectionUtils.isEmpty(executeParameters)) {
            List<DatabaseExecuteParameter> dynamicExecuteParameters = executeParameters.stream().filter(item -> StringUtils.equals((CharSequence)item.getResource(), (CharSequence)"dynamic")).collect(Collectors.toList());
            targetStatisticSql = SQLAnalyzeUtils.analysisAndCreateWhere(targetStatisticSql, dynamicExecuteParameters);
        }
        if (Objects.isNull(fieldObject = invokeParamContent.getAttribute("fieldStatisticInfo"))) {
            targetStatisticSql = null;
        } else {
            FieldStatisticBaseDto statisticBaseDto = (FieldStatisticBaseDto)JSON.parseObject((String)fieldObject.toString(), FieldStatisticBaseDto.class);
            targetStatisticSql = SQLAnalyzeUtils.convertToStatisticSql(targetStatisticSql, metaData, statisticFieldNames, statisticBaseDto);
        }
        return targetStatisticSql;
    }

    public Set<OrderParameter> buildOrderParameters(MetaData metaData, EuropaInfoVo europaInfoVo, RequestParameter requestParameter) {
        DatabaseExecuteExternalRequest databaseExecuteExternalRequest = (DatabaseExecuteExternalRequest)requestParameter;
        DatabaseViewVo databaseView = (DatabaseViewVo)europaInfoVo.getView();
        Set<DatabaseViewOrderVo> databaseViewOrders = databaseView.getDatabaseViewOrders();
        LinkedHashSet allOrderParameters = Sets.newLinkedHashSet();
        if (CollectionUtils.isEmpty(databaseViewOrders)) {
            return allOrderParameters;
        }
        LinkedHashSet resultOrderParameters = Sets.newLinkedHashSet();
        for (DatabaseViewOrderVo databaseViewOrder : databaseViewOrders) {
            String paramName = databaseViewOrder.getParamName();
            String requestParamName = StringUtils.join((Object[])new String[]{"sort.", paramName});
            Object externalRequestValue = databaseExecuteExternalRequest.getAttribute(requestParamName);
            if (externalRequestValue == null) continue;
            String targetOrderType = externalRequestValue.toString();
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)targetOrderType, (CharSequence[])new CharSequence[]{"asc", "desc"})) continue;
            DatabaseOrderParameter databaseOrderParameter = (DatabaseOrderParameter)this.nebulaToolkitService.copyObjectByWhiteList((Object)databaseViewOrder, DatabaseOrderParameter.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            databaseOrderParameter.setTargetOrderType(targetOrderType);
            resultOrderParameters.add(databaseOrderParameter);
        }
        return resultOrderParameters;
    }

    public ExecuteContent buildExecuteContent(MetaData metaData, EuropaInfoVo europaInfoVo, RequestParameter requestParameter, Set<ExecuteParameter> executeParameters, Set<OrderParameter> orderParameters, Integer sqlType) {
        ArrayList databaseExecuteParameters = Lists.newArrayList();
        ArrayList databaseOrderParameters = Lists.newArrayList();
        try {
            if (!CollectionUtils.isEmpty(executeParameters)) {
                executeParameters.stream().forEach(item -> databaseExecuteParameters.add((DatabaseExecuteParameter)item));
            }
            if (!CollectionUtils.isEmpty(orderParameters)) {
                orderParameters.stream().forEach(item -> {
                    if (item instanceof DatabaseOrderParameter) {
                        databaseOrderParameters.add((DatabaseOrderParameter)item);
                    }
                });
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6761\u4ef6\u53c2\u6570\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        try {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Authentication authentication = securityContext.getAuthentication();
            return new ExecuteContentCacheLoader(metaData, europaInfoVo, requestParameter, sqlType, databaseExecuteParameters, databaseOrderParameters, authentication).call();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private DatabaseExecuteContent executeQueryOnlyCount(String countSql, EntityManager currentEntityManager, Map<DatabaseExecuteParameter, ParameterOperatorBindingStrategy> databaseExecutionStrategyMapping, List<DatabaseExecuteParameter> databaseExecuteParameters, DatabaseExecuteExternalRequest invokeParamContent) {
        Query countQuery = null;
        long maxCount = 0L;
        DatabaseExecuteContent databaseExecuteContent = null;
        Pageable pageable = invokeParamContent.getPageable();
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
            invokeParamContent.setPageable(pageable);
        }
        countQuery = currentEntityManager.createNativeQuery(countSql);
        this.bindQuery(countQuery, databaseExecutionStrategyMapping, databaseExecuteParameters);
        List countResults = countQuery.getResultList();
        if (!CollectionUtils.isEmpty((Collection)countResults)) {
            for (Object countObject : countResults) {
                maxCount += ((BigInteger)countObject).longValue();
            }
        }
        databaseExecuteContent = new DatabaseExecuteContent((int)maxCount);
        databaseExecuteContent.setEmpty(false);
        databaseExecuteContent.setNumberOfPage(pageable.getPageSize());
        databaseExecuteContent.setPageable(true);
        databaseExecuteContent.setPageNumber(pageable.getPageNumber());
        databaseExecuteContent.setTotalElements(maxCount);
        databaseExecuteContent.setTotalPages((int)(maxCount / (long)pageable.getPageSize()) + 1);
        return databaseExecuteContent;
    }

    private DatabaseExecuteContent executeQueryStatistic(String statisticSql, EntityManager currentEntityManager, Map<DatabaseExecuteParameter, ParameterOperatorBindingStrategy> databaseExecutionStrategyMapping, List<DatabaseExecuteParameter> databaseExecuteParameters, List<String> statisticFieldNames) {
        Query statisticQuery = null;
        DatabaseExecuteContent databaseExecuteContent = null;
        statisticQuery = currentEntityManager.createNativeQuery(statisticSql);
        this.bindQuery(statisticQuery, databaseExecutionStrategyMapping, databaseExecuteParameters);
        List results = statisticQuery.getResultList();
        if (results == null) {
            results = Lists.newArrayList();
        }
        databaseExecuteContent = new DatabaseExecuteContent(results.size());
        if (CollectionUtils.isEmpty((Collection)results)) {
            databaseExecuteContent.setEmpty(CollectionUtils.isEmpty((Collection)results));
            return databaseExecuteContent;
        }
        if (statisticFieldNames.size() == 1) {
            String fieldName = statisticFieldNames.get(0);
            String fieldContent = results.get(0).toString();
            databaseExecuteContent.setContent(0, fieldName, fieldContent);
        } else {
            List resultObjects = results;
            for (int rowIndex = 0; rowIndex < resultObjects.size(); ++rowIndex) {
                for (int index = 0; index < ((Object[])resultObjects.get(rowIndex)).length; ++index) {
                    String fieldName = statisticFieldNames.get(index);
                    String fieldContent = ((Object[])resultObjects.get(rowIndex))[index].toString();
                    databaseExecuteContent.setContent(rowIndex, fieldName, fieldContent);
                }
            }
        }
        return databaseExecuteContent;
    }

    private DatabaseExecuteContent executeQuery(String contentSql, String countSql, boolean canPageable, MetaData metaData, EuropaInfoVo europaInfoVo, EntityManager currentEntityManager, Map<DatabaseExecuteParameter, ParameterOperatorBindingStrategy> databaseExecutionStrategyMapping, List<DatabaseExecuteParameter> databaseExecuteParameters, DatabaseExecuteExternalRequest invokeParamContent) {
        List countResults;
        List results;
        LOGGER.info("\u6267\u884c\u7684sql:{}", (Object)contentSql);
        Query contentQuery = null;
        Query countQuery = null;
        long maxCount = 0L;
        DatabaseExecuteContent databaseExecuteContent = null;
        contentQuery = currentEntityManager.createNativeQuery(contentSql);
        this.bindQuery(contentQuery, databaseExecutionStrategyMapping, databaseExecuteParameters);
        if (canPageable) {
            Pageable pageable = invokeParamContent.getPageable();
            if (pageable == null) {
                pageable = PageRequest.of((int)0, (int)50);
                invokeParamContent.setPageable(pageable);
            }
            countQuery = currentEntityManager.createNativeQuery(countSql);
            this.bindQuery(countQuery, databaseExecutionStrategyMapping, databaseExecuteParameters);
            contentQuery.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
            contentQuery.setMaxResults(pageable.getPageSize());
        }
        if ((results = contentQuery.getResultList()) == null) {
            results = Lists.newArrayList();
        }
        if (canPageable && !CollectionUtils.isEmpty((Collection)(countResults = countQuery.getResultList()))) {
            for (Object countObject : countResults) {
                maxCount += ((BigInteger)countObject).longValue();
            }
        }
        databaseExecuteContent = new DatabaseExecuteContent(results.size());
        if (europaInfoVo.getPageable().booleanValue()) {
            Pageable pageable = invokeParamContent.getPageable();
            databaseExecuteContent.setEmpty(CollectionUtils.isEmpty((Collection)results));
            databaseExecuteContent.setNumberOfPage(pageable.getPageSize());
            databaseExecuteContent.setPageable(true);
            databaseExecuteContent.setPageNumber(pageable.getPageNumber());
            databaseExecuteContent.setTotalElements(maxCount);
            databaseExecuteContent.setTotalPages((int)(maxCount / (long)pageable.getPageSize()) + (maxCount % (long)pageable.getPageSize() > 0L ? 1 : 0));
        } else {
            databaseExecuteContent.setEmpty(false);
            databaseExecuteContent.setNumberOfPage(results.size());
            databaseExecuteContent.setPageable(false);
            databaseExecuteContent.setPageNumber(0);
            databaseExecuteContent.setTotalElements(results.size());
            databaseExecuteContent.setTotalPages(1);
        }
        if (!CollectionUtils.isEmpty((Collection)results)) {
            for (int rowIndex = 0; rowIndex < results.size(); ++rowIndex) {
                Object[] rowItems = (Object[])results.get(rowIndex);
                for (int index = 0; index < rowItems.length; ++index) {
                    MetaDataField metaDataField = metaData.getMetaDataField(index);
                    String fieldName = metaDataField.getFieldName();
                    Object fieldContent = rowItems[index];
                    databaseExecuteContent.setContent(rowIndex, fieldName, fieldContent);
                }
            }
        }
        LOGGER.info("\u6267\u884c\u7ed3\u679c\u6570\u636e:{}", (Object)databaseExecuteContent);
        return databaseExecuteContent;
    }

    private void bindQuery(Query query, Map<DatabaseExecuteParameter, ParameterOperatorBindingStrategy> databaseExecutionStrategyMapping, List<DatabaseExecuteParameter> databaseExecuteParameters) {
        for (int index = 0; index < databaseExecuteParameters.size(); ++index) {
            DatabaseExecuteParameter databaseExecuteParameter = databaseExecuteParameters.get(index);
            String parameterName = databaseExecuteParameter.getParamName();
            Object value = databaseExecuteParameter.getValue();
            if (databaseExecuteParameter.getNullable().booleanValue() && value == null) continue;
            ParameterOperatorBindingStrategy parameterOperatorBindingStrategy = databaseExecutionStrategyMapping.get(databaseExecuteParameter);
            parameterOperatorBindingStrategy.expressionBind(query, parameterName, value);
        }
    }

    private class ExecuteContentCacheLoader
    implements Callable<DatabaseExecuteContent> {
        private MetaData metaData;
        private EuropaInfoVo europaInfoVo;
        private RequestParameter requestParameter;
        private Integer sqlType;
        private List<DatabaseExecuteParameter> databaseExecuteParameters = null;
        private List<DatabaseOrderParameter> databaseOrderParameters = null;
        private Authentication authentication;

        public ExecuteContentCacheLoader(MetaData metaData, EuropaInfoVo europaInfoVo, RequestParameter requestParameter, Integer sqlType, List<DatabaseExecuteParameter> databaseExecuteParameters, List<DatabaseOrderParameter> databaseOrderParameters, Authentication authentication) {
            this.authentication = authentication;
            this.metaData = metaData;
            this.europaInfoVo = europaInfoVo;
            this.requestParameter = requestParameter;
            this.sqlType = sqlType;
            this.databaseExecuteParameters = databaseExecuteParameters;
            this.databaseOrderParameters = databaseOrderParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DatabaseExecuteContent call() {
            Object targetOpType;
            String dataSourceCode;
            DatabaseExecuteExternalRequest invokeParamContent = (DatabaseExecuteExternalRequest)this.requestParameter;
            if (this.authentication != null) {
                SecurityContext currentSecurityContext = SecurityContextHolder.getContext();
                currentSecurityContext.setAuthentication(this.authentication);
            }
            DatabaseViewVo databaseView = (DatabaseViewVo)this.europaInfoVo.getView();
            Boolean canPageable = this.europaInfoVo.getPageable();
            String sourceSql = AbstractDatabaseExecutionStrategy.this.sourceSql(this.europaInfoVo);
            Validate.notBlank((CharSequence)sourceSql, (String)"\u9519\u8bef\u7684\u6570\u636e\u89c6\u56fe\u539f\u59cbSQL\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            String contentSql = null;
            String statisticSql = null;
            ArrayList statisticFieldNames = Lists.newArrayList();
            if (ExecuteContentSqlTypeEnum.CONTENT_SQL.getStatus().equals(this.sqlType)) {
                contentSql = AbstractDatabaseExecutionStrategy.this.buildContentSql(sourceSql, this.metaData, this.databaseExecuteParameters, this.databaseOrderParameters);
            } else if (ExecuteContentSqlTypeEnum.STATISTIC_SQL.getStatus().equals(this.sqlType)) {
                statisticSql = AbstractDatabaseExecutionStrategy.this.buildStatisticSql(sourceSql, this.metaData, this.databaseExecuteParameters, statisticFieldNames, invokeParamContent);
            }
            String countSql = null;
            if (canPageable.booleanValue() || ExecuteContentSqlTypeEnum.COUNT_SQL.getStatus().equals(this.sqlType)) {
                countSql = AbstractDatabaseExecutionStrategy.this.buildCountSql(sourceSql, this.metaData, this.databaseExecuteParameters);
            }
            if (StringUtils.isBlank((CharSequence)(dataSourceCode = databaseView.getDatasouceCode()))) {
                dataSourceCode = "default";
            }
            String tenantCode = TenantUtils.getTenantCode();
            LinkedHashMap databaseExecutionStrategyMapping = Maps.newLinkedHashMap();
            block6: for (DatabaseExecuteParameter databaseExecuteParameter : this.databaseExecuteParameters) {
                targetOpType = databaseExecuteParameter.getTargetOpType();
                String resource = databaseExecuteParameter.getResource();
                if (StringUtils.equals((CharSequence)resource, (CharSequence)"matedata")) {
                    databaseExecutionStrategyMapping.put(databaseExecuteParameter, new ParameterOperatorBindingStrategyAdapter());
                    continue;
                }
                for (ParameterOperatorBindingStrategy parameterOperatorBindingStrategy : AbstractDatabaseExecutionStrategy.this.parameterOperatorBindingStrategies) {
                    String bindType = parameterOperatorBindingStrategy.getBindType();
                    if (!StringUtils.equals((CharSequence)bindType, (CharSequence)targetOpType)) continue;
                    databaseExecutionStrategyMapping.put(databaseExecuteParameter, parameterOperatorBindingStrategy);
                    continue block6;
                }
            }
            try (EntityManager currentEntityManager = AbstractDatabaseExecutionStrategy.this.cacheEntityManangerService.findByTenantCodeAndDataSourceCode(tenantCode, dataSourceCode);){
                Object object;
                Object externalQueryInterceptorMapping;
                DatabaseExecuteContent databaseExecuteContent = new DatabaseExecuteContent(0);
                if (ExecuteContentSqlTypeEnum.COUNT_SQL.getStatus().equals(this.sqlType)) {
                    databaseExecuteContent = AbstractDatabaseExecutionStrategy.this.executeQueryOnlyCount(countSql, currentEntityManager, databaseExecutionStrategyMapping, this.databaseExecuteParameters, invokeParamContent);
                } else if (ExecuteContentSqlTypeEnum.STATISTIC_SQL.getStatus().equals(this.sqlType)) {
                    if (StringUtils.isBlank((CharSequence)statisticSql) || CollectionUtils.isEmpty((Collection)statisticFieldNames)) {
                        targetOpType = databaseExecuteContent;
                        return targetOpType;
                    }
                    databaseExecuteContent = AbstractDatabaseExecutionStrategy.this.executeQueryStatistic(statisticSql, currentEntityManager, databaseExecutionStrategyMapping, this.databaseExecuteParameters, statisticFieldNames);
                } else {
                    databaseExecuteContent = AbstractDatabaseExecutionStrategy.this.executeQuery(contentSql, countSql, canPageable, this.metaData, this.europaInfoVo, currentEntityManager, databaseExecutionStrategyMapping, this.databaseExecuteParameters, invokeParamContent);
                }
                DatabaseViewVo databaseViewVo = (DatabaseViewVo)this.europaInfoVo.getView();
                Set<DatabaseViewExternalFieldVo> databaseViewExternalFields = databaseViewVo.getDatabaseViewExternalFields();
                if (!CollectionUtils.isEmpty((Collection)AbstractDatabaseExecutionStrategy.this.externalQueryInterceptors) && !CollectionUtils.isEmpty(databaseViewExternalFields)) {
                    externalQueryInterceptorMapping = AbstractDatabaseExecutionStrategy.this.externalQueryInterceptors.stream().collect(Collectors.toMap(ExternalQueryInterceptor::code, item -> item));
                    Map<String, List<DatabaseViewExternalFieldVo>> databaseViewExternalFieldGroups = databaseViewExternalFields.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getInterceptorCode())).collect(Collectors.groupingBy(DatabaseViewExternalFieldVo::getInterceptorCode));
                    for (Map.Entry<String, List<DatabaseViewExternalFieldVo>> databaseViewExternalFieldGroupEntry : databaseViewExternalFieldGroups.entrySet()) {
                        String interceptorCode = databaseViewExternalFieldGroupEntry.getKey();
                        List<String> fieldNames = databaseViewExternalFieldGroupEntry.getValue().stream().map(DatabaseViewExternalFieldVo::getFieldName).collect(Collectors.toList());
                        ExternalQueryInterceptor currentExternalQueryInterceptor = (ExternalQueryInterceptor)externalQueryInterceptorMapping.get(interceptorCode);
                        if (currentExternalQueryInterceptor == null) {
                            LOGGER.warn("not found ExternalQueryInterceptor [{}] ", (Object)interceptorCode);
                            continue;
                        }
                        List<Object[]> externalResutls = currentExternalQueryInterceptor.process(currentEntityManager, this.metaData, this.europaInfoVo, databaseExecuteContent, fieldNames.toArray(new String[0]));
                        LOGGER.info("\u67e5\u8be2\u7ed3\u679c\u96c6:{}", externalResutls);
                        if (CollectionUtils.isEmpty(externalResutls)) continue;
                        List<Map<String, Object>> contentResutls = databaseExecuteContent.getResults();
                        for (int index = 0; index < contentResutls.size() && index < externalResutls.size(); ++index) {
                            Map<String, Object> contentResutlItem = contentResutls.get(index);
                            Object[] externalResutItem = externalResutls.get(index);
                            if (externalResutItem == null || externalResutItem.length == 0) continue;
                            for (int itemIndex = 0; itemIndex < fieldNames.size() && itemIndex < externalResutItem.length; ++itemIndex) {
                                String fieldName = (String)fieldNames.get(itemIndex);
                                contentResutlItem.put(fieldName, externalResutItem[itemIndex]);
                            }
                        }
                    }
                }
                if (CollectionUtils.isEmpty((Collection)AbstractDatabaseExecutionStrategy.this.executeContentInterceptors) || ExecuteContentSqlTypeEnum.COUNT_SQL.getStatus().equals(this.sqlType) || ExecuteContentSqlTypeEnum.STATISTIC_SQL.getStatus().equals(this.sqlType)) {
                    externalQueryInterceptorMapping = databaseExecuteContent;
                    return externalQueryInterceptorMapping;
                }
                Map<String, ExecuteContentInterceptor> executeContentInterceptorMap = AbstractDatabaseExecutionStrategy.this.executeContentInterceptors.stream().collect(Collectors.toMap(ExecuteContentInterceptor::registerCode, item -> item));
                ExecuteContentInterceptor executeContentInterceptor = executeContentInterceptorMap.get(databaseViewVo.getRegisterCode());
                if (ObjectUtils.isEmpty((Object)executeContentInterceptor)) {
                    object = databaseExecuteContent;
                    return object;
                }
                object = executeContentInterceptor.process(databaseExecuteContent);
                return object;
            }
        }
    }
}

