/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.sdk.utils;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.bizunited.nebula.common.dto.FieldStatisticBaseDto;
import com.bizunited.nebula.common.dto.FieldStatisticTypeDto;
import com.bizunited.nebula.common.enums.DataStatisticTypeEnum;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseOrderParameter;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaData;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaDataField;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaDataField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public abstract class SQLAnalyzeUtils {
    public static String convertToParameterSQL(String sql) {
        String patternMathed = "[:]{1}[\\w]+";
        String callableSql = RegExUtils.replaceAll((String)sql, (String)patternMathed, (String)"?");
        return callableSql;
    }

    public static Map<Integer, String> analyzeSQLParametersMapping(String sql) {
        HashMap params = Maps.newHashMap();
        String patternMathed = "[:]{1}[\\w]+";
        Matcher matcher = Pattern.compile(patternMathed).matcher(sql);
        int matcher_start = 0;
        int index = 1;
        while (matcher.find(matcher_start)) {
            matcher_start = matcher.end();
            params.put(index++, StringUtils.substring((String)matcher.group(), (int)1));
        }
        return params;
    }

    public static String analysisAndCreateWhere(String sql, List<DatabaseExecuteParameter> databaseExecuteParameters) {
        List<DatabaseExecuteParameter> databaseExecuteParametersForHaving;
        if (CollectionUtils.isEmpty(databaseExecuteParameters)) {
            return sql;
        }
        String dbType = "postgresql";
        SQLSelectStatement stmt = SQLAnalyzeUtils.analysisQueryBlock(sql, dbType);
        SQLSelect sqlSelect = stmt.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        SQLExpr sqlOldWhere = sqlSelectQuery.getWhere();
        List<DatabaseExecuteParameter> databaseExecuteParametersForWhere = databaseExecuteParameters.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getTargetAlias()) || StringUtils.isNotBlank((CharSequence)item.getTargetTableName())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(databaseExecuteParametersForWhere)) {
            SQLExpr newRightNode = SQLAnalyzeUtils.buildWhereTree(0, databaseExecuteParametersForWhere, dbType);
            SQLBinaryOpExpr rootWhere = new SQLBinaryOpExpr(dbType);
            rootWhere.setRight(newRightNode);
            rootWhere.setLeft(sqlOldWhere);
            rootWhere.setOperator(SQLBinaryOperator.BooleanAnd);
            sqlSelectQuery.setWhere((SQLExpr)rootWhere);
        }
        if (CollectionUtils.isEmpty(databaseExecuteParametersForHaving = databaseExecuteParameters.stream().filter(item -> StringUtils.isAllBlank((CharSequence[])new CharSequence[]{item.getTargetAlias(), item.getTargetTableName()})).collect(Collectors.toList()))) {
            return stmt.toString();
        }
        SQLSelectGroupByClause groupBy = sqlSelectQuery.getGroupBy();
        if (groupBy == null) {
            groupBy = new SQLSelectGroupByClause();
            sqlSelectQuery.setGroupBy(groupBy);
        }
        SQLExpr oldHavingSQLExpr = groupBy.getHaving();
        SQLExpr newHavingSQLExpr = SQLAnalyzeUtils.buildWhereTree(0, databaseExecuteParametersForHaving, dbType);
        if (oldHavingSQLExpr == null) {
            groupBy.setHaving(newHavingSQLExpr);
        } else {
            SQLBinaryOpExpr havingRootSQLExpr = new SQLBinaryOpExpr(dbType);
            havingRootSQLExpr.setRight(newHavingSQLExpr);
            havingRootSQLExpr.setLeft(oldHavingSQLExpr);
            groupBy.setHaving((SQLExpr)havingRootSQLExpr);
        }
        return stmt.toString();
    }

    private static SQLSelectStatement analysisQueryBlock(String sql, String dbType) {
        Validate.notBlank((CharSequence)sql, (String)"\u9519\u8bef\u7684\u6e90SQL\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        List stmtList = SQLUtils.parseStatements((String)sql, (String)dbType);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)stmtList) && stmtList.size() == 1 ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u6e90SQL\u4fe1\u606f\uff08\u591a\u6761\u72ec\u7acbSQL\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        SQLSelectStatement stmt = (SQLSelectStatement)stmtList.get(0);
        return stmt;
    }

    private static SQLExpr buildWhereTree(int index, List<DatabaseExecuteParameter> databaseExecuteParameters, String dbType) {
        DatabaseExecuteParameter databaseExecuteParameter = databaseExecuteParameters.get(index);
        String expression = databaseExecuteParameter.getTargetOpExpression();
        SQLExpr currentSqlExpr = SQLUtils.toSQLExpr((String)expression, (String)dbType);
        if (index + 1 == databaseExecuteParameters.size()) {
            return currentSqlExpr;
        }
        SQLBinaryOpExpr rootNode = new SQLBinaryOpExpr(dbType);
        rootNode.setRight(currentSqlExpr);
        rootNode.setOperator(SQLBinaryOperator.BooleanAnd);
        int currentIndex = index;
        if (currentIndex + 2 < databaseExecuteParameters.size()) {
            rootNode.setLeft(SQLAnalyzeUtils.buildWhereTree(currentIndex + 1, databaseExecuteParameters, dbType));
        } else if (currentIndex + 2 == databaseExecuteParameters.size()) {
            DatabaseExecuteParameter lastDatabaseExecuteParameter = databaseExecuteParameters.get(currentIndex + 1);
            String lastExpression = lastDatabaseExecuteParameter.getTargetOpExpression();
            SQLExpr lastSqlExpr = SQLUtils.toSQLExpr((String)lastExpression, (String)dbType);
            rootNode.setLeft(lastSqlExpr);
        }
        return rootNode;
    }

    public static void main(String[] args) {
        String sql = "select ifnull(tenant_code , 'default') as notdefaultcode , s.id , s.business_code , s.item_key , f.product_code , f.allowcount \r\nfrom  dms_allow_sale_list s\r\nleft join \r\n  (select count(a.allow) as allowcount , a.product_code from dms_allow_sale_list a group by a.product_code) f on f.product_code = s.product_code\r\nwhere f.allowcount = 2 ";
        System.out.println(SQLAnalyzeUtils.convertToCountSQL(sql));
    }

    public static String analysisAndReplaceVar(String sql, String varName) {
        SQLObject parentDeleteNodeObject;
        SQLExpr deleteNode;
        String dbType = "postgresql";
        SQLSelectStatement stmt = SQLAnalyzeUtils.analysisQueryBlock(sql, dbType);
        SQLSelect sqlSelect = stmt.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        SQLBinaryOpExpr sqlOldWhere = (SQLBinaryOpExpr)sqlSelectQuery.getWhere();
        while ((deleteNode = SQLAnalyzeUtils.matchedNodeInWhere((SQLExpr)sqlOldWhere, varName)) != null && (parentDeleteNodeObject = SQLAnalyzeUtils.findParentNodeInWhere(deleteNode)) != null) {
            SQLBinaryOpExpr parentDeleteNode;
            SQLObject grandParentNode;
            if (parentDeleteNodeObject instanceof SQLSelectQueryBlock) {
                sqlSelectQuery.setWhere(null);
                break;
            }
            if (!(parentDeleteNodeObject instanceof SQLBinaryOpExpr) || (grandParentNode = SQLAnalyzeUtils.findParentNodeInWhere((SQLExpr)(parentDeleteNode = (SQLBinaryOpExpr)parentDeleteNodeObject))) == null) break;
            SQLExpr replaceNode = null;
            replaceNode = parentDeleteNode.getLeft() == deleteNode ? parentDeleteNode.getRight() : parentDeleteNode.getLeft();
            if (grandParentNode instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr grandParentNodeExpr = (SQLBinaryOpExpr)grandParentNode;
                if (grandParentNodeExpr.getLeft() == parentDeleteNode) {
                    grandParentNodeExpr.setLeft(replaceNode);
                    replaceNode.setParent((SQLObject)grandParentNodeExpr);
                } else {
                    grandParentNodeExpr.setRight(replaceNode);
                    replaceNode.setParent((SQLObject)grandParentNodeExpr);
                }
            } else if (grandParentNode instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock grandParentNodeBlock = (SQLSelectQueryBlock)grandParentNode;
                grandParentNodeBlock.setWhere(replaceNode);
                replaceNode.setParent((SQLObject)grandParentNodeBlock);
            }
            if ((sqlOldWhere = (SQLBinaryOpExpr)sqlSelectQuery.getWhere()) != null) continue;
            break;
        }
        return stmt.toString();
    }

    private static SQLObject findParentNodeInWhere(SQLExpr currentNode) {
        SQLObject parentObject = currentNode.getParent();
        if (parentObject instanceof SQLBinaryOpExpr || parentObject instanceof SQLSelectQueryBlock) {
            return parentObject;
        }
        return null;
    }

    private static SQLExpr matchedNodeInWhere(SQLExpr currentNode, String varName) {
        String argumentContext;
        SQLMethodInvokeExpr methodInvokeExpr;
        List arguments;
        SQLExpr matchedNode = null;
        if (currentNode instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr currentOpNode = (SQLBinaryOpExpr)currentNode;
            SQLExpr rigthNode = currentOpNode.getRight();
            SQLExpr leftNode = currentOpNode.getLeft();
            matchedNode = SQLAnalyzeUtils.matchedNodeInWhere(rigthNode, varName);
            if (matchedNode != null) {
                return matchedNode;
            }
            return SQLAnalyzeUtils.matchedNodeInWhere(leftNode, varName);
        }
        if (currentNode instanceof SQLInListExpr) {
            SQLInListExpr inListExpr = (SQLInListExpr)currentNode;
            List varExprs = inListExpr.getTargetList();
            if (!CollectionUtils.isEmpty((Collection)varExprs)) {
                for (SQLExpr varExpr : varExprs) {
                    if (!StringUtils.equals((CharSequence)varExpr.toString(), (CharSequence)(":" + varName))) continue;
                    return currentNode;
                }
            }
        } else if (currentNode instanceof SQLVariantRefExpr) {
            SQLVariantRefExpr variantRefExpr = (SQLVariantRefExpr)currentNode;
            if (StringUtils.equals((CharSequence)variantRefExpr.getName(), (CharSequence)(":" + varName))) {
                return (SQLExpr)variantRefExpr.getParent();
            }
        } else if (currentNode instanceof SQLMethodInvokeExpr && !CollectionUtils.isEmpty((Collection)(arguments = (methodInvokeExpr = (SQLMethodInvokeExpr)currentNode).getArguments())) && StringUtils.indexOf((CharSequence)(argumentContext = StringUtils.join((Object[])new List[]{arguments})), (CharSequence)(":" + varName)) != -1) {
            return (SQLExpr)methodInvokeExpr.getParent();
        }
        return null;
    }

    public static String analysisAndCreateOrder(String sql, List<DatabaseOrderParameter> databaseOrderParameters) {
        if (CollectionUtils.isEmpty(databaseOrderParameters)) {
            return sql;
        }
        String dbType = "postgresql";
        SQLSelectStatement stmt = SQLAnalyzeUtils.analysisQueryBlock(sql, dbType);
        SQLSelect sqlSelect = stmt.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        SQLOrderBy sqlOrderBy = sqlSelectQuery.getOrderBy();
        if (sqlOrderBy == null) {
            sqlOrderBy = new SQLOrderBy();
            sqlSelectQuery.setOrderBy(sqlOrderBy);
        }
        for (DatabaseOrderParameter databaseOrderParameter : databaseOrderParameters) {
            String targetAlias = databaseOrderParameter.getTargetAlias();
            String targetTableName = databaseOrderParameter.getTargetTableName();
            String targetFieldName = databaseOrderParameter.getTargetFieldName();
            String targetOrderType = databaseOrderParameter.getTargetOrderType();
            SQLExpr expr = null;
            expr = StringUtils.isNotBlank((CharSequence)targetAlias) ? SQLUtils.toSQLExpr((String)StringUtils.join((Object[])new String[]{targetAlias, ".", targetFieldName}), (String)dbType) : (StringUtils.isNotBlank((CharSequence)targetTableName) ? SQLUtils.toSQLExpr((String)StringUtils.join((Object[])new String[]{targetTableName, ".", targetFieldName}), (String)dbType) : SQLUtils.toSQLExpr((String)targetFieldName, (String)dbType));
            SQLSelectOrderByItem sqlSelectOrderByItem = new SQLSelectOrderByItem(expr);
            if (StringUtils.equalsIgnoreCase((CharSequence)targetOrderType, (CharSequence)"ASC")) {
                sqlSelectOrderByItem.setType(SQLOrderingSpecification.ASC);
            } else {
                sqlSelectOrderByItem.setType(SQLOrderingSpecification.DESC);
            }
            sqlOrderBy.addItem(sqlSelectOrderByItem);
        }
        return stmt.toString();
    }

    public static String enhanceSqlOrder(String sql, DatabaseMetaData metaData) {
        if (CollectionUtils.isEmpty(metaData.getPrimaryKeyFields())) {
            return sql;
        }
        String dbType = "postgresql";
        SQLSelectStatement stmt = SQLAnalyzeUtils.analysisQueryBlock(sql, dbType);
        SQLSelect sqlSelect = stmt.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        String tableAlis = SQLAnalyzeUtils.analysisMajorTable(sqlSelectQuery.getFrom());
        List<DatabaseMetaDataField> mainTablePrimaryKeyFields = metaData.getPrimaryKeyFields().stream().filter(dataField -> Objects.equals(tableAlis, dataField.getAlias())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mainTablePrimaryKeyFields)) {
            return sql;
        }
        SQLSelectGroupByClause groupBy = sqlSelectQuery.getGroupBy();
        if (Objects.nonNull(groupBy)) {
            return sql;
        }
        SQLOrderBy sqlOrderBy = sqlSelectQuery.getOrderBy();
        if (Objects.isNull(sqlOrderBy)) {
            return sql;
        }
        List sortFieldList = sqlOrderBy.getItems().stream().map(orderByItem -> {
            SQLExpr expr = orderByItem.getExpr();
            String sortFieldName = null;
            if (expr instanceof SQLIdentifierExpr) {
                sortFieldName = ((SQLIdentifierExpr)expr).getName();
            } else if (expr instanceof SQLPropertyExpr) {
                sortFieldName = ((SQLPropertyExpr)expr).getName();
            }
            return sortFieldName;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List orderTypeList = sqlOrderBy.getItems().stream().map(SQLSelectOrderByItem::getType).collect(Collectors.toList());
        SQLOrderingSpecification mainTablePrimaryKeyOrderType = CollectionUtils.isEmpty(orderTypeList) ? SQLOrderingSpecification.DESC : (SQLOrderingSpecification)orderTypeList.get(0);
        mainTablePrimaryKeyFields.forEach(dataField -> {
            if (!sortFieldList.contains(dataField.getFieldName())) {
                sqlOrderBy.addItem(new SQLSelectOrderByItem(SQLUtils.toSQLExpr((String)StringUtils.join((Object[])new String[]{dataField.getAlias(), ".", dataField.getFieldName()}), (String)dbType), mainTablePrimaryKeyOrderType));
            }
        });
        return stmt.toString();
    }

    public static String analysisMajorTable(SQLTableSource fromSQLTableSource) {
        if (fromSQLTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)fromSQLTableSource;
            SQLExpr sqlExpr = sqlExprTableSource.getExpr();
            if (sqlExpr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)sqlExpr;
                String tableName = sqlIdentifierExpr.getName();
                return StringUtils.isNotBlank((CharSequence)sqlExprTableSource.getAlias()) ? sqlExprTableSource.getAlias() : tableName;
            }
        } else if (fromSQLTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)fromSQLTableSource;
            SQLTableSource leftSQLTableSource = sqlJoinTableSource.getLeft();
            return SQLAnalyzeUtils.analysisMajorTable(leftSQLTableSource);
        }
        return null;
    }

    public static String convertToCountSQL(String sql) {
        SQLSelectStatement stmt = SQLAnalyzeUtils.analysisQueryBlock(sql, "postgresql");
        SQLSelect sqlSelect = stmt.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        boolean having = false;
        SQLSelectGroupByClause selectGroupBy = sqlSelectQuery.getGroupBy();
        boolean bl = having = selectGroupBy != null;
        if (!having) {
            SQLAnalyzeUtils.convertToCountSQLForNowrap(sqlSelectQuery);
            return stmt.toString();
        }
        return SQLAnalyzeUtils.convertToCountSQLForWrap(stmt);
    }

    public static void convertToCountSQLForNowrap(SQLSelectQueryBlock sqlSelectQuery) {
        List selectItem = sqlSelectQuery.getSelectList();
        String distinctExpr = null;
        if (sqlSelectQuery.isDistinct()) {
            SQLSelectItem firstSQLSelectItem = (SQLSelectItem)selectItem.get(0);
            if (firstSQLSelectItem != null && firstSQLSelectItem.getExpr() instanceof SQLPropertyExpr) {
                SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)firstSQLSelectItem.getExpr();
                String propertyName = sqlPropertyExpr.getName();
                String propertyOwnernName = sqlPropertyExpr.getOwnernName();
                distinctExpr = StringUtils.isNotBlank((CharSequence)propertyOwnernName) && StringUtils.equals((CharSequence)propertyName, (CharSequence)"*") ? StringUtils.join((Object[])new String[]{"count(distinct ", propertyOwnernName, ".id)"}) : (StringUtils.isNotBlank((CharSequence)propertyOwnernName) && !StringUtils.equals((CharSequence)propertyName, (CharSequence)"*") ? StringUtils.join((Object[])new String[]{"count(distinct ", propertyOwnernName, ".", propertyName, ")"}) : (StringUtils.isBlank((CharSequence)propertyOwnernName) && StringUtils.equals((CharSequence)propertyName, (CharSequence)"*") ? StringUtils.join((Object[])new String[]{"count(distinct id)"}) : StringUtils.join((Object[])new String[]{"count(distinct ", propertyName, ")"})));
            }
        } else {
            distinctExpr = "count(*)";
        }
        sqlSelectQuery.setDistionOption(0);
        selectItem.clear();
        SQLExpr sqlExpr = SQLUtils.toSQLExpr((String)distinctExpr);
        SQLSelectItem countSQLSelectItem = new SQLSelectItem(sqlExpr);
        selectItem.add(countSQLSelectItem);
    }

    public static String convertToCountSQLForWrap(SQLSelectStatement stmt) {
        SQLSelect sqlSelect = stmt.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        sqlSelectQuery.setOrderBy(null);
        sqlSelectQuery.setOrderBySiblings(null);
        String sql = "select count(*) countresult from (" + stmt.toString() + ") countresultTable ";
        return sql;
    }

    public static String convertToStatisticSql(String sql, MetaData metaData, List<String> statisticFieldNames, FieldStatisticBaseDto statisticBaseDto) {
        SQLSelectStatement stmt = SQLAnalyzeUtils.analysisQueryBlock(sql, "postgresql");
        List fieldStatisticTypes = statisticBaseDto.getFieldTypes();
        if (CollectionUtils.isEmpty((Collection)fieldStatisticTypes)) {
            return null;
        }
        ArrayList selectFields = Lists.newArrayList();
        for (FieldStatisticTypeDto statisticTypeDto : fieldStatisticTypes) {
            String targetFieldName;
            MetaDataField metaDataField;
            Set statisticTypes = statisticTypeDto.getStatisticTypes();
            if (CollectionUtils.isEmpty((Collection)statisticTypes) || Objects.isNull(metaDataField = metaData.getMetaDataField(targetFieldName = statisticTypeDto.getField()))) continue;
            for (String type : statisticTypes) {
                DataStatisticTypeEnum typeEnum = DataStatisticTypeEnum.getByCode((String)type);
                if (Objects.isNull(typeEnum)) continue;
                String fieldName = String.format("%s%s", targetFieldName, typeEnum.getCode());
                if (DataStatisticTypeEnum.AVERAGE.equals((Object)typeEnum)) {
                    selectFields.add(String.format("ifnull(avg(ifnull(srt.%s,0)),0) %s", targetFieldName, fieldName));
                    statisticFieldNames.add(fieldName);
                    continue;
                }
                if (!DataStatisticTypeEnum.SUMMATION.equals((Object)typeEnum)) continue;
                selectFields.add(String.format("ifnull(sum(ifnull(srt.%s,0)),0) %s", targetFieldName, fieldName));
                statisticFieldNames.add(fieldName);
            }
        }
        if (CollectionUtils.isEmpty((Collection)selectFields)) {
            return null;
        }
        String selectFiled = String.join((CharSequence)",", selectFields);
        SQLSelect sqlSelect = stmt.getSelect();
        SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
        sqlSelectQuery.setOrderBy(null);
        sqlSelectQuery.setOrderBySiblings(null);
        return String.format("select %s from (%s) srt", selectFiled, stmt.toString());
    }
}

