/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.sdk.strategy;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.datasource.service.internal.AppDataSourceCacheProvider;
import com.bizunited.nebula.europa.database.sdk.service.DatabaseSourceService;
import com.bizunited.nebula.europa.database.sdk.service.MetaDataResolver;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.internal.util.collections.ConcurrentReferenceHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractDatabasePreExecutionStrategy {
    @Autowired
    private DatabaseSourceService databaseSourceService;
    @Autowired
    private AppDataSourceCacheProvider appDataSourceCacheProvider;
    @Autowired
    private Set<MetaDataResolver> metaDataResolvers;
    private static ConcurrentReferenceHashMap<String, MetaData> cacheQueryMetaDataMapping = new ConcurrentReferenceHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDatabasePreExecutionStrategy.class);

    protected MetaData doPreExecution(String dataSourceCode, String sql) {
        String key = StringUtils.join((Object[])new String[]{dataSourceCode, "_", sql});
        MetaData resultQueryMetaData = (MetaData)cacheQueryMetaDataMapping.get((Object)key);
        if (resultQueryMetaData != null) {
            MetaData copy = this.copy(resultQueryMetaData);
            return copy;
        }
        DataSource currentDataSource = null;
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)dataSourceCode, (CharSequence[])new CharSequence[]{"default"})) {
            String appCode = TenantUtils.getTenantCode();
            currentDataSource = this.appDataSourceCacheProvider.findDataSource(appCode);
        } else {
            String tenantCode = TenantUtils.getTenantCode();
            currentDataSource = this.databaseSourceService.cacheByCodeAndTenantCode(dataSourceCode, tenantCode);
        }
        Validate.notNull((Object)currentDataSource, (String)"\u9884\u6267\u884c\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f!!", (Object[])new Object[0]);
        MetaDataResolver matchedMetaDataResolver = null;
        for (MetaDataResolver metaDataResolver : this.metaDataResolvers) {
            if (!metaDataResolver.validate(currentDataSource)) continue;
            matchedMetaDataResolver = metaDataResolver;
            break;
        }
        Validate.notNull(matchedMetaDataResolver, (String)"\u672a\u627e\u5230\u9002\u5408\u5f53\u524d\u6570\u636e\u6e90\u7684\u5143\u6570\u636e\u7ed3\u6784\u89e3\u6790\u5668\uff0c\u8bf7\u521b\u5efa\u5339\u914d\u7684MetaDataResolver!!", (Object[])new Object[0]);
        MetaData queryMetaData = null;
        try (Connection currentConnection = currentDataSource.getConnection();){
            queryMetaData = matchedMetaDataResolver.resolver(currentConnection, sql);
            cacheQueryMetaDataMapping.put((Object)key, (Object)queryMetaData);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u6570\u636e\u89c6\u56fe\u9884\u6267\u884c\u9519\u8bef\uff0c\u53ef\u80fd\u662fSQL\u8bed\u6cd5\u4e0d\u7b26\u5408\u8981\u6c42[%s]\uff0c\u8bf7\u68c0\u67e5!!", e.getMessage()));
        }
        MetaData copy = this.copy(queryMetaData);
        return copy;
    }

    /*
     * Exception decompiling
     */
    private MetaData copy(MetaData queryMetaData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaData readCopy(byte[] objectContent) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(objectContent));){
            MetaData metaData = (MetaData)ois.readObject();
            return metaData;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u5143\u6570\u636e\u6269\u5c55\u4fe1\u606f\u4e2d\u5b58\u5728\u4e0d\u80fd\u5e8f\u5217\u5316\u7684\u5c5e\u6027\u503c\uff0c\u8bf7\u68c0\u67e5!!");
        }
    }
}

