/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.sdk.context.execute;

import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class DatabaseExecuteContent
implements ExecuteContent {
    private Boolean pageable = false;
    private Boolean empty = true;
    private int totalPages = 1;
    private long totalElements = 0L;
    private int pageNumber = 0;
    private int numberOfPage = 50;
    private int currentRowNumber = 0;
    private List<Map<String, Object>> results;

    public DatabaseExecuteContent(int currentRowNumber) {
        Validate.isTrue((currentRowNumber >= 0 ? 1 : 0) != 0, (String)"\u521b\u5efa\u6570\u636e\u89c6\u56fe\u67e5\u8be2\u5185\u5bb9\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\u503c!!", (Object[])new Object[0]);
        this.currentRowNumber = currentRowNumber;
        this.results = Lists.newArrayList();
        if (currentRowNumber > 0) {
            for (int index = 0; index < currentRowNumber; ++index) {
                this.results.add(null);
            }
        }
    }

    public Boolean getPageable() {
        return this.pageable;
    }

    public Boolean getEmpty() {
        return this.empty;
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getNumberOfPage() {
        return this.numberOfPage;
    }

    public void setContent(int rowIndex, String fieldName, Object content) {
        Validate.isTrue((rowIndex < this.currentRowNumber ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u884c\u7d22\u5f15\u53f7", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"\u9519\u8bef\u7684\u5217\u540d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedHashMap rowMapping = null;
        rowMapping = this.results.get(rowIndex);
        if (rowMapping == null) {
            rowMapping = Maps.newLinkedHashMap();
            this.results.set(rowIndex, rowMapping);
        }
        rowMapping.put(fieldName, content);
    }

    public void setPageable(Boolean pageable) {
        this.pageable = pageable;
    }

    public void setEmpty(Boolean empty) {
        this.empty = empty;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setNumberOfPage(int numberOfPage) {
        this.numberOfPage = numberOfPage;
    }

    public String toString() {
        return "DatabaseExecuteContent{pageable=" + this.pageable + ", empty=" + this.empty + ", totalPages=" + this.totalPages + ", totalElements=" + this.totalElements + ", pageNumber=" + this.pageNumber + ", numberOfPage=" + this.numberOfPage + ", currentRowNumber=" + this.currentRowNumber + ", results=" + this.results + '}';
    }
}

