/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.database.sdk.context.matedata;

import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaDataField;
import com.bizunited.nebula.europa.database.sdk.context.matedata.DatabaseMetaDataParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.AbstractMetaData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class DatabaseMetaData
extends AbstractMetaData {
    private static final long serialVersionUID = -5375454613225491481L;
    private TreeMap<Integer, DatabaseMetaDataParameter> parameterMappings = Maps.newTreeMap((Comparator)new DatabaseQueryMetaDataComparator());
    private List<DatabaseMetaDataField> primaryKeyFields = Lists.newArrayList();

    public DatabaseMetaData(String sourceType) {
        super(sourceType);
    }

    public void addParameter(int index, String parameterName, String parameterClassName) {
        Validate.isTrue((index >= 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u6761\u4ef6\u7684\u7d22\u5f15\u4f4d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parameterName, (String)"\u67e5\u8be2\u6761\u4ef6\u7684\u540d\u79f0\uff0c\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parameterClassName, (String)"\u67e5\u8be2\u6761\u4ef6\u7684\u5bf9\u5e94\u7c7b\u578b\uff0c\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((this.parameterMappings.get(index) == null ? 1 : 0) != 0, (String)"\u4e00\u4e2a\u7d22\u5f15\u4f4d\u53ea\u80fd\u6dfb\u52a0\u4e00\u6b21", (Object[])new Object[0]);
        Collection<DatabaseMetaDataParameter> parameters = this.parameterMappings.values();
        if (!CollectionUtils.isEmpty(parameters)) {
            for (DatabaseMetaDataParameter item : parameters) {
                String itemName = item.getParameterName();
                String itemClassName = item.getParameterClassName();
                if (!StringUtils.equals((CharSequence)itemName, (CharSequence)parameterName)) continue;
                Validate.isTrue((boolean)StringUtils.equals((CharSequence)itemClassName, (CharSequence)parameterClassName), (String)"\u540c\u4e00\u4e2aparameterName\u540d\u5b57\u53ef\u4ee5\u6dfb\u52a0\u591a\u6b21\uff0c\u4f46\u662f\u6bcf\u4e00\u6b21\u6dfb\u52a0\u65f6\uff0c\u5176parameterClassName\u4fe1\u606f\u5fc5\u987b\u4e00\u81f4", (Object[])new Object[0]);
            }
        }
        DatabaseMetaDataParameter currentQueryParameter = new DatabaseMetaDataParameter();
        currentQueryParameter.setIndex(index);
        currentQueryParameter.setParameterClassName(parameterClassName);
        currentQueryParameter.setParameterName(parameterName);
        this.parameterMappings.put(index, currentQueryParameter);
    }

    public Collection<DatabaseMetaDataParameter> getParameters() {
        return this.parameterMappings.values();
    }

    public List<DatabaseMetaDataField> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public void setPrimaryKeyFields(List<DatabaseMetaDataField> primaryKeyFields) {
        this.primaryKeyFields = primaryKeyFields;
    }

    private static class DatabaseQueryMetaDataComparator
    implements Serializable,
    Comparator<Integer> {
        private static final long serialVersionUID = 67331616298107342L;

        private DatabaseQueryMetaDataComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            o1 = o2;
            return o1;
        }
    }
}

