/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.sdk.dto.EuropaInfoDto;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="EuropaInfoVoController", tags={"\u6570\u636e\u67e5\u8be2\u5f15\u64ce\uff08\u6b27\u7f57\u5df4\uff09\u7ba1\u7406\u76f8\u5173\u7684http\u63a5\u53e3\u8c03\u7528"})
@RestController
@RequestMapping(value={"/v1/europa/europaInfos"})
public class EuropaInfoVoController
extends BaseController {
    @Autowired
    private EuropaInfoVoService europaInfoVoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(EuropaInfoVoController.class);

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u6570\u636e\u67e5\u8be2\u5f15\u64ce")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@RequestBody JSONObject content) {
        try {
            EuropaInfoVo europaInfoVo = this.europaInfoVoService.create(content);
            return this.buildHttpResultW(europaInfoVo, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4e00\u4e2a\u5df2\u6709\u7684\u6570\u636e\u67e5\u8be2\u5f15\u64ce")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestBody JSONObject content) {
        try {
            EuropaInfoVo europaInfoVo = this.europaInfoVoService.update(content);
            return this.buildHttpResultW(europaInfoVo, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u542f\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u6570\u636e\u67e5\u8be2\u5f15\u64ce")
    @RequestMapping(value={"/enable"}, method={RequestMethod.POST})
    public ResponseModel enable(@RequestParam(value="id") String id) {
        try {
            this.europaInfoVoService.enable(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u6570\u636e\u67e5\u8be2\u5f15\u64ce")
    @RequestMapping(value={"/disable"}, method={RequestMethod.POST})
    public ResponseModel disable(@RequestParam(value="id") String id) {
        try {
            this.europaInfoVoService.disable(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664\u67d0\u4e00\u4e2a\u6307\u5b9a\u7684\u6570\u636e\u67e5\u8be2\u5f15\u64ce")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseModel delete(@RequestParam(value="id") String id) {
        try {
            this.europaInfoVoService.delete(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e8c\u7ea7\u79df\u6237\u4fe1\u606f\u3001\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u67e5\u8be2\u6267\u884c\u7684\u6570\u636e\u89c6\u56fe\u548c\u4ed6\u6240\u6709\u7684\u5173\u8054\u4fe1\u606f")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(value="code") String code) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            EuropaInfoVo europaInfo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, code);
            return this.buildHttpResult(europaInfo);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8fdb\u884c\u7b80\u5355\u7684\u6570\u636e\u89c6\u56fe\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(value="\u5206\u9875\u53c2\u6570") @PageableDefault(size=50) Pageable pageable, EuropaInfoDto europaInfoDto) {
        try {
            Page resutls = this.europaInfoVoService.findByConditions(pageable, europaInfoDto);
            return this.buildHttpResultW(resutls, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

