/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.ExecutionService;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.ExecutionInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ExecutionController", tags={"\u6570\u636e\u67e5\u8be2\u5f15\u64ce\uff08\u6b27\u7f57\u5df4\uff09\u6b63\u5f0f\u6267\u884c\u7684http\u63a5\u53e3\u8c03\u7528"})
@RestController
@RequestMapping(value={"/v1/europa/execution"})
public class ExecutionController
extends BaseController {
    @Autowired
    private EuropaInfoVoService europaInfoVoService;
    @Autowired
    private ExecutionService executionService;
    @Autowired
    private Set<ExecutionStrategy> executionStrategies;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionController.class);
    private static final String EUROPA_CODE_PARAMETER_NAME = "europaInfoCode";

    @ApiOperation(value="\u6570\u636e\u67e5\u8be2\u5f15\u64ce\u6b63\u5f0f\u6267\u884c\u63a5\u53e3")
    @RequestMapping(value={"/execution"}, method={RequestMethod.POST})
    public ResponseModel execution(HttpServletRequest request, @ApiParam(value="\u5206\u9875\u53c2\u6570") @PageableDefault(size=50) Pageable pageable) {
        try {
            String europaInfoCode = request.getParameter(EUROPA_CODE_PARAMETER_NAME);
            Validate.notBlank((CharSequence)europaInfoCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
            String tenantCode = TenantUtils.getTenantCode();
            EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
            Validate.notNull((Object)europaInfoVo, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            ExecutionStrategy matchedExecutionStrategy = null;
            for (ExecutionStrategy executionStrategy : this.executionStrategies) {
                if (!executionStrategy.validate(europaInfoVo)) continue;
                matchedExecutionStrategy = executionStrategy;
                break;
            }
            Validate.notNull(matchedExecutionStrategy, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c6\u56fe\u6570\u636e", (Object[])new Object[0]);
            RequestParameter requestParameter = matchedExecutionStrategy.buildRequestParameter(europaInfoVo, request, pageable);
            ExecutionInfo executionInfo = this.executionService.execution(europaInfoVo, pageable, requestParameter, matchedExecutionStrategy);
            return this.buildHttpResult(executionInfo);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6570\u636e\u67e5\u8be2\u5f15\u64ce\u6b63\u5f0f\u6267\u884c\u7edf\u8ba1\u63a5\u53e3")
    @RequestMapping(value={"/executionStatistic"}, method={RequestMethod.POST})
    public ResponseModel executionStatistic(HttpServletRequest request) {
        try {
            String europaInfoCode = request.getParameter(EUROPA_CODE_PARAMETER_NAME);
            Validate.notBlank((CharSequence)europaInfoCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
            String tenantCode = TenantUtils.getTenantCode();
            EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
            Validate.notNull((Object)europaInfoVo, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            ExecutionStrategy matchedExecutionStrategy = null;
            for (ExecutionStrategy executionStrategy : this.executionStrategies) {
                if (!executionStrategy.validate(europaInfoVo)) continue;
                matchedExecutionStrategy = executionStrategy;
                break;
            }
            Validate.notNull(matchedExecutionStrategy, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c6\u56fe\u6570\u636e", (Object[])new Object[0]);
            RequestParameter requestParameter = matchedExecutionStrategy.buildRequestParameter(europaInfoVo, request, null);
            ExecutionInfo executionInfo = this.executionService.executionStatistic(europaInfoVo, requestParameter, matchedExecutionStrategy);
            Object resultObject = null;
            if (Objects.nonNull(executionInfo) && Objects.nonNull(executionInfo.getExecuteContent()) && !CollectionUtils.isEmpty((Collection)executionInfo.getExecuteContent().getResults())) {
                resultObject = executionInfo.getExecuteContent().getResults().get(0);
            }
            return this.buildHttpResult(resultObject);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

