/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.europa.sdk.service.PersonalizationTemplateVoService;
import com.bizunited.nebula.europa.sdk.vo.PersonalizationTemplateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="PersonalizationTemplateController", tags={"\u6570\u636e\u67e5\u8be2\u5f15\u64ce\uff08\u6b27\u7f57\u5df4\uff09\u4e2a\u6027\u5316\u6837\u5f0f\u8bbe\u5b9a\u7ba1\u7406\u76f8\u5173\u7684http\u63a5\u53e3\u8c03\u7528"})
@RestController
@RequestMapping(value={"/v1/europa/personalizations"})
public class PersonalizationTemplateController
extends BaseController {
    @Autowired
    private PersonalizationTemplateVoService personalizationTemplateVoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonalizationTemplateController.class);

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u4e2a\u6027\u5316\u8bbe\u5b9a\u6837\u5f0f")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@RequestBody JSONObject jsonObject) {
        try {
            PersonalizationTemplateVo personalizationTemplate = (PersonalizationTemplateVo)JSONObject.toJavaObject((JSON)jsonObject, PersonalizationTemplateVo.class);
            this.personalizationTemplateVoService.create(personalizationTemplate);
            return this.buildHttpResultW(personalizationTemplate, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4e00\u4e2a\u65b0\u7684\u4e2a\u6027\u5316\u8bbe\u5b9a\u6837\u5f0f")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestBody JSONObject jsonObject) {
        try {
            PersonalizationTemplateVo personalizationTemplate = (PersonalizationTemplateVo)JSONObject.toJavaObject((JSON)jsonObject, PersonalizationTemplateVo.class);
            this.personalizationTemplateVoService.update(personalizationTemplate);
            return this.buildHttpResultW(personalizationTemplate, new String[0]);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8fd4\u56de\u5f53\u524d\u64cd\u4f5c\u8005\u5bf9\u67d0\u4e00\u4e2a\u6570\u636e\u89c6\u56fe\u6700\u5339\u914d\u7684\uff08\u4f18\u5148\u7ea7\u6700\u9ad8\u7684\uff09\u5c55\u793a\u6837\u5f0f\u6a21\u677f\u4fe1\u606f\uff08\u5176\u5b83\u4f18\u5148\u7ea7\u8f83\u4f4e\u7684\u90fd\u4e0d\u4f1a\u5c55\u793a\uff09\u3002", notes="\u5982\u679c\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u4e2a\u6027\u5316\u6837\u5f0f\u6a21\u677f\u4fe1\u606f\uff0c\u5219\u6309\u7167\u6307\u5b9a\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u7684\u9ed8\u8ba4\u5c55\u793a\u6837\u5f0f\u4fe1\u606f\u8fdb\u884c\u8fd4\u56de")
    @RequestMapping(value={"/findEffectiveByCurrentUser"}, method={RequestMethod.GET})
    public ResponseModel findEffectiveByCurrentUser(@RequestParam(value="europaInfoCode") String europaInfoCode) {
        try {
            PersonalizationTemplateVo personalizationTemplate = this.personalizationTemplateVoService.findEffectiveByCurrentUser(europaInfoCode);
            return this.buildHttpResult(personalizationTemplate);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8fd4\u56de\u5f53\u524d\u64cd\u4f5c\u8005\u5bf9\u67d0\u4e00\u4e2a\u6570\u636e\u89c6\u56fe\u5339\u914d\u7684\u6240\u6709\u5c55\u793a\u6837\u5f0f\u6a21\u677f\u4fe1\u606f\u3002")
    @RequestMapping(value={"/findDetailsByEuropaInfoCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByEuropaInfoCode(@RequestParam(value="europaInfoCode") String europaInfoCode) {
        try {
            Set personalizationTemplates = this.personalizationTemplateVoService.findDetailsByEuropaInfoCode(europaInfoCode);
            return this.buildHttpResult(personalizationTemplates);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e2a\u6027\u5316\u8bbe\u5b9a\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7\uff0c\u8fd4\u56de\u8fd9\u4e2a\u4e2a\u6027\u5316\u8bbe\u5b9a\u4fe1\u606f\u5df2\u7ecf\u5173\u8054\u7684\u6240\u6709\u4e1a\u52a1\u7ef4\u5ea6\u4fe1\u606f")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@RequestParam(value="code") String code) {
        try {
            PersonalizationTemplateVo personalizationTemplate = this.personalizationTemplateVoService.findDetailsByCode(code);
            return this.buildHttpResult(personalizationTemplate);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

