/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.europa.local.notifier;

import com.bizunited.nebula.europa.sdk.service.PersonalizationTemplateVoService;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CacheRedisMessageForPersonalizationTemplateListenerImpl")
public class CacheRedisMessageForPersonalizationTemplateListenerImpl
implements MessageListener<String> {
    @Autowired
    private PersonalizationTemplateVoService personalizationTemplateVoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheRedisMessageForPersonalizationTemplateListenerImpl.class);

    public void onMessage(CharSequence channel, String tenantCodeAndEuropaInfoCode) {
        LOGGER.info("personalization Template identity notifing ......");
        String[] tenantCodeAndCodeArray = StringUtils.split((String)tenantCodeAndEuropaInfoCode, (String)"|");
        if (tenantCodeAndCodeArray == null || tenantCodeAndCodeArray.length != 2) {
            LOGGER.warn("personalization Template identity string format error ......");
            return;
        }
        String tenantCode = tenantCodeAndCodeArray[0];
        String europaInfoCode = tenantCodeAndCodeArray[1];
        if (!StringUtils.isBlank((CharSequence)tenantCode)) {
            this.personalizationTemplateVoService.clearCache(tenantCode, europaInfoCode);
        }
    }
}

